package cn.elwy.common.entity;

import java.util.List;

/**
 * Mybatis分页参数及查询结果封装. 注意所有序号从1开始.
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class Page<E> implements Pageable<E> {

	private static final long serialVersionUID = 1L;

	/** 当前页 */
	private int pageNo = 1;
	/** 页大小 : 每页的数量 */
	private int pageSize = 15;
	/** 总条数 */
	private long totalRecord;
	/** 总页数 */
	private int totalPage;
	/** 偏移量 : 第一条数据在表中的位置 */
	private int offset;
	/** 限定数 : 每页的数量 */
	private int limit = pageSize;

	/** 查询结果 */
	private List<E> datas;

	public Page() {
	}

	public Page(int pageNo, int pageSize) {
		setPage(pageNo, pageSize);
	}

	public void setPage(int pageNo, int pageSize) {
		this.pageNo = pageNo;
		this.pageSize = pageSize;
		this.calcOffset();
		this.calcLimit();
	}

	/**
	 * 计算偏移量
	 */
	private void calcOffset() {
		this.offset = ((pageNo - 1) * pageSize);
	}

	/**
	 * 计算限定数
	 */
	private void calcLimit() {
		this.limit = pageSize;
	}

	/**
	 * 获得当前页的页号,序号从1开始,默认为1.
	 */
	public int getPageNo() {
		return pageNo;
	}

	/**
	 * 获得每页的记录数量,默认为1.
	 */
	public int getPageSize() {
		return pageSize;
	}

	/**
	 * 根据pageNo和pageSize计算当前页第一条记录在总结果集中的位置,序号从0开始.
	 */
	public int getOffset() {
		return offset;
	}

	public int getLimit() {
		return limit;
	}

	/**
	 * 取得页内的记录列表.
	 */
	public List<E> getDatas() {
		return datas;
	}

	/**
	 * 设置页内的记录列表.
	 */
	public void setDatas(final List<E> datas) {
		this.datas = datas;
	}

	/**
	 * 取得总记录数, 默认值为-1.
	 */
	public long getTotalRecord() {
		return totalRecord;
	}

	/**
	 * 设置总记录数.
	 */
	public void setTotalRecord(final long totalCount) {
		this.totalRecord = totalCount;
		this.totalPage = this.calcTotalPage();
	}

	/**
	 * 根据pageSize与totalCount计算总页数, 默认值为-1.
	 */
	public int calcTotalPage() {
		if (totalRecord < 0) {
			return -1;
		}
		int pages = (int) (totalRecord / pageSize);
		return totalRecord % pageSize > 0 ? ++pages : pages;
	}

	public int getTotalPage() {
		return totalPage;
	}

	public void setTotalPage(int totalPage) {
		this.totalPage = totalPage;
	}

	@Override
	public String toString() {
		return "Page [pageNo=" + pageNo + ", pageSize=" + pageSize + "]";
	}

}
