package cn.elwy.common.entity;

import java.io.Serializable;

/**
 * 排序规则类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class OrderRule implements Serializable {

	private static final long serialVersionUID = 1L;

	private String field;
	private String desc;

	public OrderRule(String field) {
		this(field, false);
	}

	public OrderRule(String field, boolean desc) {
		this.field = field;
		this.desc = desc ? "desc" : "asc";
	}

	public String getField() {
		return field;
	}

	public void setField(String field) {
		this.field = field;
	}

	public String getDesc() {
		return desc;
	}

	public void setDesc(boolean desc) {
		this.desc = desc ? "desc" : "asc";
	}

	@Override
	public String toString() {
		return "{\"field\":\"" + field + "\",\"desc\":\"" + desc + "\"}";
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((field == null) ? 0 : field.hashCode());
		result = prime * result + (desc == "desc" ? 1231 : 1237);
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		OrderRule other = (OrderRule) obj;
		if (field == null) {
			if (other.field != null)
				return false;
		} else if (!field.equals(other.field))
			return false;
		if (desc != other.desc)
			return false;
		return true;
	}

}