package cn.elwy.common.entity;

import java.io.Serializable;
import java.util.Map;

/**
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class Entry<K, V> implements Map.Entry<K, V>, Serializable {

	private static final long serialVersionUID = 1L;

	private K key;
	private V value;

	public Entry() {
	}

	public Entry(K key, V value) {
		this.key = key;
		this.value = value;
	}

	public K getKey() {
		return key;
	}

	public String getKeyToString() {
		if (key != null) {
			return key.toString();
		}
		return null;
	}

	public void setKey(K key) {
		this.key = key;
	}

	public V getValue() {
		return value;
	}

	public String getValueToString() {
		if (value != null) {
			return value.toString();
		}
		return null;
	}

	public V setValue(V value) {
		V oldValue = this.value;
		this.value = value;
		return oldValue;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + ((key == null) ? 0 : key.hashCode());
		result = prime * result + ((value == null) ? 0 : value.hashCode());
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		Entry<?, ?> other = (Entry<?, ?>) obj;
		if (key == null) {
			if (other.key != null)
				return false;
		} else if (!key.equals(other.key))
			return false;
		if (value == null) {
			if (other.value != null)
				return false;
		} else if (!value.equals(other.value))
			return false;
		return true;
	}

	@Override
	public String toString() {
		return "Entry [key=" + key + ", value=" + value + "]";
	}
}
