package cn.elwy.common.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import cn.elwy.common.entity.QueryRule.SqlOP;
import cn.elwy.common.entity.QueryRule.WidgetType;

/**
 * 条件关系集合类，一组查询条件间的关系类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class Criteria implements Serializable {

	private static final long serialVersionUID = 1L;

	protected OP op = OP.AND;
	protected List<QueryRule> queryRules = new ArrayList<QueryRule>();
	protected List<OP> queryOps = new ArrayList<OP>();
	protected List<Criteria> ruleGroups = new ArrayList<Criteria>();
	protected List<OP> groupOps = new ArrayList<OP>();

	public Criteria() {
	}

	public static enum OP {

		AND(" AND ", "AND"), OR(" OR ", "OR");

		private String code;
		private String name;

		private OP(String code, String name) {
			this.code = code;
			this.name = name;
		}

		public String getCode() {
			return code;
		}

		public String getName() {
			return name;
		}

		@Override
		public String toString() {
			return code;
		}
	}

	public boolean isValid() {
		return queryRules.size() > 0 || (ruleGroups != null && ruleGroups.size() > 0);
	}

	public Criteria andQueryRule(QueryRule queryRule) {
		queryRules.add(queryRule);
		queryOps.add(OP.AND);
		return this;
	}

	public Criteria andQueryRule(String field, SqlOP op, Object value, Object secondValue) {
		queryRules.add(new QueryRule(field, op, WidgetType.TEXT, value, secondValue));
		queryOps.add(OP.AND);
		return this;
	}

	public Criteria andQueryRule(String field, SqlOP op, WidgetType type, Object value, Object secondValue) {
		queryRules.add(new QueryRule(field, op, type, value, secondValue));
		queryOps.add(OP.AND);
		return this;
	}

	public Criteria orQueryRule(QueryRule queryRule) {
		queryRules.add(queryRule);
		queryOps.add(OP.OR);
		return this;
	}

	public Criteria orQueryRule(String field, SqlOP op, Object value, Object secondValue) {
		queryRules.add(new QueryRule(field, op, WidgetType.TEXT, value, secondValue));
		queryOps.add(OP.OR);
		return this;
	}

	public Criteria orQueryRule(String field, SqlOP op, WidgetType type, Object value, Object secondValue) {
		queryRules.add(new QueryRule(field, op, type, value, secondValue));
		queryOps.add(OP.OR);
		return this;
	}

	public Criteria andCriteria(Criteria criteria) {
		ruleGroups.add(criteria);
		groupOps.add(OP.AND);
		return this;
	}

	public Criteria orCriteria(Criteria criteria) {
		ruleGroups.add(criteria);
		groupOps.add(OP.OR);
		return this;
	}

	public Criteria andIsNull(String field) {
		return andQueryRule(field, SqlOP.IS_NULL, null, null);
	}

	public Criteria andIsNotNull(String field) {
		return andQueryRule(field, SqlOP.IS_NOT_NULL, null, null);
	}

	public Criteria andEqualTo(String field, Object value) {
		return andQueryRule(field, SqlOP.EQUAL, value, null);
	}

	public Criteria andNotEqualTo(String field, Object value) {
		return andQueryRule(field, SqlOP.NOT_EQUAL, value, null);
	}

	public Criteria andGreaterThan(String field, Object value) {
		return andQueryRule(field, SqlOP.GT, value, null);
	}

	public Criteria andGreaterThanOrEqualTo(String field, Object value) {
		return andQueryRule(field, SqlOP.GE, value, null);
	}

	public Criteria andLessThan(String field, Object value) {
		return andQueryRule(field, SqlOP.LT, value, null);
	}

	public Criteria andLessThanOrEqualTo(String field, Object value) {
		return andQueryRule(field, SqlOP.LE, value, null);
	}

	public Criteria andIn(String field, Collection<Object> value) {
		return andQueryRule(field, SqlOP.IN, value, null);
	}

	public Criteria andNotIn(String field, Collection<Object> value) {
		return andQueryRule(field, SqlOP.NOT_IN, value, null);
	}

	public Criteria andIn(String field, Object[] value) {
		return andQueryRule(field, SqlOP.IN, value, null);
	}

	public Criteria andNotIn(String field, Object[] value) {
		return andQueryRule(field, SqlOP.NOT_IN, value, null);
	}

	public Criteria andBetween(String field, Object value1, Object value2) {
		return andQueryRule(field, SqlOP.BETWEEN, value1, value2);
	}

	public Criteria andNotBetween(String field, Object value1, Object value2) {
		return andQueryRule(field, SqlOP.NOT_BETWEEN, value1, value2);
	}

	public Criteria andLike(String field, String value) {
		return andQueryRule(field, SqlOP.LIKE, value, null);
	}

	public Criteria andAllLike(String field, String value) {
		return andQueryRule(field, SqlOP.LIKE, "%" + value + "%", null);
	}

	public Criteria andStartLike(String field, String value) {
		return andQueryRule(field, SqlOP.LIKE, "%" + value + "", null);
	}

	public Criteria andEndLike(String field, String value) {
		return andQueryRule(field, SqlOP.LIKE, "" + value + "%", null);
	}

	public Criteria andNotLike(String field, String value) {
		return andQueryRule(field, SqlOP.NOT_LIKE, "" + value + "", null);
	}

	public Criteria andNotAllLike(String field, String value) {
		return andQueryRule(field, SqlOP.NOT_LIKE, "%" + value + "%", null);
	}

	public Criteria andNotStartLike(String field, String value) {
		return andQueryRule(field, SqlOP.NOT_LIKE, "%" + value + "", null);
	}

	public Criteria andNotEndLike(String field, String value) {
		return andQueryRule(field, SqlOP.NOT_LIKE, "" + value + "%", null);
	}

	public Criteria orIsNull(String field) {
		return orQueryRule(field, SqlOP.IS_NULL, null, null);
	}

	public Criteria orIsNotNull(String field) {
		return orQueryRule(field, SqlOP.IS_NOT_NULL, null, null);
	}

	public Criteria orEqualTo(String field, Object value) {
		return orQueryRule(field, SqlOP.EQUAL, value, null);
	}

	public Criteria orNotEqualTo(String field, Object value) {
		return orQueryRule(field, SqlOP.NOT_EQUAL, value, null);
	}

	public Criteria orGreaterThan(String field, Object value) {
		return orQueryRule(field, SqlOP.GT, value, null);
	}

	public Criteria orGreaterThanOrEqualTo(String field, Object value) {
		return orQueryRule(field, SqlOP.GE, value, null);
	}

	public Criteria orLessThan(String field, Object value) {
		return orQueryRule(field, SqlOP.LT, value, null);
	}

	public Criteria orLessThanOrEqualTo(String field, Object value) {
		return orQueryRule(field, SqlOP.LE, value, null);
	}

	public Criteria orIn(String field, Collection<Object> value) {
		return orQueryRule(field, SqlOP.IN, value, null);
	}

	public Criteria orNotIn(String field, Collection<Object> value) {
		return orQueryRule(field, SqlOP.NOT_IN, value, null);
	}

	public Criteria orIn(String field, Object[] value) {
		return orQueryRule(field, SqlOP.IN, value, null);
	}

	public Criteria orNotIn(String field, Object[] value) {
		return orQueryRule(field, SqlOP.NOT_IN, value, null);
	}

	public Criteria orBetween(String field, Object value1, Object value2) {
		return orQueryRule(field, SqlOP.BETWEEN, value1, value2);
	}

	public Criteria orNotBetween(String field, Object value1, Object value2) {
		return orQueryRule(field, SqlOP.NOT_BETWEEN, value1, value2);
	}

	public Criteria orLike(String field, String value) {
		return orQueryRule(field, SqlOP.LIKE, value, null);
	}

	public Criteria orAllLike(String field, String value) {
		return orQueryRule(field, SqlOP.LIKE, "%" + value + "%", null);
	}

	public Criteria orStartLike(String field, String value) {
		return orQueryRule(field, SqlOP.LIKE, "%" + value + "", null);
	}

	public Criteria orEndLike(String field, String value) {
		return orQueryRule(field, SqlOP.LIKE, "" + value + "%", null);
	}

	public Criteria orNotLike(String field, String value) {
		return orQueryRule(field, SqlOP.NOT_LIKE, "" + value + "", null);
	}

	public Criteria orNotAllLike(String field, String value) {
		return orQueryRule(field, SqlOP.NOT_LIKE, "%" + value + "%", null);
	}

	public Criteria orNotStartLike(String field, String value) {
		return orQueryRule(field, SqlOP.NOT_LIKE, "%" + value + "", null);
	}

	public Criteria orNotEndLike(String field, String value) {
		return orQueryRule(field, SqlOP.NOT_LIKE, "" + value + "%", null);
	}

	public OP getOp() {
		return op;
	}

	public void setOp(OP op) {
		if (op != null) {
			this.op = op;
		}
	}

	public List<QueryRule> getQueryRules() {
		return queryRules;
	}

	public List<OP> getQueryOps() {
		return queryOps;
	}

	public List<Criteria> getRuleGroups() {
		return ruleGroups;
	}

	public List<OP> getGroupOps() {
		return groupOps;
	}

	// public Map<QueryRule, OP> getRuleMaps() {
	// return ruleMaps;
	// }
	//
	// public Map<Criteria, OP> getCriteriaMaps() {
	// return criteriaMaps;
	// }
	//
	// public void setCriteriaMaps(Map<Criteria, OP> criteriaMaps) {
	// this.criteriaMaps = criteriaMaps;
	// }

	// @Override
	// public String toString() {
	// return "{\"op\":\"" + op + "\",\"queryRules\":\"" + queryRules +
	// "\",\"gop\":\"" +
	// gop + "\",\"rgop\":\"" + rgop
	// + "\",\"groups\":\"" + groups + "\"}";
	// }

}