package cn.elwy.common.entity;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import cn.elwy.common.PropertyConstant;

/**
 * 参数实体类
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
@SuppressWarnings("unchecked")
public class Condition extends HashMap<String, Object> implements Serializable, PropertyConstant {

	private static final long serialVersionUID = 1L;

	public Condition() {
		setCriterias(new ArrayList<Criteria>());
		setParam(new HashMap<String, Object>());
	}

	public String getOperate() {
		return (String) get(OPERATE);
	}

	public void setOperate(String operate) {
		put(OPERATE, operate);
	}

	/**
	 * 实体对象
	 * @return
	 */
	public <E> E getData() {
		return (E) get(DATA);
	}

	public <E> void setData(E entity) {
		put(DATA, entity);
	}

	/**
	 * 实体对象列表
	 * @return
	 */
	public <E> List<E> getDatas() {
		return (List<E>) get(DATAS);
	}

	public <E> void setDatas(List<E> entity) {
		put(DATAS, entity);
	}

	public Integer getPageNo() {
		return (Integer) get(PAGE_NO);
	}

	public void setPageNo(Integer pageNo) {
		put(PAGE_NO, pageNo);
	}

	public Integer getPageSize() {
		return (Integer) get(PAGE_SIZE);
	}

	public void setPageSize(Integer pageSize) {
		put(PAGE_SIZE, pageSize);
	}

	public String getOrderBy() {
		return (String) get(ORDER_BY);
	}

	public void setOrderBy(String orderBy) {
		put(ORDER_BY, orderBy);
	}

	// public String getOrderDesc() {
	// return (String) get(ORDER_DESC);
	// }
	//
	// public void setOrderDesc(String desc) {
	// put(ORDER_DESC, desc);
	// }

	public List<OrderRule> getOrderRules() {
		return (List<OrderRule>) get(ORDER_RULES);
	}

	public void setOrderRules(List<OrderRule> orderRules) {
		put(ORDER_RULES, orderRules);
	}

	public List<Criteria> getCriterias() {
		return (List<Criteria>) get(CRITERIAS);
	}

	public void setCriterias(List<Criteria> criterias) {
		if (criterias != null) {
			put(CRITERIAS, criterias);
		}
	}

	public List<String> getFilterColumns() {
		return (List<String>) get(FILTER_COLUMNS);
	}

	public void setFilterColumns(List<String> filterColumns) {
		put(FILTER_COLUMNS, filterColumns);
	}

	public String getId() {
		return (String) get(ID);
	}

	public void setId(String id) {
		put(ID, id);
	}

	public String[] getIds() {
		return (String[]) get(IDS);
	}

	public void setIds(String... ids) {
		put(IDS, ids);
	}

	/**
	 * 查询条件
	 * @return
	 */
	public Map<String, Object> getParam() {
		return (Map<String, Object>) get(PARAM);
	}

	public void setParam(Map<String, Object> param) {
		put(PARAM, param);
	}

	public void addParam(String key, Object value) {
		Map<String, Object> param = getParam();
		param.put(key, value);
	}

	public void clear() {
		put(CRITERIAS, null);
		put(ORDER_RULES, null);
		super.clear();
	}

	// /** 当前页 */
	// private Integer pageNo;
	// /** 页大小 : 每页的数量 */
	// private Integer pageSize;
	// /** 排序信息 */
	// private String orderBy;
	// /** 分组信息 */
	// private String groupBy;
	// /** 操作代码 */
	// private String operate;
	// /** 查询条件 */
	// private String ql;
	// /** 查询参数 */
	// private List<Object> valueList;
	// /** 过滤字段 */
	// private List<String> filterColumns;
	// private List<Criteria> criterias;
	//
	// /** 主键 */
	// private String id;
	// /** 多个主键 */
	// private String[] ids;
	// private Map<String, Object> param;
	// private Object data;
	// private List<Object> datas;

	// public String getGroupBy() {
	// return groupBy;
	// }
	//
	// public void setGroupBy(String groupBy) {
	// this.groupBy = groupBy;
	// }

	public void setQl(String ql) {
		put("QL", ql);
	}

	public String getQl() {
		return (String) get("QL");
	}

	public void setValueList(List<Object> valueList) {
		put("valueList", valueList);
	}

	public List<Object> getValueList() {
		return (List<Object>) get("valueList");
	}

}
