package cn.elwy.common.dao;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;

import cn.elwy.common.entity.Criteria;
import cn.elwy.common.entity.QueryRule;
import cn.elwy.common.entity.Criteria.OP;

/**
 * SQL条件构建类，用于拼接SQL
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class SqlBuilder implements Serializable {

	private static final long serialVersionUID = 1L;

	protected List<Criteria> criterias;
	protected String ql = "";
	protected List<Object> valueList = new ArrayList<Object>();

	protected SqlBuilder() {
	}

	public static SqlBuilder getInstance(Criteria criteria) {
		List<Criteria> criterias = new ArrayList<Criteria>();
		criterias.add(criteria);
		return getInstance(criterias);
	}

	public static SqlBuilder getInstance(List<Criteria> criterias) {
		SqlBuilder translator = new SqlBuilder();
		translator.criterias = criterias;
		return translator;
	}

	/**
	 * 获取预编译SQL
	 * @author huangsq
	 * @return
	 */
	public String buildQl() {
		StringBuilder ql = new StringBuilder();
		String op = " AND ";
		if (criterias != null) {
			for (Criteria criteria : criterias) {
				buildQl(ql, criteria);
				ql.append(op);
			}
			ql.delete(ql.length() - op.length(), ql.length());
		}
		return ql.toString();
	}

	private void buildQl(StringBuilder ql, Criteria criteria) {
		if (criteria == null) {
			return;
		}
		ql.append("(");
		List<QueryRule> queryRules = criteria.getQueryRules();
		List<OP> queryOps = criteria.getQueryOps();
		buildQueryRules(ql, queryRules, queryOps);
		List<Criteria> criterias = criteria.getRuleGroups();
		List<OP> criteriaOps = criteria.getGroupOps();

		if (criterias != null && criterias.size() > 0) {
			int size = criteriaOps.size() - 1;
			int index = 0;
			if (!(queryRules == null || queryRules.isEmpty())) {
				ql.append(criteria.getOp().getCode());
			}
			ql.append("(");
			for (Criteria cr : criterias) {
				index++;

				buildQl(ql, cr);
				if (index <= size) {
					ql.append(criteriaOps.get(index));
				}
			}
			ql.append(")");
		}
		ql.append(")");
	}

	protected void buildQueryRules(StringBuilder ql, List<QueryRule> queryRules, List<OP> queryOps) {
		int size = queryOps.size() - 1;
		int index = 0;
		for (QueryRule qr : queryRules) {
			index++;
			ql.append(qr.getField()).append(qr.getOp());
			if (qr.isNoValue()) {

			} else {
				Object value = qr.getValue();
				if (qr.isSingleValue()) {
					ql.append("?");
					valueList.add(value);
				} else if (qr.isBetweenValue()) {
					ql.append("? AND ?");
					valueList.add(value);
					valueList.add(qr.getSecondValue());
				} else if (qr.isCollectionValue()) {
					if (value instanceof Collection<?>) {
						valueList.addAll((Collection<?>) value);
					} else if (value instanceof Object[]) {
						valueList.addAll(Arrays.asList((Object[]) value));
					}
					int valueSize = qr.getValueSize();
					ql.append("(");
					for (int i = 1; i < valueSize; i++) {
						ql.append("? ,");
					}
					ql.deleteCharAt(ql.length() - 1);
					ql.append(")");
				}
			}
			if (index <= size) {
				ql.append(queryOps.get(index));
			}
		}
	}

	public String getQl() {
		if (ql == null) {
			ql = buildQl();
		}
		return ql;
	}

	public List<Object> getValueList() {
		return valueList;
	}

}
