package cn.elwy.common.dao;

import java.util.List;

import cn.elwy.common.entity.Condition;
import cn.elwy.common.entity.Pageable;

/**
 * 通用Dao接口
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public interface Dao<E> {

	/**
	 * 根据查询条件返回实体数目
	 * @param condition 查询条件
	 * @return 返回实体数目
	 */
	public int countByCondition(Condition condition);

	/**
	 * 根据条件删除对象
	 * @param condition 查询条件
	 * @return 影响条数
	 */
	public int deleteByCondition(Condition condition);

	/**
	 * 根据id删除对象
	 * @param id 主键
	 * @return 影响条数
	 */
	public int deleteByPrimaryKey(String id);

	/**
	 * 根据多个ids删除对象
	 * @param ids 主键
	 * @return 影响条数
	 */
	public int deleteByPrimaryKeys(String... ids);

	/**
	 * 插入所有字段的内容
	 * @param entity 记录
	 * @return entity
	 */
	public E insert(E entity);

	/**
	 * 批量插入所有字段的内容
	 * @param entityList 记录集
	 * @return entityList
	 */
	public List<E> insertBatch(List<E> entityList);

	/**
	 * 批量插入内容不为null的字段
	 * @param entityList 记录集
	 * @return entityList
	 */
	public List<E> insertBatchSelective(List<E> entityList);

	/**
	 * 插入内容不为null的字段
	 * @param entity 记录
	 * @return entity
	 */
	public E insertSelective(E entity);

	/**
	 * 根据条件查询实体对象
	 * @param condition 查询条件
	 * @return 实体对象列表
	 */
	public List<E> selectByCondition(Condition condition);

	/**
	 * 根据条件查询实体对象
	 * @param condition 查询条件
	 * @param page 分页查询条件
	 * @return 实体对象列表
	 */
	public Pageable<E> selectByCondition(Condition condition, Pageable<E> page);

	/**
	 * 根据id查找对象
	 * @param id 主键
	 * @return 实体对象
	 */
	public E selectByPrimaryKey(String id);

	/**
	 * 根据ids查找对象
	 * @param ids 主键
	 * @return 实体对象列表
	 */
	public List<E> selectByPrimaryKeys(String... ids);

	/**
	 * 根据条件更新对象
	 * @param condition 查询条件
	 * @return 影响条数
	 */
	public int updateByCondition(Condition condition);

	/**
	 * 根据条件更新对象
	 * @param condition 查询条件
	 * @return 影响条数
	 */
	public int updateByConditionSelectives(Condition condition);

	/**
	 * 根据id更新所有字段
	 * @param entity 记录
	 * @return 影响条数
	 */
	public int updateByPrimaryKey(E entity);

	/**
	 * 批量根据id更新内容不为null的字段
	 * @param entityList 记录
	 * @return 影响条数
	 */
	public int updateByPrimaryKeys(List<E> entityList);

	/**
	 * 根据id更新内容不为null的字段
	 * @param entity 记录
	 * @return 影响条数
	 */
	public int updateByPrimaryKeySelective(E entity);

	/**
	 * 批量根据id更新内容不为null的字段
	 * @param entityList 记录
	 * @return 影响条数
	 */
	public int updateByPrimaryKeySelectives(List<E> entityList);

}
