package cn.elwy.common.config;

/**
 * 读取系统默认配置信息
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class SystemProperty extends Config {

	private static volatile SystemProperty instance;

	private SystemProperty(Class<?> target) {
		setTarget(target);
	}

	public void load() {
		load(SYS_PROPERTY_FILE);
		System.getProperties().putAll(getProps());
	}

	public static SystemProperty getInstance() {
		return getInstance(SystemProperty.class);
	}

	public static SystemProperty getInstance(Class<?> target) {
		if (instance == null) {
			synchronized (SystemProperty.class) {
				if (instance == null) {
					instance = new SystemProperty(target);
					instance.load();
				}
			}
		}
		return instance;
	}

	public static void dispose() {
		instance = null;
	}

}
