package cn.elwy.common.config;

import java.io.File;

import cn.elwy.common.PathUtil;
import cn.elwy.common.util.AssertUtil;
import cn.elwy.common.util.io.PropertyUtil;

/**
 * 读取系统默认配置信息
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class SysConfig extends Config {

	private static volatile SysConfig instance;

	private SysConfig(Class<?> target) {
		setTarget(target);
	}

	public void load() {
		load(SYS_CONFIG_FILE);
	}

	public static SysConfig getInstance() {
		return getInstance(SysConfig.class);
	}

	public static SysConfig getInstance(Class<?> target) {
		if (instance == null) {
			synchronized (SysConfig.class) {
				if (instance == null) {
					instance = new SysConfig(target);
					instance.load();
				}
			}
		}
		return instance;
	}

	public static void dispose() {
		instance = null;
	}

	public String getAppHome() {
		String APP_HOME = propertyUtil.get("app_home");
		String ENV_APP_HOME = propertyUtil.get("env_app_home");
		String envAppHome = null;
		if (AssertUtil.isNotEmpty(ENV_APP_HOME)) {
			envAppHome = System.getenv(ENV_APP_HOME);
			if (AssertUtil.isEmpty(envAppHome)) {
				envAppHome = System.getProperty(ENV_APP_HOME);
			}
		}
		if (AssertUtil.isNotEmpty(envAppHome)) {
			APP_HOME = envAppHome;
		}
		return APP_HOME;
	}

	public String getAppGlobalHome() {
		String APP_GLOBAL_HOME = propertyUtil.get("app_global_home");
		String ENV_APP_GLOBAL_HOME = propertyUtil.get("env_app_global_home");
		String envAppGlobalHome = null;
		if (AssertUtil.isNotEmpty(ENV_APP_GLOBAL_HOME)) {
			envAppGlobalHome = System.getenv(ENV_APP_GLOBAL_HOME);
			if (AssertUtil.isEmpty(envAppGlobalHome)) {
				envAppGlobalHome = System.getProperty(ENV_APP_GLOBAL_HOME);
			}
		}
		if (AssertUtil.isNotEmpty(envAppGlobalHome)) {
			APP_GLOBAL_HOME = envAppGlobalHome;
		}
		return APP_GLOBAL_HOME;
	}

	public String getLogHome() {
		String LOG_HOME = propertyUtil.get("log_home");
		String ENV_LOG_HOME = propertyUtil.get("env_log_home");
		String envLogHome = null;
		if (AssertUtil.isNotEmpty(ENV_LOG_HOME)) {
			envLogHome = System.getenv(ENV_LOG_HOME);
			if (AssertUtil.isEmpty(envLogHome)) {
				envLogHome = System.getProperty(ENV_LOG_HOME);
			}
		}
		if (AssertUtil.isNotEmpty(envLogHome)) {
			LOG_HOME = envLogHome;
		}
		return LOG_HOME;
	}

	public boolean isDevelop() {
		return propertyUtil.getBoolean("is_develop", false);
	}

	public String getLogback() {
		String logback = propertyUtil.get("logback");
		if (logback == null) {
			logback = LOGBACK_FILE;
		}
		return logback;
	}

	public String getLogbackConfig() {
		String logbackConfig = propertyUtil.get("logback_config");
		if (logbackConfig == null) {
			logbackConfig = LOGBACK_CONFIG_FILE;
		}
		return logbackConfig;
	}

	public File getJavaHome() {
		String javaHomePath = propertyUtil.get("java_home");
		String envJavaHome = propertyUtil.get("env_java_home");
		String javaHome = System.getenv(envJavaHome);
		if (AssertUtil.isNotEmpty(javaHomePath)) {
			return new File(javaHomePath);
		} else if (javaHome != null) {
			return new File(javaHome);
		} else {
			String javaDir = propertyUtil.get("java_dir", "jre");
			return new File(PathUtil.getInstallPath(), javaDir);
		}
	}

	public File getMavenHome() {
		String mavenHomePath = propertyUtil.get("maven_home");
		String envMavenHome = propertyUtil.get("env_maven_home");
		String mavenHome = System.getenv(envMavenHome);
		if (AssertUtil.isNotEmpty(mavenHomePath)) {
			return new File(mavenHomePath);
		} else if (mavenHome != null) {
			return new File(mavenHome);
		} else {
			String mavenDir = propertyUtil.get("maven_dir", "maven");
			return new File(PathUtil.getInstallPath(), mavenDir);
		}
	}

	public String getThemeName() {
		return propertyUtil.get("theme_name", "DEFAULT").toUpperCase();
	}

	public String getThemeDir() {
		return propertyUtil.get("theme_dir", "theme");
	}

	public Boolean isGetDaoByName() {
		return propertyUtil.getBoolean("get_dao_by_name", true);
	}

	public Boolean isGetServiceByName() {
		return propertyUtil.getBoolean("get_service_by_name", false);
	}

	public String getDaoPrefix() {
		return propertyUtil.get("dao_prefix", "");
	}

	public String getServicePrefix() {
		return propertyUtil.get("service_prefix", "");
	}

	public String getAuditPrefix() {
		String auditPrefix = propertyUtil.get("audit_prefix", "");
		if ("logger".equalsIgnoreCase(auditPrefix)) {
			auditPrefix = "";
		}
		return auditPrefix;
	}

	public boolean getUsedLastNewProject() {
		return propertyUtil.getBoolean("used_last_new_project", true);
	}

	public String getSaveStrategy() {
		return propertyUtil.get("save_strategy", "ALL").toUpperCase();
	}

	public String getDialogConfigDir() {
		return propertyUtil.get("dialog_config_dir", "dialogConfig");
	}

	public String getTableConfigDir() {
		return propertyUtil.get("table_config_dir", "tableConfig");
	}

	public String getSubjectType() {
		return propertyUtil.get("subject_type", "USER").toUpperCase();
	}

	public PropertyUtil getPropertyUtil() {
		return propertyUtil;
	}

}
