package cn.elwy.common.config;

import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

import cn.elwy.common.Constant;
import cn.elwy.common.PathUtil;
import cn.elwy.common.exception.RunException;
import cn.elwy.common.i18n.Msg;
import cn.elwy.common.util.CloseUtil;
import cn.elwy.common.util.io.PropertyUtil;

/**
 * 读取系统默认配置信息
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class Config implements Constant {

	protected PropertyUtil propertyUtil = new PropertyUtil();
	protected Class<?> target;

	public Config() {
	}

	public Config(Class<?> target) {
		this.target = target;
	}

	public void load(String path) {
		try {
			String filePath = PathUtil.getFilePath("/", path);
			URL resource = null;
			if (target != null) {
				resource = PathUtil.getResource(target, filePath);
			} else {
				resource = PathUtil.getResource(this.getClass(), filePath);
			}
			loadConfig(resource);

			resource = PathUtil.getResource(PathUtil.getInstallURL(), path);
			loadConfig(resource);

			resource = PathUtil.getResource(PathUtil.getAppHomeUrl(), path);
			loadConfig(resource);
		} catch (Exception e) {
			throw new RunException(Msg.E_LOAD_CONFIG_ERROR, e);
		}
	}

	protected void loadConfig(URL url) throws Exception {
		if (url == null) {
			return;
		}
		InputStream openStream = null;
		try {
			openStream = url.openStream();
			propertyUtil.load(openStream);
		} finally {
			CloseUtil.close(openStream);
		}
	}

	public String get(String key) {
		return propertyUtil.get(key);
	}

	public String get(String key, String defaultValue) {
		return propertyUtil.get(key, defaultValue);
	}

	public String[] getArray(String key) {
		return propertyUtil.getArray(key);
	}

	public String[] getArray(String key, String separate) {
		return propertyUtil.getArray(key, separate);
	}

	public int getInt(String key) {
		return propertyUtil.getInt(key);
	}

	public int getInt(String key, int defaultValue) {
		return propertyUtil.getInt(key, defaultValue);
	}

	public boolean getBoolean(String key) {
		return propertyUtil.getBoolean(key);
	}

	public boolean getBoolean(String key, boolean defaultValue) {
		return propertyUtil.getBoolean(key, defaultValue);
	}

	public PropertyUtil getPropertyUtil() {
		return propertyUtil;
	}

	public Properties getProps() {
		return propertyUtil.getProps();
	}

	public Class<?> getTarget() {
		return target;
	}

	public void setTarget(Class<?> target) {
		if (target != null) {
			this.target = target;
		}
	}

}
