package cn.elwy.common;

import java.io.File;
import java.net.URL;

/**
 * 获取路径工具类，不支持获取OSGI工程路径
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public abstract class PathUtil implements Constant {

	private static PathSupport pathSupport;

	private PathUtil() {
	}

	static {
		setPathSupport(PathSupport.getInstance());
	}

	public static void setPathSupport(PathSupport pathSupport) {
		if (pathSupport != null) {
			PathUtil.pathSupport = pathSupport;
		}
	}

	public static File getUserDir() {
		return pathSupport.getUserDir();
	}

	public static File getUserHome() {
		return pathSupport.getUserHome();
	}

	public static File getInstallHome() {
		return pathSupport.getInstallHome();
	}

	public static URL getInstallURL() {
		return pathSupport.getInstallURL();
	}

	public static String getInstallPath() {
		return pathSupport.getInstallPath();
	}

	protected static void setInstallHome(File file) {
		pathSupport.setInstallHome(file);
	}

	public static File getAppHome() {
		return pathSupport.getAppHome();
	}

	public static String getAppHomePath() {
		return pathSupport.getAppHomePath();
	}

	public static URL getAppHomeUrl() {
		return pathSupport.getAppHomeUrl();
	}

	/**
	 * 设置应用根路径，不推荐直接调用，请使用AppContext.setAppHome()
	 * @author huangsq
	 * @param appHome
	 */
	protected static void setAppHome(File appHome) {
		pathSupport.setAppHome(appHome);
	}

	public static File getGlobalHome() {
		return pathSupport.getGlobalHome();
	}

	public static String getGlobalHomePath() {
		return pathSupport.getGlobalHomePath();
	}

	public static URL getGlobalHomeUrl() {
		return pathSupport.getGlobalHomeUrl();
	}

	protected static void setGlobalHome(File globalHome) {
		pathSupport.setGlobalHome(globalHome);
	}

	public static File getLogHome() {
		return pathSupport.getLogHome();
	}

	protected static void setLogHome(File file) {
		pathSupport.setLogHome(file);
	}

	public static File getTestDir() {
		return pathSupport.getTestDir();
	}

	public static void setTestDir(File testDir) {
		pathSupport.setTestDir(testDir);
	}

	public static URL getResource(URL url, String filePath) {
		return pathSupport.getResource(url, filePath);
	}

	public static File getResource(File dir, String filePath) {
		return pathSupport.getResource(dir, filePath);
	}

	public static URL getResources(String filePath) {
		return pathSupport.getResources(filePath);
	}

	public static URL getResources(Class<?> clazz, String filePath) {
		return pathSupport.getResources(clazz, filePath);
	}

	public static String getResourcesPath(String filePath) {
		return pathSupport.getResourcesPath(filePath);
	}

	public static String getResourcesPath(Class<?> clazz, String filePath) {
		return pathSupport.getResourcesPath(clazz, filePath);
	}

	public static File getResourcesFile(String filePath) {
		return pathSupport.getResourcesFile(filePath);
	}

	public static File getResourcesFile(Class<?> clazz, String filePath) {
		return pathSupport.getResourcesFile(clazz, filePath);
	}

	public static URL getResource(Class<?> clazz, String filePath) {
		return pathSupport.getResource(clazz, filePath);
	}

	public static String getResourcePath(Class<?> clazz, String filePath) {
		return pathSupport.getResourcePath(clazz, filePath);
	}

	public static File toFile(URL url) {
		return pathSupport.toFile(url);
	}

	public static String toFilePath(URL url) {
		return pathSupport.toFilePath(url);
	}

	public static String toFilePath(File file) {
		return pathSupport.toFilePath(file);
	}

	public static String toFilePath(File file, boolean isDirectory) {
		return pathSupport.toFilePath(file, isDirectory);
	}

	public static String getFormatPath(String filePath) {
		return PathSupport.getFormatPath(filePath);
	}

	public static String getFormatPath(File file) {
		return PathSupport.getFormatPath(file);
	}

	public static String replaceFilePath(String filePath, String replacePath) {
		return PathSupport.replaceFilePath(filePath, replacePath);
	}

	public static String getFilePath(String root, String filePath) {
		return PathSupport.getFilePath(root, filePath);
	}

	public static String getAbsolutePath(String root, String filePath) {
		return PathSupport.getAbsolutePath(root, filePath);
	}

	public static String getFilePath(String root, String... filePaths) {
		return PathSupport.getFilePath(root, filePaths);
	}

	public static String mergeFilePath(String root, String filePath, String separator) {
		return PathSupport.mergeFilePath(root, filePath, separator);
	}

	public static String getRelativePath(String filePath) {
		return PathSupport.getRelativePath(filePath);
	}

	public static String getRelativePath(String basePath, String filePath) {
		return PathSupport.getRelativePath(basePath, filePath);
	}

}
