package cn.elwy.common;

import java.io.File;
import java.net.URL;

import cn.elwy.common.config.SysConfig;
import cn.elwy.common.config.SystemProperty;
import cn.elwy.common.log.LogConfig;
import cn.elwy.common.log.LoggerConfig;
import cn.elwy.common.util.AssertUtil;

/**
 * 应用上下文工具类，提供全局的配置信息文件路径等。
 * @author huangsq
 * @version 1.0, 2018-02-19
 */
public class AppContext implements Constant {

	protected static Class<?> clazz;
	private static Boolean isDevelop;
	private static LoggerConfig loggerConfig;
	private static SysConfig sysConfig;
	/** 应用跟路径 */
	private static File defaultAppHome;

	private static File confFile;
	private static File cacheFile;
	private static File uploadFile;
	private static File tempFile;
	private static File testFile;

	private static File globalConfFile;
	private static File globalCacheFile;
	private static File globalTempFile;
	private static File globalUploadFile;

	public static void start() {
		start(null, AppContext.class);
	}

	public static void start(Class<?> clazz) {
		start(null, clazz);
	}

	public static void start(PathSupport pathSupport) {
		start(pathSupport, pathSupport.getClass());
	}

	public static void start(PathSupport pathSupport, Class<?> clazz) {
		if (pathSupport != null) {
			PathUtil.setPathSupport(pathSupport);
		}
		AppContext.clazz = clazz;

		SystemProperty.getInstance(clazz);
		sysConfig = SysConfig.getInstance(clazz);

		initConfig(sysConfig);

		URL logbackFile = PathUtil.getResources(clazz, sysConfig.getLogback());
		URL logbackConfigFile = PathUtil.getResources(clazz, sysConfig.getLogbackConfig());

		loggerConfig = LoggerConfig.getInstance();
		if (logbackFile != null && logbackConfigFile != null) {
			loggerConfig.doConfig(logbackFile, logbackConfigFile);
		}
		LogConfig.init();
	}

	public static File getAppHome() {
		return PathUtil.getAppHome();
	}

	public static File getGlobalHome() {
		return PathUtil.getGlobalHome();
	}

	public static File getConfFile() {
		mkdirs(confFile);
		return confFile;
	}

	public static File getCacheFile() {
		mkdirs(cacheFile);
		return cacheFile;
	}

	public static File getLogHome() {
		return PathUtil.getLogHome();
	}

	public static File getUploadFile() {
		mkdirs(uploadFile);
		return uploadFile;
	}

	public static File getTempFile() {
		mkdirs(tempFile);
		return tempFile;
	}

	public static File getTestFile() {
		mkdirs(testFile);
		return testFile;
	}

	public static void setTestFile(File testFile) {
		AppContext.testFile = testFile;
	}

	public static File getGlobalConfFile() {
		mkdirs(globalConfFile);
		return globalConfFile;
	}

	public static File getGlobalCacheFile() {
		mkdirs(globalCacheFile);
		return globalCacheFile;
	}

	public static File getGlobalTempFile() {
		mkdirs(globalTempFile);
		return globalTempFile;
	}

	public static File getGlobalUploadFile() {
		mkdirs(globalUploadFile);
		return globalUploadFile;
	}

	public static void setDefaultAppHome(File appHome) {
		AppContext.defaultAppHome = appHome;
		resetPath();
	}

	private static void setConfFile(File confFile) {
		AppContext.confFile = confFile;
	}

	private static void setCacheFile(File cacheFile) {
		AppContext.cacheFile = cacheFile;
	}

	private static void setTempFile(File tempFile) {
		AppContext.tempFile = tempFile;
	}

	private static void setUploadFile(File uploadFile) {
		AppContext.uploadFile = uploadFile;
	}

	private static void setGlobalConfFile(File globalConfFile) {
		AppContext.globalConfFile = globalConfFile;
	}

	private static void setGlobalCacheFile(File globalCacheFile) {
		AppContext.globalCacheFile = globalCacheFile;
	}

	private static void setGlobalTempFile(File globalTempFile) {
		AppContext.globalTempFile = globalTempFile;
	}

	private static void setGlobalUploadFile(File globalUploadFile) {
		AppContext.globalUploadFile = globalUploadFile;
	}

	private static void initConfig(SysConfig sysConfig) {
		resetPath();

		setIsDevelop(sysConfig.isDevelop());
	}

	private static void mkdirs(File file) {
		if (file != null && !file.exists()) {
			file.mkdirs();
		}
	}

	private static String realPath(String path) {
		String realPath = path.replace("${install_home}", PathUtil.getInstallPath()).replace("${app_home}",
				PathUtil.getAppHomePath());
		return PathSupport.getFormatPath(realPath);
	}

	private static void resetPath() {
		if (sysConfig != null) {
			String appHomePath = sysConfig.getAppHome();

			if (AssertUtil.isNotEmpty(appHomePath) && appHomePath.startsWith("${")) {
				appHomePath = realPath(appHomePath);
				PathUtil.setAppHome(new File(appHomePath));
			} else if (defaultAppHome != null) {
				PathUtil.setAppHome(defaultAppHome);
			}

			String globalHome = sysConfig.getAppGlobalHome();
			if (AssertUtil.isNotEmpty(globalHome)) {
				globalHome = realPath(globalHome);
				PathUtil.setGlobalHome(new File(globalHome));
			}
			String logHome = sysConfig.getLogHome();
			if (AssertUtil.isNotEmpty(logHome)) {
				logHome = realPath(logHome);
				PathUtil.setLogHome(new File(logHome));
			}

			setConfFile(new File(getAppHome(), CONF_DIR));
			setCacheFile(new File(getAppHome(), CACHE_DIR));
			setUploadFile(new File(getAppHome(), UPLOAD_DIR));
			setTempFile(new File(getAppHome(), TEMP_DIR));
			setTestFile(new File(getAppHome(), TEST_DIR));

			setGlobalConfFile(new File(getGlobalHome(), CONF_DIR));
			setGlobalCacheFile(new File(getGlobalHome(), CACHE_DIR));
			setGlobalTempFile(new File(getGlobalHome(), TEMP_DIR));
			setGlobalUploadFile(new File(getGlobalHome(), UPLOAD_DIR));
		}
	}

	/**
	 * 获取资源路径，按顺序查找appHome,globalHome,installHome找到资源直接返回
	 * @param filePath 文件路径
	 * @return
	 */
	public static File getResource(String filePath) {
		File resource = PathUtil.getResource(getAppHome(), filePath);
		if (resource == null) {
			resource = PathUtil.getResource(getGlobalHome(), filePath);
			if (resource == null) {
				resource = PathUtil.getResource(PathUtil.getInstallHome(), filePath);
			}
		}
		return resource;
	}

	/**
	 * 获取资源路径，按顺序查找appHome,globalHome,installHome找到资源直接返回
	 * @param filePath 文件路径
	 * @return
	 */
	public static URL getResources(String filePath) {
		return PathUtil.getResources(filePath);
	}

	/**
	 * 获取相对于appHome的绝对路径
	 * @param filePath 文件路径
	 * @return
	 */
	public static String getAppHomePath(String... filePath) {
		return PathUtil.getFilePath(PathUtil.getAppHomePath(), filePath);
	}

	/**
	 * 获取相对于globalHome的绝对路径
	 * @param filePath 文件路径
	 * @return
	 */
	public static String getGlobalHomePath(String... filePath) {
		return PathUtil.getFilePath(PathUtil.getGlobalHomePath(), filePath);
	}

	public static Boolean getIsDevelop() {
		return isDevelop;
	}

	public static boolean isDevelop() {
		if (isDevelop == null) {
			return true;
		}

		return isDevelop;
	}

	public static void setIsDevelop(Boolean isDevelop) {
		AppContext.isDevelop = isDevelop;
	}

	public static SysConfig getSysConfig() {
		return sysConfig;
	}

	public static boolean destory() {
		try {
			return true;
		} catch (Exception e) {
			return false;
		}
	}

	public static boolean stop() {
		if (loggerConfig != null) {
			loggerConfig.stop();
		}

		return true;
	}
}
