/*
 * Decompiled with CFR 0.152.
 */
package cn.elegent.security.verifier.gateway.filter;

import cn.elegent.security.common.base.AuthorizationResult;
import cn.elegent.security.verifier.core.AccessDeniedHandler;
import cn.elegent.security.verifier.core.AuthenticationEntryPoint;
import cn.elegent.security.verifier.core.AuthorizationManager;
import cn.elegent.security.verifier.properties.TokenProperties;
import com.alibaba.fastjson.JSON;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.GlobalFilter;
import org.springframework.core.Ordered;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.http.server.reactive.ServerHttpResponse;
import org.springframework.stereotype.Component;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;

@Component
public class TokenFilter
implements GlobalFilter,
Ordered {
    @Autowired
    private AuthorizationManager<ServerHttpRequest, ServerHttpResponse> authorizationManager;
    @Autowired
    private TokenProperties tokenProperties;
    @Autowired
    private AuthenticationEntryPoint<ServerHttpRequest, ServerHttpResponse> authenticationEntryPoint;
    @Autowired
    private AccessDeniedHandler<ServerHttpRequest, ServerHttpResponse> accessDeniedHandler;

    public Mono<Void> filter(ServerWebExchange exchange, GatewayFilterChain chain) {
        ServerHttpResponse response;
        ServerHttpRequest request = exchange.getRequest();
        AuthorizationResult authorizationResult = this.authorizationManager.check((Object)request, (Object)(response = exchange.getResponse()));
        if (authorizationResult.getCheckResult() == 1) {
            try {
                String userDetails = URLEncoder.encode(JSON.toJSONString((Object)authorizationResult.getUserDetails()), "UTF-8");
                exchange.getRequest().mutate().header(this.tokenProperties.getHeaderName(), new String[]{authorizationResult.getToken()}).header("elegentUser", new String[]{userDetails}).build();
                return chain.filter(exchange);
            }
            catch (UnsupportedEncodingException e) {
                throw new RuntimeException(e);
            }
        }
        if (authorizationResult.getCheckResult() == 0) {
            this.authenticationEntryPoint.commence((Object)request, (Object)response);
        }
        if (authorizationResult.getCheckResult() == -1) {
            this.accessDeniedHandler.handle((Object)request, (Object)response);
        }
        return exchange.getResponse().setComplete();
    }

    public int getOrder() {
        return 0;
    }
}

