/*
 * Decompiled with CFR 0.152.
 */
package cn.elegent.security.verifier.gateway.acquirer;

import cn.elegent.security.common.base.TokenDetails;
import cn.elegent.security.verifier.core.TokenAcquirer;
import cn.elegent.security.verifier.properties.TokenProperties;
import java.util.List;
import org.springframework.http.server.reactive.ServerHttpRequest;

public class GatewayTokenAcquirer
implements TokenAcquirer<ServerHttpRequest> {
    private TokenProperties tokenProperties;

    public TokenDetails getToken(ServerHttpRequest request) {
        List headers = request.getHeaders().get((Object)this.tokenProperties.getHeaderName());
        if (headers == null) {
            return null;
        }
        String token = (String)headers.get(0);
        if (token == null) {
            return null;
        }
        TokenDetails tokenDetails = new TokenDetails();
        tokenDetails.setAccessToken(token);
        return tokenDetails;
    }

    GatewayTokenAcquirer(TokenProperties tokenProperties) {
        this.tokenProperties = tokenProperties;
    }

    public static GatewayTokenAcquirerBuilder builder() {
        return new GatewayTokenAcquirerBuilder();
    }

    public static class GatewayTokenAcquirerBuilder {
        private TokenProperties tokenProperties;

        GatewayTokenAcquirerBuilder() {
        }

        public GatewayTokenAcquirerBuilder tokenProperties(TokenProperties tokenProperties) {
            this.tokenProperties = tokenProperties;
            return this;
        }

        public GatewayTokenAcquirer build() {
            return new GatewayTokenAcquirer(this.tokenProperties);
        }

        public String toString() {
            return "GatewayTokenAcquirer.GatewayTokenAcquirerBuilder(tokenProperties=" + this.tokenProperties + ")";
        }
    }
}

