package cn.elegent.security.verifier.gateway.acquirer;

import cn.elegent.security.common.base.TokenDetails;
import cn.elegent.security.verifier.core.TokenAcquirer;
import cn.elegent.security.verifier.properties.TokenProperties;
import lombok.Builder;
import org.springframework.http.server.reactive.ServerHttpRequest;
import java.util.List;
@Builder
public class GatewayTokenAcquirer implements TokenAcquirer<ServerHttpRequest> {

    private TokenProperties tokenProperties;

    @Override
    public TokenDetails getToken(ServerHttpRequest request) {

        List<String> headers = request.getHeaders().get(tokenProperties.getHeaderName());
        if(headers==null) return null;
        String token  =headers.get(0);
        if(token==null ) return null;
        TokenDetails tokenDetails=new TokenDetails();
        tokenDetails.setAccessToken(token);
        return tokenDetails;

    }
}
