/*
 * Decompiled with CFR 0.152.
 */
package cn.elegent.pay.core;

import cn.elegent.pay.ElegentPay;
import cn.elegent.pay.config.CallbackConfig;
import cn.elegent.pay.core.ElegentLoader;
import cn.elegent.pay.core.ElegentTrade;
import cn.elegent.pay.core.WatchList;
import cn.elegent.pay.dto.PayRequest;
import cn.elegent.pay.dto.PayResponse;
import cn.elegent.pay.dto.QueryRefundResponse;
import cn.elegent.pay.dto.QueryResponse;
import cn.elegent.pay.dto.RefundRequest;
import cn.elegent.pay.dto.WatchDTO;
import cn.elegent.pay.exceptions.TradeException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ElegentPayImpl
implements ElegentPay {
    @Autowired
    private CallbackConfig callbackConfig;

    @Override
    public PayResponse requestPay(PayRequest payRequest, String tradeType, String platform) throws TradeException {
        PayResponse payResponse = this.getPlatFormService(platform).requestPay(payRequest, tradeType);
        if (this.callbackConfig.isWatch()) {
            WatchDTO watchDTO = new WatchDTO();
            watchDTO.setOrderSn(payRequest.getOrderSn());
            watchDTO.setPlatform(platform);
            WatchList.payList.add(watchDTO);
        }
        return payResponse;
    }

    @Override
    public Boolean closePay(String orderSn, String platform) throws TradeException {
        Boolean aBoolean = this.getPlatFormService(platform).closePay(orderSn);
        if (this.callbackConfig.isWatch()) {
            WatchDTO watchDTO = new WatchDTO();
            watchDTO.setOrderSn(orderSn);
            watchDTO.setPlatform(platform);
            WatchList.payList.remove(watchDTO);
        }
        return aBoolean;
    }

    @Override
    public Boolean refund(RefundRequest refundRequest, String platform) throws TradeException {
        Boolean refund = this.getPlatFormService(platform).refund(refundRequest);
        if (this.callbackConfig.isWatch() && refund.booleanValue()) {
            WatchDTO watchDTO = new WatchDTO();
            watchDTO.setOrderSn(refundRequest.getRequestNo());
            watchDTO.setPlatform(platform);
            WatchList.refundList.add(watchDTO);
        }
        return refund;
    }

    @Override
    public QueryResponse queryTradingOrderNo(String orderSn, String Platform2) throws TradeException {
        return this.getPlatFormService(Platform2).queryTradingOrderNo(orderSn);
    }

    @Override
    public QueryRefundResponse queryRefundTrading(String orderSn, String platform) throws TradeException {
        return this.getPlatFormService(platform).queryRefundTrading(orderSn);
    }

    @Override
    public String getOpenid(String code, String platform) {
        return this.getPlatFormService(platform).getOpenid(code);
    }

    private ElegentTrade getPlatFormService(String platForm) {
        return ElegentLoader.getElegentTrade(platForm);
    }
}

