/*
 * Decompiled with CFR 0.152.
 */
package cn.elegent.pay.core;

import cn.elegent.pay.annotation.TradePlatform;
import cn.elegent.pay.core.ElegentTrade;
import cn.elegent.pay.core.ElegentValid;
import cn.elegent.pay.exceptions.TradeException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class ElegentLoader
implements ApplicationContextAware {
    private static final Logger log = LoggerFactory.getLogger(ElegentLoader.class);
    private static Map<String, ElegentTrade> elegentTradeMap = new HashMap<String, ElegentTrade>();
    private static Map<String, ElegentValid> elegentValidMap = new HashMap<String, ElegentValid>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Collection elegentTrades = applicationContext.getBeansOfType(ElegentTrade.class).values();
        elegentTrades.stream().forEach(e -> {
            TradePlatform annotation = e.getClass().getAnnotation(TradePlatform.class);
            if (annotation != null) {
                elegentTradeMap.put(annotation.value(), (ElegentTrade)e);
            }
        });
        Collection elegentValids = applicationContext.getBeansOfType(ElegentValid.class).values();
        elegentValids.stream().forEach(e -> {
            TradePlatform annotation = e.getClass().getAnnotation(TradePlatform.class);
            if (annotation != null) {
                elegentValidMap.put(annotation.value(), (ElegentValid)e);
            }
        });
    }

    public static ElegentTrade getElegentTrade(String platform) {
        ElegentTrade elegentPayTemplate = elegentTradeMap.get(platform);
        if (elegentPayTemplate != null) {
            return elegentPayTemplate;
        }
        throw new TradeException("\u672a\u627e\u5230\u9002\u914d\u7684\u4ea4\u6613\u7c7b\u578b,\u4ea4\u6613\u5e73\u53f0id:" + platform);
    }

    public static ElegentValid getElegentValid(String platform) {
        ElegentValid elegentValidTemplate = elegentValidMap.get(platform);
        if (elegentValidTemplate != null) {
            return elegentValidTemplate;
        }
        throw new TradeException("\u672a\u627e\u5230\u9002\u914d\u7684\u4ea4\u6613\u7c7b\u578b,\u4ea4\u6613\u5e73\u53f0id:" + platform);
    }
}

