/*
 * Decompiled with CFR 0.152.
 */
package cn.elegent.pay.core;

import cn.elegent.pay.CallBackService;
import cn.elegent.pay.ElegentPay;
import cn.elegent.pay.config.CallbackConfig;
import cn.elegent.pay.core.WatchList;
import cn.elegent.pay.dto.QueryRefundResponse;
import cn.elegent.pay.dto.QueryResponse;
import cn.elegent.pay.dto.WatchDTO;
import java.util.Timer;
import java.util.TimerTask;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="elegent.pay.callback", name={"watch"}, havingValue="true")
public class CallbackWatch {
    private static final Logger log = LoggerFactory.getLogger(CallbackWatch.class);
    @Autowired
    private CallBackService callBackService;
    @Autowired
    private CallbackConfig callbackConfig;
    @Autowired
    private ElegentPay elegentPay;

    @PostConstruct
    public void queryWatch() {
        if (this.callbackConfig.getCycle() <= 0) {
            return;
        }
        log.info("\u5f00\u542f\u652f\u4ed8\u7ed3\u679c\u5b9a\u671f\u5de1\u68c0");
        Timer timer = new Timer();
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    QueryResponse queryResponse;
                    log.info("\u652f\u4ed8\u72b6\u6001\u5b9a\u671f\u5de1\u68c0,{}", WatchList.payList);
                    for (WatchDTO watchDTO : WatchList.payList) {
                        queryResponse = CallbackWatch.this.elegentPay.queryTradingOrderNo(watchDTO.getOrderSn(), watchDTO.getPlatform());
                        if (!"SUCCESS".equals(queryResponse.getTrade_state())) continue;
                        CallbackWatch.this.callBackService.successPay(queryResponse.getOrder_sn());
                        WatchList.payList.remove(watchDTO);
                    }
                    log.info("\u9000\u6b3e\u72b6\u6001\u5b9a\u671f\u5de1\u68c0,{}", WatchList.refundList);
                    for (WatchDTO watchDTO : WatchList.refundList) {
                        queryResponse = CallbackWatch.this.elegentPay.queryRefundTrading(watchDTO.getOrderSn(), watchDTO.getPlatform());
                        if (!"SUCCESS".equals(((QueryRefundResponse)queryResponse).getStatus())) continue;
                        CallbackWatch.this.callBackService.successRefund(queryResponse.getOrder_sn());
                        WatchList.refundList.remove(watchDTO);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        timer.schedule(task, this.callbackConfig.getCycle() * 1000, (long)(this.callbackConfig.getCycle() * 1000));
    }
}

