/*
 * Decompiled with CFR 0.152.
 */
package cn.elegent.pay.core;

import cn.elegent.pay.CallBackService;
import cn.elegent.pay.core.ElegentLoader;
import cn.elegent.pay.core.ElegentValid;
import cn.elegent.pay.dto.ValidResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/payCallBack"})
public class CallbackController {
    private static final Logger log = LoggerFactory.getLogger(CallbackController.class);
    @Autowired
    private CallBackService callBackService;

    @RequestMapping(value={"/notify/{platform}"})
    public String notify(HttpEntity<String> httpEntity, HttpServletRequest request, HttpServletResponse response, @PathVariable(value="platform") String platform) {
        ElegentValid elegentValid = ElegentLoader.getElegentValid(platform);
        try {
            ValidResponse validResponse = elegentValid.validPay(httpEntity, request);
            String orderSn = validResponse.getOrderSn();
            if (validResponse.isValid()) {
                this.callBackService.successPay(orderSn);
                return elegentValid.successResult();
            }
            this.callBackService.failPay(orderSn);
            return elegentValid.failResult();
        }
        catch (Exception e) {
            log.error("\u652f\u4ed8\u56de\u8c03\u5904\u7406\u5931\u8d25", (Throwable)e);
            return elegentValid.failResult();
        }
    }

    @RequestMapping(value={"/refund_notify/{platform}"})
    public String refundNotify(HttpEntity<String> httpEntity, HttpServletRequest request, HttpServletResponse response, @PathVariable(value="platform") String platform) {
        ElegentValid elegentValid = ElegentLoader.getElegentValid(platform);
        try {
            ValidResponse validResponse = elegentValid.validRefund(httpEntity, request);
            String orderSn = validResponse.getOrderSn();
            if (validResponse.isValid()) {
                this.callBackService.successRefund(orderSn);
                return elegentValid.successResult();
            }
            this.callBackService.failRefund(orderSn);
            return elegentValid.failResult();
        }
        catch (Exception e) {
            log.error("\u9000\u6b3e\u56de\u8c03\u5904\u7406\u5931\u8d25", (Throwable)e);
            return elegentValid.failResult();
        }
    }
}

