/*
 * Decompiled with CFR 0.152.
 */
package cn.elegent.ac.amqp;

import cn.elegent.ac.core.ACDistributer;
import cn.elegent.ac.core.ACTemplateImpl;
import cn.elegent.ac.core.SendBody;
import com.alibaba.fastjson.JSON;
import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.Channel;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.Consumer;
import com.rabbitmq.client.DefaultConsumer;
import com.rabbitmq.client.Envelope;
import com.rabbitmq.client.MessageProperties;
import java.io.IOException;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AmqpTemplate
extends ACTemplateImpl {
    private static final Logger log = LoggerFactory.getLogger(AmqpTemplate.class);
    @Autowired
    private Connection connection;
    @Autowired
    private ACDistributer acDistributer;

    public boolean publish(String topic, SendBody sendBody) {
        try {
            Channel channel = this.connection.createChannel();
            channel.queueDeclare(topic, true, false, false, null);
            String payload = JSON.toJSONString((Object)sendBody);
            channel.basicPublish("", topic, MessageProperties.PERSISTENT_TEXT_PLAIN, payload.getBytes());
            channel.close();
            return true;
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        catch (TimeoutException e) {
            e.printStackTrace();
            return false;
        }
    }

    public void subscribe(final String topic) {
        try {
            Channel channel = this.connection.createChannel();
            channel.queueDeclare(topic, true, false, false, null);
            channel.basicConsume(topic, true, (Consumer)new DefaultConsumer(channel){

                public void handleDelivery(String consumerTag, Envelope envelope, AMQP.BasicProperties properties, byte[] body) throws IOException {
                    System.out.println("\u53d6\u51fa\u6d88\u606f:===>" + consumerTag + "|" + new String(body));
                    System.out.println(envelope.getRoutingKey());
                    AmqpTemplate.this.acDistributer.distribute(topic, new String(body));
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void unSubscribe(String topic) {
    }
}

