/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.tsinghua.iotdb.jdbc;

import cn.edu.tsinghua.iotdb.jdbc.ColumnSchema;
import cn.edu.tsinghua.iotdb.jdbc.TsfileConnectionParams;
import cn.edu.tsinghua.iotdb.jdbc.TsfileSQLException;
import cn.edu.tsinghua.iotdb.jdbc.TsfileURLException;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSColumnSchema;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSDynamicOneColumnData;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSQueryDataSet;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TS_Status;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TS_StatusCode;
import cn.edu.tsinghua.tsfile.common.exception.UnSupportedDataTypeException;
import cn.edu.tsinghua.tsfile.common.utils.Binary;
import cn.edu.tsinghua.tsfile.file.metadata.enums.TSDataType;
import cn.edu.tsinghua.tsfile.file.metadata.enums.TSEncoding;
import cn.edu.tsinghua.tsfile.timeseries.read.query.DynamicOneColumnData;
import cn.edu.tsinghua.tsfile.timeseries.read.query.QueryDataSet;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Utils {
    public static TsfileConnectionParams parseURL(String url, Properties info) throws TsfileURLException {
        TsfileConnectionParams params = new TsfileConnectionParams(url);
        if (url.trim().equalsIgnoreCase("jdbc:tsfile://")) {
            return params;
        }
        Pattern pattern = Pattern.compile("([^;]*):([^;]*)/");
        Matcher matcher = pattern.matcher(url.substring("jdbc:tsfile://".length()));
        boolean isUrlLegal = false;
        while (matcher.find()) {
            params.setHost(matcher.group(1));
            params.setPort(Integer.parseInt(matcher.group(2)));
            isUrlLegal = true;
        }
        if (!isUrlLegal) {
            throw new TsfileURLException("Error url format, url should be jdbc:tsfile://ip:port/");
        }
        if (info.containsKey("user")) {
            params.setUsername(info.getProperty("user"));
        }
        if (info.containsKey("password")) {
            params.setPassword(info.getProperty("password"));
        }
        return params;
    }

    public static void verifySuccess(TS_Status status) throws TsfileSQLException {
        if (status.getStatusCode() != TS_StatusCode.SUCCESS_STATUS) {
            throw new TsfileSQLException(status.errorMessage);
        }
    }

    public static Map<String, List<ColumnSchema>> convertAllSchema(Map<String, List<TSColumnSchema>> tsAllSchema) {
        if (tsAllSchema == null) {
            return null;
        }
        HashMap<String, List<ColumnSchema>> allSchema = new HashMap<String, List<ColumnSchema>>();
        for (Map.Entry<String, List<TSColumnSchema>> entry : tsAllSchema.entrySet()) {
            ArrayList<ColumnSchema> columnSchemas = new ArrayList<ColumnSchema>();
            for (TSColumnSchema columnSchema : entry.getValue()) {
                columnSchemas.add(Utils.convertColumnSchema(columnSchema));
            }
            allSchema.put(entry.getKey(), columnSchemas);
        }
        return allSchema;
    }

    private static ColumnSchema convertColumnSchema(TSColumnSchema tsSchema) {
        if (tsSchema == null) {
            return null;
        }
        TSDataType dataType = tsSchema.dataType == null ? null : TSDataType.valueOf((String)tsSchema.dataType);
        TSEncoding encoding = tsSchema.encoding == null ? null : TSEncoding.valueOf((String)tsSchema.encoding);
        ColumnSchema ColumnSchema2 = new ColumnSchema(tsSchema.name, dataType, encoding);
        ColumnSchema2.setArgsMap(tsSchema.getOtherArgs());
        return ColumnSchema2;
    }

    public static QueryDataSet convertQueryDataSet(TSQueryDataSet tsQueryDataSet) {
        QueryDataSet queryDataSet = new QueryDataSet();
        List<String> keys = tsQueryDataSet.getKeys();
        List<TSDynamicOneColumnData> values = tsQueryDataSet.getValues();
        LinkedHashMap<String, DynamicOneColumnData> ret = new LinkedHashMap<String, DynamicOneColumnData>();
        int length = keys.size();
        for (int i = 0; i < length; ++i) {
            ret.put(keys.get(i), Utils.convertDynamicOneColumnData(values.get(i)));
        }
        queryDataSet.mapRet = ret;
        return queryDataSet;
    }

    private static DynamicOneColumnData convertDynamicOneColumnData(TSDynamicOneColumnData tsDynamicOneColumnData) {
        TSDataType dataType = TSDataType.valueOf((String)tsDynamicOneColumnData.getDataType());
        DynamicOneColumnData dynamicOneColumnData = new DynamicOneColumnData(dataType, true);
        dynamicOneColumnData.setDeltaObjectType(tsDynamicOneColumnData.getDeviceType());
        Iterator<Number> iterator = tsDynamicOneColumnData.getTimeRet().iterator();
        while (iterator.hasNext()) {
            long time = iterator.next();
            dynamicOneColumnData.putTime(time);
        }
        switch (dataType) {
            case BOOLEAN: {
                tsDynamicOneColumnData.getBoolList().forEach(arg_0 -> ((DynamicOneColumnData)dynamicOneColumnData).putBoolean(arg_0));
                break;
            }
            case INT32: {
                for (Integer integer : tsDynamicOneColumnData.getI32List()) {
                    dynamicOneColumnData.putInt(integer.intValue());
                }
                break;
            }
            case INT64: {
                tsDynamicOneColumnData.getI64List().forEach(arg_0 -> ((DynamicOneColumnData)dynamicOneColumnData).putLong(arg_0));
                break;
            }
            case FLOAT: {
                List<Double> floats = tsDynamicOneColumnData.getFloatList();
                for (double f : floats) {
                    dynamicOneColumnData.putFloat((float)f);
                }
                break;
            }
            case DOUBLE: {
                tsDynamicOneColumnData.getDoubleList().forEach(arg_0 -> ((DynamicOneColumnData)dynamicOneColumnData).putDouble(arg_0));
                break;
            }
            case TEXT: {
                List<ByteBuffer> binaries = tsDynamicOneColumnData.getBinaryList();
                for (ByteBuffer b : binaries) {
                    dynamicOneColumnData.putBinary(new Binary(StandardCharsets.UTF_8.decode(b).toString()));
                }
                break;
            }
            default: {
                throw new UnSupportedDataTypeException(String.format("data type %s is not supported when convert data at client", dataType));
            }
        }
        return dynamicOneColumnData;
    }
}

