/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.tsinghua.iotdb.jdbc;

import cn.edu.tsinghua.iotdb.jdbc.TsfileConnection;
import cn.edu.tsinghua.iotdb.jdbc.TsfileJDBCConfig;
import cn.edu.tsinghua.iotdb.jdbc.TsfileQueryResultSet;
import cn.edu.tsinghua.iotdb.jdbc.TsfileSQLException;
import cn.edu.tsinghua.iotdb.jdbc.Utils;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSCancelOperationReq;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSCancelOperationResp;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSCloseOperationReq;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSCloseOperationResp;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSExecuteBatchStatementReq;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSExecuteBatchStatementResp;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSExecuteStatementReq;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSExecuteStatementResp;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSIService;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSOperationHandle;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TS_SessionHandle;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import org.apache.thrift.TException;

public class TsfileStatement
implements Statement {
    private ResultSet resultSet = null;
    private TsfileConnection connection;
    private int fetchSize = TsfileJDBCConfig.fetchSize;
    private int queryTimeout = 10;
    private TSIService.Iface client = null;
    private TS_SessionHandle sessionHandle = null;
    private TSOperationHandle operationHandle = null;
    private List<String> batchSQLList;
    private boolean isClosed = false;
    private boolean isCancelled = false;
    private int maxRows = 0;
    private SQLWarning warningChain = null;

    public TsfileStatement(TsfileConnection connection, TSIService.Iface client, TS_SessionHandle sessionHandle, int fetchSize) {
        this.connection = connection;
        this.client = client;
        this.sessionHandle = sessionHandle;
        this.fetchSize = fetchSize;
        this.batchSQLList = new ArrayList<String>();
    }

    public TsfileStatement(TsfileConnection connection, TSIService.Iface client, TS_SessionHandle sessionHandle) {
        this(connection, client, sessionHandle, TsfileJDBCConfig.fetchSize);
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return false;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Cannot unwrap to " + iface);
    }

    @Override
    public void addBatch(String sql) throws SQLException {
        if (this.batchSQLList == null) {
            this.batchSQLList = new ArrayList<String>();
        }
        this.batchSQLList.add(sql);
    }

    @Override
    public void cancel() throws SQLException {
        this.checkConnection("cancel");
        if (this.isCancelled) {
            return;
        }
        try {
            if (this.operationHandle != null) {
                TSCancelOperationReq closeReq = new TSCancelOperationReq(this.operationHandle);
                TSCancelOperationResp closeResp = this.client.cancelOperation(closeReq);
                Utils.verifySuccess(closeResp.getStatus());
            }
        }
        catch (Exception e) {
            throw new SQLException("Error occurs when canceling statement because " + e.getMessage());
        }
        this.isCancelled = true;
    }

    @Override
    public void clearBatch() throws SQLException {
        if (this.batchSQLList == null) {
            this.batchSQLList = new ArrayList<String>();
        }
        this.batchSQLList.clear();
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    public void closeClientOperation() throws SQLException {
        try {
            if (this.operationHandle != null) {
                TSCloseOperationReq closeReq = new TSCloseOperationReq(this.operationHandle);
                TSCloseOperationResp closeResp = this.client.closeOperation(closeReq);
                Utils.verifySuccess(closeResp.getStatus());
            }
        }
        catch (Exception e) {
            throw new SQLException("Error occurs when closing statement because " + e.getMessage());
        }
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        this.closeClientOperation();
        this.client = null;
        this.isClosed = true;
    }

    @Override
    public void closeOnCompletion() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean execute(String sql) throws SQLException {
        this.checkConnection("execute");
        try {
            return this.executeSQL(sql);
        }
        catch (TException e) {
            boolean flag = this.connection.reconnect();
            this.reInit();
            if (flag) {
                try {
                    return this.executeSQL(sql);
                }
                catch (TException e2) {
                    throw new SQLException(String.format("Fail to execute %s after reconnecting. please check server status", sql));
                }
            }
            throw new SQLException(String.format("Fail to reconnect to server when executing %s. please check server status", sql));
        }
    }

    private boolean executeSQL(String sql) throws TException, SQLException {
        this.isCancelled = false;
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionHandle, sql);
        TSExecuteStatementResp execResp = this.client.executeStatement(execReq);
        this.operationHandle = execResp.getOperationHandle();
        Utils.verifySuccess(execResp.getStatus());
        if (execResp.getOperationHandle().hasResultSet) {
            this.resultSet = new TsfileQueryResultSet(this, execResp.getColumns(), this.client, this.sessionHandle, this.operationHandle, sql, execResp.getOperationType());
            return true;
        }
        return false;
    }

    @Override
    public boolean execute(String arg0, int arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean execute(String arg0, int[] arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean execute(String arg0, String[] arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int[] executeBatch() throws SQLException {
        this.checkConnection("executeBatch");
        try {
            return this.executeBatchSQL();
        }
        catch (TException e) {
            boolean flag = this.connection.reconnect();
            this.reInit();
            if (flag) {
                try {
                    return this.executeBatchSQL();
                }
                catch (TException e2) {
                    throw new SQLException("Fail to execute batch sqls after reconnecting. please check server status");
                }
            }
            throw new SQLException("Fail to reconnect to server when executing batch sqls. please check server status");
        }
    }

    private int[] executeBatchSQL() throws TException, TsfileSQLException {
        this.isCancelled = false;
        TSExecuteBatchStatementReq execReq = new TSExecuteBatchStatementReq(this.sessionHandle, this.batchSQLList);
        TSExecuteBatchStatementResp execResp = this.client.executeBatchStatement(execReq);
        Utils.verifySuccess(execResp.getStatus());
        if (execResp.getResult() == null) {
            return new int[0];
        }
        List<Integer> result = execResp.getResult();
        int len = result.size();
        int[] updateArray = new int[len];
        for (int i = 0; i < len; ++i) {
            updateArray[i] = result.get(i);
        }
        return updateArray;
    }

    @Override
    public ResultSet executeQuery(String sql) throws SQLException {
        this.checkConnection("execute");
        try {
            return this.executeQuerySQL(sql);
        }
        catch (TException e) {
            boolean flag = this.connection.reconnect();
            this.reInit();
            if (flag) {
                try {
                    return this.executeQuerySQL(sql);
                }
                catch (TException e2) {
                    throw new SQLException("Fail to executeQuery " + sql + "after reconnecting. please check server status");
                }
            }
            throw new SQLException("Fail to reconnect to server when execute query " + sql + ". please check server status");
        }
    }

    private ResultSet executeQuerySQL(String sql) throws TException, SQLException {
        this.isCancelled = false;
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionHandle, sql);
        TSExecuteStatementResp execResp = this.client.executeQueryStatement(execReq);
        this.operationHandle = execResp.getOperationHandle();
        Utils.verifySuccess(execResp.getStatus());
        this.resultSet = new TsfileQueryResultSet(this, execResp.getColumns(), this.client, this.sessionHandle, this.operationHandle, sql, execResp.getOperationType());
        return this.resultSet;
    }

    @Override
    public int executeUpdate(String sql) throws SQLException {
        try {
            return this.executeUpdateSQL(sql);
        }
        catch (TException e) {
            boolean flag = this.connection.reconnect();
            this.reInit();
            if (flag) {
                try {
                    return this.executeUpdateSQL(sql);
                }
                catch (TException e2) {
                    throw new SQLException("Fail to execute update " + sql + "after reconnecting. please check server status");
                }
            }
            throw new SQLException("Fail to reconnect to server when execute update " + sql + ". please check server status");
        }
    }

    private int executeUpdateSQL(String sql) throws TException, TsfileSQLException {
        TSExecuteStatementReq execReq = new TSExecuteStatementReq(this.sessionHandle, sql);
        TSExecuteStatementResp execResp = this.client.executeUpdateStatement(execReq);
        this.operationHandle = execResp.getOperationHandle();
        Utils.verifySuccess(execResp.getStatus());
        return 0;
    }

    @Override
    public int executeUpdate(String arg0, int arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int executeUpdate(String arg0, int[] arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int executeUpdate(String arg0, String[] arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public int getFetchDirection() throws SQLException {
        this.checkConnection("getFetchDirection");
        return 1000;
    }

    @Override
    public int getFetchSize() throws SQLException {
        this.checkConnection("getFetchSize");
        return this.fetchSize;
    }

    @Override
    public ResultSet getGeneratedKeys() throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getMaxFieldSize() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getMaxRows() throws SQLException {
        this.checkConnection("getMaxRows");
        return this.maxRows;
    }

    @Override
    public boolean getMoreResults() throws SQLException {
        return false;
    }

    @Override
    public boolean getMoreResults(int arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public int getQueryTimeout() throws SQLException {
        return this.queryTimeout;
    }

    @Override
    public ResultSet getResultSet() throws SQLException {
        this.checkConnection("getResultSet");
        return this.resultSet;
    }

    @Override
    public int getResultSetConcurrency() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getResultSetType() throws SQLException {
        this.checkConnection("getResultSetType");
        return 1003;
    }

    @Override
    public int getUpdateCount() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public boolean isCloseOnCompletion() throws SQLException {
        return false;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isPoolable() throws SQLException {
        return false;
    }

    @Override
    public void setCursorName(String arg0) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setEscapeProcessing(boolean enable) throws SQLException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public void setFetchDirection(int direction) throws SQLException {
        this.checkConnection("setFetchDirection");
        if (direction != 1000) {
            throw new SQLException(String.format("direction %d is not supported!", direction));
        }
    }

    @Override
    public void setFetchSize(int fetchSize) throws SQLException {
        this.checkConnection("setFetchSize");
        if (fetchSize < 0) {
            throw new SQLException(String.format("fetchSize %d must be >= 0!", fetchSize));
        }
        this.fetchSize = fetchSize == 0 ? TsfileJDBCConfig.fetchSize : fetchSize;
    }

    @Override
    public void setMaxFieldSize(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setMaxRows(int num) throws SQLException {
        this.checkConnection("setMaxRows");
        if (num < 0) {
            throw new SQLException(String.format("maxRows %d must be >= 0!", num));
        }
        this.maxRows = num;
    }

    @Override
    public void setPoolable(boolean arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setQueryTimeout(int seconds) throws SQLException {
        this.checkConnection("setQueryTimeout");
        if (seconds <= 0) {
            throw new SQLException(String.format("queryTimeout %d must be >= 0!", seconds));
        }
        this.queryTimeout = seconds;
    }

    private void checkConnection(String action) throws SQLException {
        if (this.isClosed) {
            throw new SQLException(String.format("Cannot %s after statement has been closed!", action));
        }
    }

    private void reInit() {
        this.client = this.connection.client;
        this.sessionHandle = this.connection.sessionHandle;
    }
}

