/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.tsinghua.iotdb.jdbc;

import cn.edu.tsinghua.iotdb.jdbc.TsfileConnection;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.thrift.transport.TTransportException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TsfileDriver
implements Driver {
    private final String TSFILE_URL_PREFIX = "jdbc:tsfile://.*";
    private static final Logger LOGGER = LoggerFactory.getLogger(TsfileDriver.class);
    private static final boolean TSFILE_JDBC_COMPLIANT = false;

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return Pattern.matches("jdbc:tsfile://.*", url);
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        try {
            return this.acceptsURL(url) ? new TsfileConnection(url, info) : null;
        }
        catch (TTransportException e) {
            throw new SQLException("Connection Error, please check whether the network is avaliable or the server has started.");
        }
    }

    @Override
    public int getMajorVersion() {
        return 0;
    }

    @Override
    public int getMinorVersion() {
        return 0;
    }

    @Override
    public java.util.logging.Logger getParentLogger() throws SQLFeatureNotSupportedException {
        throw new SQLFeatureNotSupportedException("Method not supported");
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        return null;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    static {
        try {
            DriverManager.registerDriver(new TsfileDriver());
        }
        catch (SQLException e) {
            LOGGER.error("Error occurs when registering TsFile driver", (Throwable)e);
        }
    }
}

