/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.tsinghua.iotdb.jdbc;

import cn.edu.tsinghua.iotdb.jdbc.ColumnSchema;
import cn.edu.tsinghua.iotdb.jdbc.TsfileConnection;
import cn.edu.tsinghua.iotdb.jdbc.TsfileMetadataResultSet;
import cn.edu.tsinghua.iotdb.jdbc.TsfileSQLException;
import cn.edu.tsinghua.iotdb.jdbc.Utils;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSFetchMetadataReq;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSFetchMetadataResp;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSIService;
import cn.edu.tsinghua.tsfile.file.metadata.enums.TSDataType;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.RowIdLifetime;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.thrift.TException;

public class TsfileDatabaseMetadata
implements DatabaseMetaData {
    private TsfileConnection connection;
    private TSIService.Iface client;

    public TsfileDatabaseMetadata(TsfileConnection connection, TSIService.Iface client) {
        this.connection = connection;
        this.client = client;
    }

    @Override
    public ResultSet getColumns(String catalog, String schemaPattern, String columnPattern, String deltaObjectPattern) throws SQLException {
        try {
            return this.getColumnsOrDeltaObject(catalog, schemaPattern, columnPattern, deltaObjectPattern);
        }
        catch (TException e) {
            boolean flag = this.connection.reconnect();
            this.client = this.connection.client;
            if (flag) {
                try {
                    return this.getColumnsOrDeltaObject(catalog, schemaPattern, columnPattern, deltaObjectPattern);
                }
                catch (TException e2) {
                    throw new SQLException(String.format("Fail to get colums catalog=%s, schemaPattern=%s, columnPattern=%s, deltaObjectPattern=%s after reconnecting. please check server status", catalog, schemaPattern, columnPattern, deltaObjectPattern));
                }
            }
            throw new SQLException(String.format("Fail to reconnect to server when getting colums catalog=%s, schemaPattern=%s, columnPattern=%s, deltaObjectPattern=%s after reconnecting. please check server status", catalog, schemaPattern, columnPattern, deltaObjectPattern));
        }
    }

    private ResultSet getColumnsOrDeltaObject(String catalog, String schemaPattern, String columnPattern, String deltaObjectPattern) throws TException, SQLException {
        if (deltaObjectPattern != null && !deltaObjectPattern.trim().equals("")) {
            TSFetchMetadataReq req = new TSFetchMetadataReq("DELTA_OBEJECT");
            try {
                TSFetchMetadataResp resp = this.client.fetchMetadata(req);
                Utils.verifySuccess(resp.getStatus());
                Map<String, List<String>> deltaObjectList = resp.getDeltaObjectMap();
                if (deltaObjectList == null || !deltaObjectList.containsKey(deltaObjectPattern)) {
                    new TsfileMetadataResultSet(null, new ArrayList<String>());
                }
                return new TsfileMetadataResultSet(null, deltaObjectList.get(deltaObjectPattern));
            }
            catch (TException e) {
                throw new TException("Conncetion error when fetching delta object metadata", (Throwable)e);
            }
        }
        if (columnPattern != null && !columnPattern.trim().equals("")) {
            if (!columnPattern.endsWith("*")) {
                TSFetchMetadataReq req = new TSFetchMetadataReq("COLUMN");
                req.setColumnPath(columnPattern);
                try {
                    TSFetchMetadataResp resp = this.client.fetchMetadata(req);
                    Utils.verifySuccess(resp.getStatus());
                    ArrayList<ColumnSchema> columnSchemaNew = new ArrayList<ColumnSchema>();
                    if (resp.getDataType() != null) {
                        columnSchemaNew.add(new ColumnSchema(columnPattern, TSDataType.valueOf((String)resp.getDataType()), null));
                    }
                    return new TsfileMetadataResultSet(columnSchemaNew, null);
                }
                catch (TException e) {
                    throw new TException("Conncetion error when fetching column data type", (Throwable)e);
                }
            }
            TSFetchMetadataReq req = new TSFetchMetadataReq("ALL_COLUMNS");
            req.setColumnPath(columnPattern);
            try {
                TSFetchMetadataResp resp = this.client.fetchMetadata(req);
                Utils.verifySuccess(resp.getStatus());
                ArrayList<ColumnSchema> columnSchemaNew = new ArrayList<ColumnSchema>();
                if (resp.getAllColumns() != null) {
                    for (String path : resp.getAllColumns()) {
                        columnSchemaNew.add(new ColumnSchema(path, null, null));
                    }
                }
                return new TsfileMetadataResultSet(columnSchemaNew, null);
            }
            catch (TException e) {
                throw new TException("Conncetion error when fetching column data type", (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean allProceduresAreCallable() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean allTablesAreSelectable() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean autoCommitFailureClosesAllResultSets() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean dataDefinitionCausesTransactionCommit() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean dataDefinitionIgnoredInTransactions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean deletesAreDetected(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean doesMaxRowSizeIncludeBlobs() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean generatedKeyAlwaysReturned() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getAttributes(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getBestRowIdentifier(String arg0, String arg1, String arg2, int arg3, boolean arg4) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getCatalogSeparator() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getCatalogTerm() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getCatalogs() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getClientInfoProperties() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getColumnPrivileges(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Connection getConnection() throws SQLException {
        return this.connection;
    }

    @Override
    public ResultSet getCrossReference(String arg0, String arg1, String arg2, String arg3, String arg4, String arg5) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getDatabaseMajorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getDatabaseMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public String getDatabaseProductName() throws SQLException {
        return "IoTDB";
    }

    @Override
    public String getDatabaseProductVersion() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getDefaultTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public int getDriverMajorVersion() {
        return 0;
    }

    @Override
    public int getDriverMinorVersion() {
        return 0;
    }

    @Override
    public String getDriverName() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getDriverVersion() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getExportedKeys(String arg0, String arg1, String arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getExtraNameCharacters() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getFunctionColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getFunctions(String arg0, String arg1, String arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getIdentifierQuoteString() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getImportedKeys(String arg0, String arg1, String arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getIndexInfo(String arg0, String arg1, String arg2, boolean arg3, boolean arg4) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getJDBCMajorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getJDBCMinorVersion() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxBinaryLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCatalogNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCharLiteralLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInGroupBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInIndex() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInOrderBy() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxColumnsInTable() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxConnections() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxCursorNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxIndexLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxProcedureNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxRowSize() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxSchemaNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatementLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxStatements() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTableNameLength() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxTablesInSelect() throws SQLException {
        return 0;
    }

    @Override
    public int getMaxUserNameLength() throws SQLException {
        return 0;
    }

    @Override
    public String getNumericFunctions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getPrimaryKeys(String arg0, String arg1, String arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getProcedureColumns(String arg0, String arg1, String arg2, String arg3) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getProcedureTerm() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getProcedures(String arg0, String arg1, String arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getPseudoColumns(String catalog, String schemaPattern, String tableNamePattern, String columnNamePattern) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getResultSetHoldability() throws SQLException {
        return 0;
    }

    @Override
    public RowIdLifetime getRowIdLifetime() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getSQLKeywords() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getSQLStateType() throws SQLException {
        return 0;
    }

    @Override
    public String getSchemaTerm() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getSchemas() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getSchemas(String catalog, String schemaPattern) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getSearchStringEscape() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getStringFunctions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getSuperTables(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getSuperTypes(String catalog, String schemaPattern, String typeNamePattern) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getSystemFunctions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getTablePrivileges(String catalog, String schemaPattern, String tableNamePattern) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getTableTypes() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getTables(String catalog, String schemaPattern, String tableNamePattern, String[] types) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getTimeDateFunctions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getTypeInfo() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getUDTs(String catalog, String schemaPattern, String typeNamePattern, int[] types) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getURL() throws SQLException {
        return null;
    }

    @Override
    public String getUserName() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public ResultSet getVersionColumns(String catalog, String schema, String table) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean insertsAreDetected(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isCatalogAtStart() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean locatorsUpdateCopy() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean nullPlusNonNullIsNull() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean nullsAreSortedAtEnd() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean nullsAreSortedAtStart() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean nullsAreSortedHigh() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean nullsAreSortedLow() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean othersDeletesAreVisible(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean othersInsertsAreVisible(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean othersUpdatesAreVisible(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean ownDeletesAreVisible(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean ownInsertsAreVisible(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean ownUpdatesAreVisible(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean storesLowerCaseIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean storesLowerCaseQuotedIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean storesMixedCaseIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean storesMixedCaseQuotedIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean storesUpperCaseIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean storesUpperCaseQuotedIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsANSI92EntryLevelSQL() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsANSI92FullSQL() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsANSI92IntermediateSQL() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsAlterTableWithAddColumn() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsAlterTableWithDropColumn() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsBatchUpdates() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsCatalogsInDataManipulation() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsCatalogsInIndexDefinitions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsCatalogsInPrivilegeDefinitions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsCatalogsInProcedureCalls() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsCatalogsInTableDefinitions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsColumnAliasing() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsConvert() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsConvert(int fromType, int toType) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsCoreSQLGrammar() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsCorrelatedSubqueries() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsDataDefinitionAndDataManipulationTransactions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsDataManipulationTransactionsOnly() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsDifferentTableCorrelationNames() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsExpressionsInOrderBy() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsExtendedSQLGrammar() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsFullOuterJoins() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsGetGeneratedKeys() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsGroupBy() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsGroupByBeyondSelect() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsGroupByUnrelated() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsIntegrityEnhancementFacility() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsLikeEscapeClause() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsLimitedOuterJoins() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsMinimumSQLGrammar() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsMixedCaseIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsMixedCaseQuotedIdentifiers() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsMultipleOpenResults() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsMultipleResultSets() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsMultipleTransactions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsNamedParameters() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsNonNullableColumns() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsOpenCursorsAcrossCommit() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsOpenCursorsAcrossRollback() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsOpenStatementsAcrossCommit() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsOpenStatementsAcrossRollback() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsOrderByUnrelated() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsOuterJoins() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsPositionedDelete() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsPositionedUpdate() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsResultSetConcurrency(int type, int concurrency) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsResultSetHoldability(int holdability) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsResultSetType(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsSavepoints() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsSchemasInDataManipulation() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsSchemasInIndexDefinitions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsSchemasInPrivilegeDefinitions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsSchemasInProcedureCalls() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsSchemasInTableDefinitions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsSelectForUpdate() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsStatementPooling() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsStoredFunctionsUsingCallSyntax() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsStoredProcedures() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsSubqueriesInComparisons() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsSubqueriesInExists() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsSubqueriesInIns() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsSubqueriesInQuantifieds() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsTableCorrelationNames() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsTransactionIsolationLevel(int level) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsTransactions() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsUnion() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean supportsUnionAll() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean updatesAreDetected(int type) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean usesLocalFilePerTable() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean usesLocalFiles() throws SQLException {
        throw new SQLException("Method not supported");
    }

    public String toString() {
        block7: {
            try {
                return this.getFullTimeseries();
            }
            catch (TException e) {
                boolean flag = this.connection.reconnect();
                this.client = this.connection.client;
                if (flag) {
                    try {
                        return this.getFullTimeseries();
                    }
                    catch (TException e2) {
                        System.out.println("Fail to get all timeseries info after reconnecting. please check server status");
                        break block7;
                    }
                    catch (TsfileSQLException tsfileSQLException) {
                        break block7;
                    }
                }
                System.out.println("Fail to reconnect to server when getting all timeseries info. please check server status");
            }
            catch (TsfileSQLException tsfileSQLException) {
                // empty catch block
            }
        }
        return null;
    }

    private String getFullTimeseries() throws TException, TsfileSQLException {
        TSFetchMetadataReq req = new TSFetchMetadataReq("METADATA_IN_JSON");
        TSFetchMetadataResp resp = this.client.fetchMetadata(req);
        Utils.verifySuccess(resp.getStatus());
        return resp.getMetadataInJson();
    }
}

