/*
 * Decompiled with CFR 0.152.
 */
package cn.edu.tsinghua.iotdb.jdbc;

import cn.edu.tsinghua.iotdb.jdbc.TsfileConnectionParams;
import cn.edu.tsinghua.iotdb.jdbc.TsfileDatabaseMetadata;
import cn.edu.tsinghua.iotdb.jdbc.TsfileJDBCConfig;
import cn.edu.tsinghua.iotdb.jdbc.TsfileSQLException;
import cn.edu.tsinghua.iotdb.jdbc.TsfileStatement;
import cn.edu.tsinghua.iotdb.jdbc.TsfileURLException;
import cn.edu.tsinghua.iotdb.jdbc.Utils;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSCloseSessionReq;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSGetTimeZoneResp;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSIService;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSOpenSessionReq;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSOpenSessionResp;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSProtocolVersion;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSSetTimeZoneReq;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TSSetTimeZoneResp;
import cn.edu.tsinghua.iotdb.jdbc.thrift.TS_SessionHandle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.SocketException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Statement;
import java.sql.Struct;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.Executor;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TBinaryProtocol;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.transport.TSocket;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;
import org.joda.time.DateTimeZone;

public class TsfileConnection
implements Connection {
    private TsfileConnectionParams params;
    private boolean isClosed = true;
    private SQLWarning warningChain = null;
    private TSocket transport;
    public TSIService.Iface client = null;
    public TS_SessionHandle sessionHandle = null;
    private final List<TSProtocolVersion> supportedProtocols = new LinkedList<TSProtocolVersion>();
    private TSProtocolVersion protocol;
    private DateTimeZone timeZone;
    private boolean autoCommit;

    public TsfileConnection(String url, Properties info) throws SQLException, TTransportException {
        if (url == null) {
            throw new TsfileURLException("Input url cannot be null");
        }
        this.params = Utils.parseURL(url, info);
        this.supportedProtocols.add(TSProtocolVersion.TSFILE_SERVICE_PROTOCOL_V1);
        this.openTransport();
        this.client = new TSIService.Client((TProtocol)new TBinaryProtocol((TTransport)this.transport));
        this.openSession();
        this.client = TsfileConnection.newSynchronizedClient(this.client);
        this.autoCommit = false;
    }

    @Override
    public boolean isWrapperFor(Class<?> arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public <T> T unwrap(Class<T> arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void abort(Executor arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void clearWarnings() throws SQLException {
        this.warningChain = null;
    }

    @Override
    public void close() throws SQLException {
        if (this.isClosed) {
            return;
        }
        TSCloseSessionReq req = new TSCloseSessionReq(this.sessionHandle);
        try {
            this.client.closeSession(req);
        }
        catch (TException e) {
            throw new SQLException("Error occurs when closing session at server", e);
        }
        finally {
            this.isClosed = true;
            if (this.transport != null) {
                this.transport.close();
            }
        }
    }

    @Override
    public void commit() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Array createArrayOf(String arg0, Object[] arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Blob createBlob() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Clob createClob() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public NClob createNClob() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Statement createStatement() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Cannot create statement because connection is closed");
        }
        return new TsfileStatement(this, this.client, this.sessionHandle);
    }

    @Override
    public Statement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        if (resultSetConcurrency != 1007) {
            throw new SQLException(String.format("Statement with resultset concurrency %d is not supported", resultSetConcurrency));
        }
        if (resultSetType == 1005) {
            throw new SQLException(String.format("Statement with resultset type %d is not supported", resultSetType));
        }
        return new TsfileStatement(this, this.client, this.sessionHandle);
    }

    @Override
    public Statement createStatement(int arg0, int arg1, int arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Struct createStruct(String arg0, Object[] arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return this.autoCommit;
    }

    @Override
    public String getCatalog() throws SQLException {
        return "no cata log";
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String getClientInfo(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        if (this.isClosed) {
            throw new SQLException("Cannot create statement because connection is closed");
        }
        return new TsfileDatabaseMetadata(this, this.client);
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return TsfileJDBCConfig.connectionTimeoutInMs;
    }

    @Override
    public String getSchema() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return this.warningChain;
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.isClosed;
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public boolean isValid(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public String nativeSQL(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public CallableStatement prepareCall(String arg0, int arg1, int arg2, int arg3) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void releaseSavepoint(Savepoint arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void rollback(Savepoint arg0) throws SQLException {
    }

    @Override
    public void setAutoCommit(boolean arg0) throws SQLException {
        this.autoCommit = arg0;
    }

    @Override
    public void setCatalog(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setClientInfo(Properties arg0) throws SQLClientInfoException {
        throw new SQLClientInfoException("Method not supported", null);
    }

    @Override
    public void setClientInfo(String arg0, String arg1) throws SQLClientInfoException {
        throw new SQLClientInfoException("Method not supported", null);
    }

    @Override
    public void setHoldability(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setNetworkTimeout(Executor arg0, int arg1) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setReadOnly(boolean arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public Savepoint setSavepoint(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setSchema(String arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setTransactionIsolation(int arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> arg0) throws SQLException {
        throw new SQLException("Method not supported");
    }

    private void openTransport() throws TTransportException {
        this.transport = new TSocket(this.params.getHost(), this.params.getPort(), TsfileJDBCConfig.connectionTimeoutInMs);
        try {
            this.transport.getSocket().setKeepAlive(true);
        }
        catch (SocketException e) {
            System.out.println("Cannot set socket keep alive because: " + e.getMessage());
        }
        if (!this.transport.isOpen()) {
            this.transport.open();
        }
    }

    private void openSession() throws SQLException {
        TSOpenSessionReq openReq = new TSOpenSessionReq(TSProtocolVersion.TSFILE_SERVICE_PROTOCOL_V1);
        openReq.setUsername(this.params.getUsername());
        openReq.setPassword(this.params.getPassword());
        try {
            TSOpenSessionResp openResp = this.client.openSession(openReq);
            Utils.verifySuccess(openResp.getStatus());
            if (!this.supportedProtocols.contains((Object)openResp.getServerProtocolVersion())) {
                throw new TException("Unsupported TsFile protocol");
            }
            this.setProtocol(openResp.getServerProtocolVersion());
            this.sessionHandle = openResp.getSessionHandle();
            if (this.timeZone != null) {
                this.setTimeZone(this.timeZone.getID());
            } else {
                this.timeZone = DateTimeZone.forID((String)this.getTimeZone());
            }
        }
        catch (TException e) {
            throw new SQLException(String.format("Can not establish connection with %s. because %s", this.params.getJdbcUriString(), e.getMessage()));
        }
        this.isClosed = false;
    }

    public boolean reconnect() {
        boolean flag = false;
        for (int i = 1; i <= 3; ++i) {
            try {
                if (this.transport == null) continue;
                this.transport.close();
                this.openTransport();
                this.client = new TSIService.Client((TProtocol)new TBinaryProtocol((TTransport)this.transport));
                this.openSession();
                this.client = TsfileConnection.newSynchronizedClient(this.client);
                flag = true;
                break;
            }
            catch (Exception e) {
                try {
                    Thread.sleep(1000L);
                    continue;
                }
                catch (InterruptedException e1) {
                    e.printStackTrace();
                }
            }
        }
        return flag;
    }

    public void setTimeZone(String tz) throws TException, TsfileSQLException {
        TSSetTimeZoneReq req = new TSSetTimeZoneReq(tz);
        TSSetTimeZoneResp resp = this.client.setTimeZone(req);
        Utils.verifySuccess(resp.getStatus());
        this.timeZone = DateTimeZone.forID((String)tz);
    }

    public String getTimeZone() throws TException, TsfileSQLException {
        if (this.timeZone != null) {
            return this.timeZone.getID();
        }
        TSGetTimeZoneResp resp = this.client.getTimeZone();
        Utils.verifySuccess(resp.getStatus());
        return resp.getTimeZone();
    }

    public static TSIService.Iface newSynchronizedClient(TSIService.Iface client) {
        return (TSIService.Iface)Proxy.newProxyInstance(TsfileConnection.class.getClassLoader(), new Class[]{TSIService.Iface.class}, (InvocationHandler)new SynchronizedHandler(client));
    }

    public TSProtocolVersion getProtocol() {
        return this.protocol;
    }

    public void setProtocol(TSProtocolVersion protocol) {
        this.protocol = protocol;
    }

    private static class SynchronizedHandler
    implements InvocationHandler {
        private final TSIService.Iface client;

        SynchronizedHandler(TSIService.Iface client) {
            this.client = client;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                TSIService.Iface iface = this.client;
                synchronized (iface) {
                    return method.invoke((Object)this.client, args);
                }
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof TException) {
                    throw e.getTargetException();
                }
                throw new TException("Error in calling method " + method.getName(), e.getTargetException());
            }
            catch (Exception e) {
                throw new TException("Error in calling method " + method.getName(), (Throwable)e);
            }
        }
    }
}

