package cn.easyutil.project.service;

import cn.easyutil.project.base.bean.BizBean;
import cn.easyutil.project.base.bean.Page;
import cn.easyutil.project.base.service.BaseService;
import cn.easyutil.project.base.sqlExecuter.SQLExecuter;
import cn.easyutil.util.javaUtil.ObjectUtil;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 公共service基础接口实现
 */
@Component
public abstract class BaseServiceImpl<T extends BizBean> implements BaseService<T> {
	
	/**
	 * 获取mapper对象
	 */
	protected abstract BaseMapper<T> getMainMapper();

	@Override
	public List<T> listPage(SQLExecuter executer) {
		BizBean obj = (BizBean) executer.getBean();
		if (obj.getDeleted() == null) {
			obj.setDeleted(0);
		}
		Page page = ObjectUtil.getAttributeValue(executer.getBean(), "page");
		if(page == null){
			page = new Page();
		}
		//如果页码小于0，认为是全量查询
		if(page.getCurrentPage() < 0){
			return select(executer);
		}
		List<T> result ;
		result = getMainMapper().listPage(executer);
		page = ObjectUtil.getAttributeValue(executer.getBean(), "page");
		if(page == null){
			page = new Page();
		}
		if (result != null && result.size() > 0) {
			ObjectUtil.setAttribute(result.get(0), "page", page);
		}
		return result;
	}

	@Override
	public List<T> listPage(T t) {
		return listPage(new SQLExecuter(t));
	}

	@Override
	public Integer update(SQLExecuter executer) {
		BizBean obj = (BizBean) executer.getBean();
		obj.setUpdateTime(System.currentTimeMillis());
		return getMainMapper().update(executer);
	}

	@Override
	public Integer update(T t) {
		return update(new SQLExecuter(t));
	}

	@Override
	public T add(T t) {
		if (t.getDeleted() == null) {
			t.setDeleted(0);
		}
		if (t.getCreateTime() == null) {
			t.setCreateTime(System.currentTimeMillis());
		}
		getMainMapper().add(t);
		t.setId(t.getId());
		return t;
	}

	@Override
	public T get(SQLExecuter executer) {
		BizBean obj = (BizBean) executer.getBean();
		if (obj.getDeleted() == null) {
			obj.setDeleted(0);
		}
		return getMainMapper().get(executer);
	}

	@Override
	public T get(T t) {
		return get(new SQLExecuter(t));
	}

	@Override
	public T getById(Long id) {
		if (id == null) {
			return null;
		}
		T t = ObjectUtil.createObject(ObjectUtil.getGeneric(this.getClass()));
		t.setId(id);

		return get(t);
	}

	@Override
	public Integer delete(SQLExecuter executer) {
		return getMainMapper().delete(executer);
	}

	@Override
	public Integer deleteById(Long id) {
		if (id == null) {
			return null;
		}
		T t = ObjectUtil.createObject(ObjectUtil.getGeneric(this.getClass()));
		t.setId(id);
		return delete(t);
	}

	@Override
	public Integer delete(T t) {
		return delete(new SQLExecuter(t));
	}

	@Override
	public List<T> select(SQLExecuter executer) {
		BizBean obj = (BizBean) executer.getBean();
		if (obj.getDeleted() == null) {
			obj.setDeleted(0);
		}
		return getMainMapper().select(executer);
	}

	@Override
	public List<T> select(T t) {
		return select(new SQLExecuter(t));
	}

	/**
	 * 是否使用Redis缓存(重写进行修改)
	 */
	protected boolean useRedisCache() {
		return false;
	}

	/**
	 * 是否适用便捷查询
	 * @return
	 */
	protected boolean useEasySqlExecution(){
		return false;
	}

	@Override
	public Integer count(SQLExecuter executer) {
		BizBean obj = (BizBean) executer.getBean();
		if (obj.getDeleted() == null) {
			obj.setDeleted(0);
		}
		return getMainMapper().count(executer);
	}


	@Override
	public Integer count(T t) {
		return count(new SQLExecuter(t).count("1"));
	}

}
