package cn.easyutil.project.service;

import cn.easyutil.project.base.sqlExecuter.SQLExecuter;
import org.apache.ibatis.annotations.*;

import java.util.List;

public interface BaseMapper<T> {

	/**
	 * 分页查询
	 * 
	 * @param executer
	 *            依据T中不为null的属性进行查询
	 * @return 返回页码对应的数据集合
	 */
	@Select("")
	List<T> listPage(SQLExecuter executer);

	/**
	 * 修改数据 (id为null,抛出异常)
	 * 
	 * @param executer
	 *            依据T中id进行修改
	 * @return 修改条数
	 */
	@Update("")
	Integer update(SQLExecuter executer);

	/**
	 * 新增数据 (无参数返回异常)
	 * 
	 * @param t
	 *            依据不为空的字段进新增
	 * @return 返回条数
	 */
	@Insert("")
	@Options(useGeneratedKeys=true,keyProperty="id",keyColumn="id")
	Integer add(T t);

	/**
	 * 依据id查询一条数据
	 * 
	 * @param executer
	 *            依据T中不为空的字段作为条件
	 * @return 返回单条数据
	 */
	@Select("")
	T get(SQLExecuter executer);

	/**
	 * 依据对象属性值删除数据 (无参数返回异常)
	 * 
	 * @param executer
	 *            依据T中不为空的字段进行删除
	 * @return
	 */
	@Delete("")
	Integer delete(SQLExecuter executer);

	/**
	 * 依据对象属性查询所有数据 (无分页，全量查询)
	 * 
	 * @param executer
	 *            依据T中不为null的属性进行查询
	 * @return 数据集合
	 */
	@Select("")
	List<T> select(SQLExecuter executer);

	/**
	 * 获取条数
	 */
	@Select("")
	Integer count(SQLExecuter executer);

}
