/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.handler.extra.InterfaceExtra;
import cn.easyutil.easyapi.handler.operator.provide.InterfaceReaderProvider;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.reflect.Method;

public class InterfaceCreator {
    private Method method;
    private DBModuleInterfaceEntity interfaceBean;
    private InterfaceReaderProvider filter = new InterfaceReaderProvider();
    private InterfaceExtra extra;

    private InterfaceCreator() {
    }

    public static InterfaceCreator builder(Method method) {
        InterfaceCreator creator = new InterfaceCreator();
        creator.method = method;
        return creator;
    }

    public InterfaceCreator setFilter(InterfaceReaderProvider filter) {
        if (filter == null) {
            return this;
        }
        this.filter = filter;
        return this;
    }

    public DBModuleInterfaceEntity buildInterface() {
        if (this.interfaceBean != null) {
            return this.interfaceBean;
        }
        try {
            this.create();
        }
        catch (Exception e) {
            System.out.println("\u521b\u5efa\u63a5\u53e3:" + this.method.toGenericString() + "\u5931\u8d25,\u539f\u56e0:" + e.getMessage());
            e.printStackTrace();
        }
        return this.interfaceBean;
    }

    private void create() {
        this.interfaceBean = new DBModuleInterfaceEntity();
        this.interfaceBean.setShowName(this.filter.name(this.extra, null));
        this.interfaceBean.setShowType(this.filter.show(this.extra, null) != false ? 1 : 0);
        this.interfaceBean.setShowName(this.interfaceBean.getShowName().trim());
        this.interfaceBean.setMethodName(this.method.getName());
        this.interfaceBean.setDescription(this.filter.description(this.extra, null).trim());
        this.interfaceBean.setRequestMethod(this.filter.requestMethod(this.extra, null));
        RenewType renewType = this.filter.renewType(this.extra, null);
        this.interfaceBean.setRenewType(renewType == null ? RenewType.increment.getType() : renewType.getType());
        this.interfaceBean.setBodyType(this.filter.bodyType(this.extra, null).getType());
        this.interfaceBean.setPinyin(StringUtil.toPinYin(this.interfaceBean.getShowName()).trim());
        this.interfaceBean.setSource(this.extra.getMethodComment().getSource());
        this.interfaceBean.setCreateTime(System.currentTimeMillis());
        this.interfaceBean.setUpdateTime(System.currentTimeMillis());
        this.interfaceBean.setInterfaceUnique(StringUtil.toMD5(ProjectContext.currentProjectName + this.filter.unique(this.extra, null)));
        this.interfaceBean.setEnableReqPackage(this.filter.enableReqPackage(this.extra, null) != false ? 1 : 0);
        this.interfaceBean.setEnableResPackage(this.filter.enableResPackage(this.extra, null) != false ? 1 : 0);
        this.interfaceBean.setRequestUrl(this.filter.url(this.extra, null));
    }

    public InterfaceCreator setApiExtra(InterfaceExtra extra) {
        this.extra = extra;
        return this;
    }
}

