/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.content.AuthModuleBean;
import cn.easyutil.easyapi.content.AuthModuleButtonsEnum;
import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserTemporaryAuthEntity;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.interview.dto.BindAuthDto;
import cn.easyutil.easyapi.interview.dto.BindProjectDto;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.dto.LoginDto;
import cn.easyutil.easyapi.interview.dto.SelectUsersDto;
import cn.easyutil.easyapi.interview.dto.UpdatePasswordDto;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.interview.session.SessionUser;
import cn.easyutil.easyapi.interview.vo.UserProjectBean;
import cn.easyutil.easyapi.mybatis.service.ProjectService;
import cn.easyutil.easyapi.mybatis.service.UserService;
import cn.easyutil.easyapi.mybatis.service.UserTemporaryAuthService;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.StringUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnMissingBean(name={"easyapiUserController"})
@RequestMapping(value={"/easyapi/doc/user"})
public class UserController {
    private final UserService userService = new UserService();
    private final UserTemporaryAuthService userTemporaryAuthService = new UserTemporaryAuthService();
    private final ProjectService projectService = new ProjectService();

    @ApidocComment(value="\u767b\u9646\u63a5\u53e3")
    @PostMapping(value={"/login"})
    @AccessAuth(code=1000)
    public DBUserEntity login(@RequestBody LoginDto dto) {
        AssertUtil.isNull((Object)StringUtil.isEmpty(dto.getAccount()), "\u7528\u6237\u540d\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtil.isNull((Object)StringUtil.isEmpty(dto.getPassword()), "\u5bc6\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        DBUserEntity user = this.userService.getByAccount(dto.getAccount());
        AssertUtil.isNull((Object)user, "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        AssertUtil.isTrue(!user.getPassword().equals(StringUtil.toMD5(dto.getPassword())), "\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
        AssertUtil.isTrue(user.getDisable() == 1, "\u60a8\u5df2\u88ab\u7981\u7528");
        SessionUser sessionUser = new SessionUser();
        BeanUtils.copyProperties((Object)user, (Object)sessionUser);
        CurrentSession.loginSuccess(sessionUser);
        if (user.getSuperAdminStatus() == 1) {
            sessionUser.setAuthCodes(Stream.of(AuthModuleButtonsEnum.values()).map(AuthModuleButtonsEnum::getCode).collect(Collectors.toList()));
            user.setCodes(sessionUser.getAuthCodes());
            return user;
        }
        List<String> codes = this.userTemporaryAuthService.list((Wrapper)Wrappers.lambdaQuery(DBUserTemporaryAuthEntity.class).eq(DBUserTemporaryAuthEntity::getUserId, (Object)user.getId())).stream().map(DBUserTemporaryAuthEntity::getAuthCode).collect(Collectors.toList());
        sessionUser.setAuthCodes(codes);
        user.setCodes(codes);
        return user;
    }

    @ApidocComment(value="\u4fee\u6539\u4e2a\u4eba\u5bc6\u7801")
    @PostMapping(value={"/updatePassword"})
    @AccessAuth(code=1000)
    public void updatePassword(@RequestBody UpdatePasswordDto dto) {
        SessionUser user = CurrentSession.getCurrentUser();
        if (user.getSuperAdminStatus() == 1 && !ProjectContext.allConfiguration.getUserConfiguration().isEnableSuperAdminModify()) {
            throw new ApidocException("\u5df2\u914d\u7f6e\u4e0d\u5141\u8bb8\u4fee\u6539\u8d85\u7ba1\u4fe1\u606f");
        }
        AssertUtil.isTrue(!user.getPassword().equals(StringUtil.toMD5(dto.getOldPassword())), "\u65e7\u5bc6\u7801\u8f93\u5165\u4e0d\u6b63\u786e");
        user.setPassword(dto.getNewPassword());
        DBUserEntity userEntity = new DBUserEntity();
        userEntity.setId(user.getId());
        userEntity.setPassword(StringUtil.toMD5(dto.getNewPassword()));
        this.userService.updateById(userEntity);
    }

    @ApidocComment(value="\u6761\u4ef6\u67e5\u8be2\u7528\u6237\u5217\u8868")
    @PostMapping(value={"/selectUsers"})
    @AccessAuth(code=1000)
    public Page<DBUserEntity> selectUsers(@RequestBody SelectUsersDto dto) {
        SessionUser currentUser = CurrentSession.getCurrentUser();
        if (currentUser.getSuperAdminStatus() == 0) {
            Long currentProjectId = CurrentSession.getCurrentProjectId();
            dto.setProjectId(currentProjectId);
        }
        DBUserEntity query = new DBUserEntity();
        BeanUtils.copyProperties((Object)dto, (Object)query);
        query.setHidden(0);
        return (Page)this.userService.page((IPage)new Page((long)dto.getCurrentPage().intValue(), (long)dto.getShowCount().intValue()), (Wrapper)Wrappers.lambdaQuery((Object)query));
    }

    @ApidocComment(value="\u4fee\u6539\u7528\u6237\u4fe1\u606f")
    @PostMapping(value={"/updateUser"})
    @AccessAuth(code=1000)
    public void updateUser(@RequestBody DBUserEntity user) {
        AssertUtil.isNull((Object)user.getId(), "\u8981\u4fee\u6539\u7684\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a");
        DBUserEntity query = (DBUserEntity)this.userService.getById(user.getId());
        AssertUtil.isNull((Object)query, "\u7528\u6237\u4e0d\u5b58\u5728");
        if (!StringUtil.isEmpty(user.getAccount()) && !query.getAccount().equals(user.getAccount())) {
            DBUserEntity byAccount = this.userService.getByAccount(user.getAccount());
            AssertUtil.isTrue(byAccount != null, "\u8d26\u53f7\u5df2\u5b58\u5728");
        }
        if (!StringUtil.isEmpty(user.getPassword()) && !user.getPassword().equals(query.getPassword())) {
            user.setPassword(StringUtil.toMD5(user.getPassword()));
        }
        this.userService.updateById(user);
    }

    @ApidocComment(value="\u5220\u9664\u7528\u6237\u4fe1\u606f")
    @PostMapping(value={"/deleteUser"})
    @AccessAuth(code=1000)
    public void deleteUser(@RequestBody IdDto dto) {
        this.userService.removeById(dto.getId());
    }

    @ApidocComment(value="\u6dfb\u52a0\u7528\u6237")
    @PostMapping(value={"/addUser"})
    @AccessAuth(code=1000)
    public void addUser(@RequestBody DBUserEntity entity) {
        AssertUtil.isNull((Object)StringUtil.isEmpty(entity.getAccount()), "\u8d26\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
        DBUserEntity byAccount = this.userService.getByAccount(entity.getAccount());
        AssertUtil.isTrue(byAccount != null, "\u8d26\u53f7\u5df2\u5b58\u5728");
        entity.setId(null);
        if (StringUtil.isEmpty(entity.getPassword())) {
            entity.setPassword(StringUtil.toMD5("123456"));
        } else {
            entity.setPassword(StringUtil.toMD5(entity.getPassword()));
        }
        if (entity.getProjectId() == null) {
            entity.setProjectId(ProjectContext.currentProjectId);
        }
        this.userService.save(entity);
        this.userTemporaryAuthService.binds(entity, Stream.of(AuthModuleButtonsEnum.values()).filter(item -> item.getDefaultStatus() == 1).map(AuthModuleButtonsEnum::getCode).collect(Collectors.toList()));
    }

    @ApidocComment(value="\u4e3a\u7528\u6237\u7ed1\u5b9a\u6309\u94ae\u6743\u9650")
    @PostMapping(value={"/bindAuth"})
    @AccessAuth(code=1000)
    public void bindAuth(@RequestBody BindAuthDto bind) {
        if (CollectionUtils.isEmpty(bind.getCodes())) {
            return;
        }
        this.userTemporaryAuthService.delByUserId(bind.getUserId());
        DBUserEntity user = (DBUserEntity)this.userService.getById(bind.getUserId());
        this.userTemporaryAuthService.binds(user, bind.getCodes());
    }

    @ApidocComment(value="\u67e5\u770b\u7528\u6237\u7684\u6309\u94ae\u6743\u9650")
    @PostMapping(value={"/getAuthInfo"})
    @AccessAuth(code=1000)
    public List<AuthModuleBean> getAuthInfo(@RequestBody IdDto dto) {
        Set<String> codes = this.userTemporaryAuthService.list((Wrapper)Wrappers.lambdaQuery(DBUserTemporaryAuthEntity.class).eq(DBUserTemporaryAuthEntity::getUserId, (Object)dto.getId())).stream().map(DBUserTemporaryAuthEntity::getAuthCode).collect(Collectors.toSet());
        return AuthModuleButtonsEnum.getModules(codes);
    }

    @ApidocComment(value="\u67e5\u770b\u5168\u90e8\u6743\u9650\u6309\u94ae")
    @PostMapping(value={"/getAllAuth"})
    @AccessAuth(code=1000)
    public List<AuthModuleBean> getAllAuth() {
        return AuthModuleButtonsEnum.getModules(null);
    }

    @ApidocComment(value="\u7ed1\u5b9a\u9879\u76ee")
    @PostMapping(value={"/bindProjects"})
    @AccessAuth(code=1000)
    public void bindProjects(@RequestBody BindProjectDto dto) {
        DBUserEntity user = (DBUserEntity)this.userService.getById(dto.getUserId());
        user.setBindProjectIds(String.join((CharSequence)",", dto.getProjectIds()));
        this.userService.updateById(user);
    }

    @ApidocComment(value="\u83b7\u53d6\u7528\u6237\u7ed1\u5b9a\u7684\u9879\u76ee")
    @PostMapping(value={"/getUserProjects"})
    @AccessAuth(code=1000)
    public List<UserProjectBean> getUserProjects(@RequestBody IdDto dto) {
        List projects = this.projectService.list();
        if (CollectionUtils.isEmpty((Collection)projects)) {
            return null;
        }
        DBUserEntity user = (DBUserEntity)this.userService.getById(dto.getId());
        List<String> bindProjectIds = Arrays.asList(Optional.ofNullable(user.getBindProjectIds()).orElse("").split(","));
        ArrayList<UserProjectBean> result = new ArrayList<UserProjectBean>();
        for (DBProjectEntity project : projects) {
            UserProjectBean upb = new UserProjectBean();
            upb.setProjectName(project.getProjectName());
            upb.setProjectId(project.getId());
            if (bindProjectIds.contains(project.getId().toString())) {
                upb.setChecked(1);
            } else {
                upb.setChecked(0);
            }
            result.add(upb);
        }
        return result;
    }
}

