/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.auth.DBDictEntity;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.entity.db.doc.DBArticleEntity;
import cn.easyutil.easyapi.entity.db.doc.DBInterfaceParamEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleControllerEntity;
import cn.easyutil.easyapi.entity.db.doc.DBModuleInterfaceEntity;
import cn.easyutil.easyapi.entity.db.unit.DBSimpleUnitEntity;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.interview.dto.IdDto;
import cn.easyutil.easyapi.interview.dto.OpenSyncDto;
import cn.easyutil.easyapi.interview.dto.TextDto;
import cn.easyutil.easyapi.interview.entity.ResponseBody;
import cn.easyutil.easyapi.interview.entity.UnifiedAccessDto;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.interview.vo.ControllerExportData;
import cn.easyutil.easyapi.interview.vo.GetProjectsVo;
import cn.easyutil.easyapi.interview.vo.GetSyncInfoVo;
import cn.easyutil.easyapi.interview.vo.InterfaceExportData;
import cn.easyutil.easyapi.interview.vo.ProjectExportData;
import cn.easyutil.easyapi.mybatis.service.ArticleService;
import cn.easyutil.easyapi.mybatis.service.ControllerService;
import cn.easyutil.easyapi.mybatis.service.DictService;
import cn.easyutil.easyapi.mybatis.service.InterfaceParamService;
import cn.easyutil.easyapi.mybatis.service.InterfaceService;
import cn.easyutil.easyapi.mybatis.service.ProjectService;
import cn.easyutil.easyapi.mybatis.service.SimpleUnitService;
import cn.easyutil.easyapi.task.SyncBody;
import cn.easyutil.easyapi.task.SyncTask;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import cn.easyutil.easyapi.util.http.HttpImplEnum;
import cn.easyutil.easyapi.util.http.HttpMethod;
import cn.easyutil.easyapi.util.http.HttpOperation;
import cn.easyutil.easyapi.util.http.HttpRes;
import cn.easyutil.easyapi.util.http.HttpUtilFactory;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@ConditionalOnMissingBean(name={"easyapiProjectController"})
@RequestMapping(value={"/easyapi/doc/project"})
public class ProjectController {
    private final ProjectService projectService = new ProjectService();
    private final ArticleService articleService = new ArticleService();
    private final DictService dictService = new DictService();
    private final ControllerService controllerService = new ControllerService();
    private final InterfaceService interfaceService = new InterfaceService();
    private final InterfaceParamService interfaceParamService = new InterfaceParamService();
    private final SimpleUnitService simpleUnitService = new SimpleUnitService();

    @ApidocComment(value="\u4fee\u6539\u540c\u6b65\u5bc6\u94a5")
    @PostMapping(value={"/updateSecret"})
    @AccessAuth(code=1000)
    public void updateSecret(@RequestBody TextDto dto) {
        AssertUtil.isEmpty(dto.getText(), "\u5bc6\u94a5\u4e0d\u80fd\u4e3a\u7a7a");
        DBDictEntity entity = new DBDictEntity();
        entity.setDictKey(DBDictEntity.syncSecretKey());
        entity = (DBDictEntity)this.dictService.getOne((Wrapper)Wrappers.lambdaQuery((Object)entity), false);
        entity.setDictVal(dto.getText());
        this.dictService.updateById(entity);
        ProjectContext.allConfiguration.getConfiguration().setSyncSecret(dto.getText());
    }

    @ApidocComment(value="\u83b7\u53d6\u540c\u6b65\u4fe1\u606f")
    @PostMapping(value={"/getSyncInfo"})
    @AccessAuth(code=1000)
    public GetSyncInfoVo getSyncInfo() {
        String secret = ProjectContext.allConfiguration.getConfiguration().getSyncSecret();
        DBDictEntity status = this.dictService.getByKey(DBDictEntity.syncStatusKey());
        DBDictEntity interfaces = this.dictService.getByKey(DBDictEntity.syncInterfacesKey());
        DBDictEntity info = this.dictService.getByKey(DBDictEntity.syncInfoKey());
        GetSyncInfoVo vo = new GetSyncInfoVo();
        vo.setSecret(secret);
        vo.setStatus(Integer.parseInt(status.getDictVal()));
        vo.setSize(JsonUtil.jsonToList(interfaces.getDictVal(), Long.class).size());
        vo.setInfo(JsonUtil.jsonToBean(info.getDictVal(), OpenSyncDto.class));
        DBProjectEntity project = new DBProjectEntity();
        project.setDefaultStatus(1);
        project = (DBProjectEntity)this.projectService.getOne((Wrapper)Wrappers.lambdaQuery((Object)project), false);
        vo.setProjectName(project.getProjectName());
        vo.setProjectSecret(project.getAppSecret());
        vo.setProjectUnique(project.getProjectUnique());
        return vo;
    }

    @ApidocComment(value="\u83b7\u53d6\u9879\u76ee\u5217\u8868")
    @PostMapping(value={"/getProjects"})
    @AccessAuth(code=1000)
    public List<GetProjectsVo> getProjects() {
        ArrayList<GetProjectsVo> vos = new ArrayList<GetProjectsVo>();
        List projects = null;
        if (CurrentSession.getCurrentUser().getSuperAdminStatus() != 1) {
            List<String> projectIds = Arrays.asList(Optional.ofNullable(CurrentSession.getCurrentUser().getBindProjectIds()).orElse("").split(","));
            projects = this.projectService.listByIds(projectIds);
        } else {
            projects = this.projectService.list();
        }
        for (DBProjectEntity project : projects) {
            GetProjectsVo vo = new GetProjectsVo();
            BeanUtils.copyProperties((Object)project, (Object)vo);
            Long size = this.interfaceService.count((Wrapper)Wrappers.lambdaQuery(DBModuleInterfaceEntity.class).eq(BaseDbEntity::getProjectId, (Object)project.getId()));
            vo.setInterfaceCount(((Number)size).intValue());
            vos.add(vo);
        }
        return vos;
    }

    @ApidocComment(value="\u4fee\u6539\u9879\u76ee\u4fe1\u606f")
    @PostMapping(value={"/updateProjects"})
    @AccessAuth(code=1000)
    public void updateProjects(@RequestBody DBProjectEntity entity) {
        AssertUtil.isNull((Object)entity.getId(), "\u9879\u76eeid\u4e0d\u80fd\u4e3a\u7a7a");
        if (entity.getDefaultStatus() != null && entity.getDefaultStatus() == 1) {
            DBProjectEntity query = new DBProjectEntity();
            query.setDefaultStatus(entity.getDefaultStatus());
            query = (DBProjectEntity)this.projectService.getOne((Wrapper)Wrappers.lambdaQuery((Object)query));
            AssertUtil.isTrue(query != null, "\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u9879\u76ee");
        }
        entity.setTitle(entity.getProjectName());
        this.projectService.updateById(entity);
    }

    @ApidocComment(value="\u65b0\u589e\u9879\u76ee")
    @PostMapping(value={"/addProject"})
    @AccessAuth(code=1000)
    public void addProject(@RequestBody DBProjectEntity entity) {
        if (entity.getDefaultStatus() != null && entity.getDefaultStatus() == 1) {
            DBProjectEntity query = new DBProjectEntity();
            query.setDefaultStatus(entity.getDefaultStatus());
            query = (DBProjectEntity)this.projectService.getOne((Wrapper)Wrappers.lambdaQuery((Object)query));
            AssertUtil.isTrue(query != null, "\u53ea\u80fd\u6709\u4e00\u4e2a\u9ed8\u8ba4\u9879\u76ee");
        }
        this.projectService.save(entity);
    }

    @ApidocComment(value="\u4fdd\u5b58\u6587\u7ae0\u5217\u8868")
    @PostMapping(value={"/saveArticles"})
    @AccessAuth(code=1000)
    public void saveArticles(@RequestBody List<DBArticleEntity> articles) {
        this.articleService.remove((Wrapper)Wrappers.lambdaQuery(DBArticleEntity.class).ge(BaseDbEntity::getId, (Object)1));
        List<DBArticleEntity> list = JsonUtil.jsonToList(JsonUtil.beanToJson(articles), DBArticleEntity.class);
        this.articleService.saveBatch(list);
    }

    @ApidocComment(value="\u5220\u9664\u9879\u76ee")
    @PostMapping(value={"/delProject"})
    @AccessAuth(code=1000)
    public void delProject(@RequestBody IdDto dto) {
        this.projectService.removeById(dto.getId());
        this.controllerService.remove((Wrapper)Wrappers.lambdaQuery(DBModuleControllerEntity.class).eq(BaseDbEntity::getProjectId, (Object)ProjectContext.currentProjectId));
        this.interfaceService.remove((Wrapper)Wrappers.lambdaQuery(DBModuleInterfaceEntity.class).eq(BaseDbEntity::getProjectId, (Object)ProjectContext.currentProjectId));
        this.interfaceParamService.remove((Wrapper)Wrappers.lambdaQuery(DBInterfaceParamEntity.class).eq(BaseDbEntity::getProjectId, (Object)ProjectContext.currentProjectId));
        this.simpleUnitService.remove((Wrapper)Wrappers.lambdaQuery(DBSimpleUnitEntity.class).eq(BaseDbEntity::getProjectId, (Object)ProjectContext.currentProjectId));
    }

    @ApidocComment(value="\u83b7\u53d6\u9ed8\u8ba4\u9879\u76ee\u4fe1\u606f")
    @PostMapping(value={"/getInfo"})
    @AccessAuth(code=1000)
    public DBProjectEntity getInfo() {
        return (DBProjectEntity)this.projectService.getOne((Wrapper)Wrappers.lambdaQuery(DBProjectEntity.class).eq(DBProjectEntity::getDefaultStatus, (Object)1));
    }

    @ApidocComment(value="\u5bfc\u5165\u9879\u76ee\u4fe1\u606f")
    @PostMapping(value={"/importProject"})
    @AccessAuth(code=1000)
    public void importProject(@RequestBody ProjectExportData data) {
        if (data == null) {
            return;
        }
        DBProjectEntity project = data.getProject();
        if (project == null) {
            throw new ApidocException("\u7f3a\u5c11\u9879\u76ee\u540d\u79f0\u6216\u6807\u8bc6");
        }
        if (StringUtil.isEmpty(project.getProjectName()) || StringUtil.isEmpty(project.getProjectUnique())) {
            throw new ApidocException("\u7f3a\u5c11\u9879\u76ee\u540d\u79f0\u6216\u6807\u8bc6");
        }
        DBProjectEntity query = (DBProjectEntity)this.projectService.getOne((Wrapper)Wrappers.lambdaQuery(DBProjectEntity.class).eq(DBProjectEntity::getProjectUnique, (Object)project.getProjectUnique()), false);
        if (query != null) {
            project = query;
        } else {
            project.setId(null);
            project.setProjectId(null);
            this.projectService.save(project);
        }
        List<ControllerExportData> controllers = data.getControllers();
        if (CollectionUtils.isEmpty(controllers)) {
            return;
        }
        for (ControllerExportData controller : controllers) {
            DBModuleControllerEntity c = controller.getController();
            if (c == null || StringUtil.isEmpty(c.getClassName())) continue;
            DBModuleControllerEntity queryController = (DBModuleControllerEntity)this.controllerService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DBModuleControllerEntity.class).eq(BaseDbEntity::getProjectId, (Object)project.getId())).eq(DBModuleControllerEntity::getClassName, (Object)c.getClassName()));
            if (queryController == null) {
                c.setProjectId(project.getId());
                c.setId(null);
                this.controllerService.save(c);
            } else {
                c = queryController;
            }
            List<InterfaceExportData> interfaces = controller.getInterfaces();
            if (CollectionUtils.isEmpty(interfaces)) continue;
            for (InterfaceExportData anInterface : interfaces) {
                DBSimpleUnitEntity unit;
                DBModuleInterfaceEntity queryInterface;
                DBModuleInterfaceEntity interfaceBean = anInterface.getInterfaceBean();
                if (interfaceBean == null || StringUtil.isEmpty(interfaceBean.getInterfaceUnique()) || (queryInterface = (DBModuleInterfaceEntity)this.interfaceService.getOne((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DBModuleInterfaceEntity.class).eq(DBModuleInterfaceEntity::getControllerId, (Object)c.getId())).eq(DBModuleInterfaceEntity::getInterfaceUnique, (Object)interfaceBean.getInterfaceUnique()))) != null) continue;
                interfaceBean.setControllerId(c.getId());
                interfaceBean.setId(null);
                interfaceBean.setProjectId(project.getId());
                this.interfaceService.save(interfaceBean);
                DBInterfaceParamEntity param = anInterface.getRequestParam();
                if (param != null) {
                    param.setId(null);
                    param.setProjectId(project.getId());
                    param.setInterfaceId(interfaceBean.getId());
                    this.interfaceParamService.save(param);
                }
                if ((unit = anInterface.getUnit()) == null) continue;
                unit.setId(null);
                unit.setInterfaceUnique(interfaceBean.getInterfaceUnique());
                unit.setProjectId(project.getId());
                this.simpleUnitService.save(unit);
            }
        }
    }

    @ApidocComment(value="\u83b7\u53d6\u9879\u76ee\u5bfc\u51fa\u6570\u636e")
    @PostMapping(value={"/getProjectExportData"})
    @AccessAuth(code=0)
    public ProjectExportData getProjectExportData(@RequestBody IdDto dto) {
        DBProjectEntity project = (DBProjectEntity)this.projectService.getById(dto.getId());
        if (project == null) {
            return null;
        }
        ProjectExportData result = new ProjectExportData();
        result.setProject(project);
        List controllers = this.controllerService.list((Wrapper)Wrappers.lambdaQuery(DBModuleControllerEntity.class).eq(BaseDbEntity::getProjectId, (Object)dto.getId()));
        if (CollectionUtils.isEmpty((Collection)controllers)) {
            return result;
        }
        ArrayList<ControllerExportData> controllerData = new ArrayList<ControllerExportData>();
        result.setControllers(controllerData);
        for (DBModuleControllerEntity controller : controllers) {
            ControllerExportData data = new ControllerExportData();
            data.setController(controller);
            controllerData.add(data);
            List interfaceEntities = this.interfaceService.list((Wrapper)Wrappers.lambdaQuery(DBModuleInterfaceEntity.class).eq(DBModuleInterfaceEntity::getControllerId, (Object)controller.getId()));
            if (CollectionUtils.isEmpty((Collection)interfaceEntities)) continue;
            Map params = this.interfaceParamService.list((Wrapper)Wrappers.lambdaQuery(DBInterfaceParamEntity.class).in(DBInterfaceParamEntity::getInterfaceId, (Collection)interfaceEntities.stream().map(BaseDbEntity::getId).collect(Collectors.toList()))).stream().collect(Collectors.toMap(DBInterfaceParamEntity::getInterfaceId, Function.identity()));
            Map units = this.simpleUnitService.list((Wrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery(DBSimpleUnitEntity.class).in(DBSimpleUnitEntity::getInterfaceUnique, (Collection)interfaceEntities.stream().map(DBModuleInterfaceEntity::getInterfaceUnique).collect(Collectors.toList()))).eq(DBSimpleUnitEntity::getType, (Object)0)).stream().collect(Collectors.toMap(DBSimpleUnitEntity::getInterfaceUnique, Function.identity()));
            ArrayList<InterfaceExportData> interfaces = new ArrayList<InterfaceExportData>();
            for (DBModuleInterfaceEntity interfaceEntity : interfaceEntities) {
                InterfaceExportData bean = new InterfaceExportData();
                bean.setInterfaceBean(interfaceEntity);
                bean.setRequestParam((DBInterfaceParamEntity)params.get(interfaceEntity.getId()));
                bean.setUnit((DBSimpleUnitEntity)units.get(interfaceEntity.getInterfaceUnique()));
                interfaces.add(bean);
            }
            data.setInterfaces(interfaces);
        }
        return result;
    }

    @ApidocComment(value="\u6d4b\u8bd5\u662f\u5426\u53ef\u4ee5\u8fdb\u884c\u540c\u6b65")
    @PostMapping(value={"/syncTest"})
    @AccessAuth(code=0)
    public void syncTest(OpenSyncDto dto) {
        AssertUtil.isEmpty(dto.getSecret(), "\u7f3a\u5c11\u5bc6\u94a5\u4fe1\u606f");
        AssertUtil.isEmpty(dto.getProjectUnique(), "\u7f3a\u5c11\u9879\u76ee\u6807\u8bc6");
        AssertUtil.isEmpty(dto.getProjectName(), "\u7f3a\u5c11\u9879\u76ee\u540d\u79f0");
        AssertUtil.isTrue(!dto.getSecret().equals(ProjectContext.allConfiguration.getConfiguration().getSyncSecret()), "\u5bc6\u94a5\u9519\u8bef");
    }

    @ApidocComment(value="\u5f00\u542f\u6587\u6863\u540c\u6b65")
    @PostMapping(value={"/openSync"})
    @AccessAuth(code=1000)
    public void openSync(@RequestBody OpenSyncDto dto) {
        AssertUtil.isEmpty(dto.getSecret(), "\u7f3a\u5c11\u5bc6\u94a5\u4fe1\u606f");
        AssertUtil.isEmpty(dto.getAddress(), "\u7f3a\u5c11\u76ee\u6807\u670d\u52a1\u5668\u5730\u5740");
        UnifiedAccessDto uDto = new UnifiedAccessDto();
        uDto.setApi("project::syncTest");
        uDto.setBody(JsonUtil.beanToJson(dto));
        HttpOperation operation = HttpUtilFactory.create(HttpImplEnum.httpClient);
        operation.getHttpReq().setUrl(dto.getAddress() + "/easyapi/doc/unified/post");
        operation.parameter(JsonUtil.beanToJson(uDto));
        operation.method(HttpMethod.POST);
        HttpRes httpRes = operation.doUrl();
        if (!httpRes.getResponseCode().equals(200) || StringUtil.isEmpty(httpRes.getResponseMsg())) {
            throw new ApidocException("\u76ee\u6807\u670d\u52a1\u5668\u8fde\u63a5\u5f02\u5e38");
        }
        ResponseBody body = JsonUtil.jsonToBean(httpRes.getResponseMsg(), ResponseBody.class);
        if (!body.getCode().equals(200)) {
            throw new ApidocException(body.getRemark());
        }
        DBProjectEntity project = (DBProjectEntity)this.projectService.getOne((Wrapper)Wrappers.lambdaQuery(DBProjectEntity.class).eq(DBProjectEntity::getDefaultStatus, (Object)1));
        Long size = this.interfaceService.count((Wrapper)Wrappers.lambdaQuery(DBModuleInterfaceEntity.class).eq(BaseDbEntity::getProjectId, (Object)project.getId()));
        dto.setTotalCount(((Number)size).intValue());
        dto.setAddress(dto.getAddress());
        this.dictService.updateByKey(DBDictEntity.syncStatusKey(), "1");
        this.dictService.updateByKey(DBDictEntity.syncInterfacesKey(), "[]");
        this.dictService.updateByKey(DBDictEntity.syncInfoKey(), JsonUtil.beanToJson(dto));
        SyncTask.start();
    }

    @ApidocComment(value="\u63a5\u6536\u8fdc\u7a0b\u6765\u7684\u540c\u6b65")
    @PostMapping(value={"/receiveSync"})
    @AccessAuth(code=0)
    public void receiveSync(@RequestBody SyncBody body) {
        DBModuleControllerEntity controller = body.getController();
        DBModuleInterfaceEntity interfaces = body.getInterfaces();
        DBInterfaceParamEntity params = body.getParams();
        String secret = body.getSecret();
        String unique = body.getUnique();
        String name = body.getName();
        AssertUtil.isTrue(!secret.equals(ProjectContext.allConfiguration.getConfiguration().getSyncSecret()), "\u5bc6\u94a5\u9519\u8bef");
        List projects = this.projectService.list();
        DBProjectEntity project = null;
        for (DBProjectEntity p : projects) {
            if (!p.getProjectUnique().equals(unique)) continue;
            project = p;
            break;
        }
        if (project == null) {
            project = new DBProjectEntity();
            project.setProjectUnique(unique);
            project.setProjectName(name);
            project.setTitle(name);
            this.projectService.save(project);
        }
        DBModuleControllerEntity queryController = new DBModuleControllerEntity();
        queryController.setProjectId(project.getId());
        queryController.setClassName(controller.getClassName());
        queryController = (DBModuleControllerEntity)this.controllerService.getOne((Wrapper)Wrappers.lambdaQuery((Object)queryController));
        if (queryController == null) {
            queryController = new DBModuleControllerEntity();
            BeanUtils.copyProperties((Object)controller, (Object)queryController);
            queryController.setId(null);
            queryController.setProjectId(project.getId());
            this.controllerService.save(queryController);
        }
        DBModuleInterfaceEntity queryInterfaceEntity = new DBModuleInterfaceEntity();
        queryInterfaceEntity.setProjectId(project.getId());
        queryInterfaceEntity.setControllerId(queryController.getId());
        queryInterfaceEntity.setInterfaceUnique(interfaces.getInterfaceUnique());
        queryInterfaceEntity = (DBModuleInterfaceEntity)this.interfaceService.getOne((Wrapper)Wrappers.lambdaQuery((Object)queryInterfaceEntity));
        if (queryInterfaceEntity == null) {
            queryInterfaceEntity = new DBModuleInterfaceEntity();
            BeanUtils.copyProperties((Object)interfaces, (Object)queryInterfaceEntity);
            queryInterfaceEntity.setId(null);
            queryInterfaceEntity.setProjectId(project.getId());
            queryInterfaceEntity.setControllerId(queryController.getId());
            this.interfaceService.save(queryInterfaceEntity);
            params.setId(null);
            params.setInterfaceId(queryInterfaceEntity.getId());
            this.interfaceParamService.save(params);
        }
    }
}

