/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.handler.reader.beans.model;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ModelFieldExtra;
import cn.easyutil.easyapi.javadoc.reader.FieldComment;
import cn.easyutil.easyapi.logic.creator.CreatorCommonMethod;
import cn.easyutil.easyapi.util.ApidocCommentUtil;
import cn.easyutil.easyapi.util.StringUtil;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.List;
import org.springframework.util.CollectionUtils;

public class BeanConditionCommentReader
extends HandlerChain<ModelFieldExtra, List<String>> {
    @Override
    public List<String> resolve(ModelFieldExtra extra, List<String> transfer) {
        if (transfer != null) {
            return this.nextHandler().resolve(extra, transfer);
        }
        Annotation[] annotations = extra.getField().getAnnotations();
        List<String> conditions = CreatorCommonMethod.readConditons(annotations);
        if (!CollectionUtils.isEmpty(conditions)) {
            return this.nextHandler().resolve(extra, conditions);
        }
        FieldComment fieldComment = extra.getFieldComment();
        if (StringUtil.isEmpty(fieldComment.getComment())) {
            return this.nextHandler().resolve(extra, transfer);
        }
        String comment = fieldComment.getComment();
        String conditionsComment = ApidocCommentUtil.getCommentValue(comment, "conditions");
        if (StringUtil.isEmpty(conditionsComment) || !conditionsComment.startsWith("[") || !conditionsComment.endsWith("]")) {
            return this.nextHandler().resolve(extra, null);
        }
        return this.nextHandler().resolve(extra, Arrays.asList(conditionsComment.substring(1, conditionsComment.length() - 1).split(",")));
    }
}

