/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.entity.annotation.DDL;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.common.EasyapiOrigin;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import cn.easyutil.easyapi.util.EasyapiOriginUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import java.sql.Blob;
import org.apache.commons.codec.Charsets;
import org.apache.ibatis.type.JdbcType;
import org.springframework.web.bind.annotation.RequestMethod;

@TableName(value="EASYAPI_MODULE_INTERFACE")
public class DBModuleInterfaceEntity
extends BaseDbEntity {
    @DDL(value="MODULE_ID", ddl="`MODULE_ID` bigint(20) DEFAULT NULL COMMENT '\u6a21\u5757id'")
    @ApidocComment(value="\u6a21\u5757id")
    private Long moduleId;
    @DDL(value="CONTROLLER_ID", ddl="`CONTROLLER_ID` bigint(20) DEFAULT NULL COMMENT '\u63a7\u5236\u5668id'")
    @ApidocComment(value="\u63a7\u5236\u5668id")
    private Long controllerId;
    @DDL(value="AUTHOR", ddl="`AUTHOR` varchar(255) DEFAULT NULL COMMENT '\u4f5c\u8005'")
    @ApidocComment(value="\u4f5c\u8005")
    @EasyapiOrigin
    private String author;
    @DDL(value="SHOW_TYPE", ddl="`SHOW_TYPE` int(1) DEFAULT 1 COMMENT '\u662f\u5426\u5c55\u793a 0-\u5426  1-\u662f'")
    @ApidocComment(value="\u662f\u5426\u5c55\u793a 0-\u5426  1-\u662f")
    @EasyapiOrigin
    private Integer showType;
    @DDL(value="CONTROLLER_CLASS", ddl="`CONTROLLER_CLASS` varchar(255) DEFAULT NULL COMMENT '\u63a7\u5236\u5668\u540d\u79f0'")
    @ApidocComment(value="\u63a7\u5236\u5668\u540d\u79f0")
    private String controllerClass;
    @DDL(value="METHOD_NAME", ddl="`METHOD_NAME` varchar(255) DEFAULT NULL COMMENT '\u63a5\u53e3\u65b9\u6cd5\u540d'")
    @ApidocComment(value="\u63a5\u53e3\u65b9\u6cd5\u540d")
    private String methodName;
    @DDL(value="INTERFACE_UNIQUE", ddl="`INTERFACE_UNIQUE` varchar(255) DEFAULT NULL COMMENT '\u63a5\u53e3\u552f\u4e00\u6807\u8bc6'")
    @ApidocComment(value="\u63a5\u53e3\u552f\u4e00\u6807\u8bc6")
    @EasyapiOrigin
    private String interfaceUnique;
    @DDL(value="UPGRADE_STATUS", ddl="`UPGRADE_STATUS` int(1) DEFAULT 0 COMMENT '\u63a5\u53e3\u7248\u672c  0-\u6700\u65b0\u7248\u672c 1-\u5f85\u66f4\u65b0'")
    @ApidocComment(value="\u63a5\u53e3\u7248\u672c  0-\u6700\u65b0\u7248\u672c 1-\u5f85\u66f4\u65b0")
    private Integer upgradeStatus;
    @DDL(value="RENEW_TYPE", ddl="`RENEW_TYPE` int(1) DEFAULT 0 COMMENT '\u66f4\u65b0\u7b56\u7565: 0-\u8986\u76d6\u66f4\u65b0  1-\u589e\u91cf\u66f4\u65b0  2-\u8df3\u8fc7\u66f4\u65b0'")
    @ApidocComment(value="\u66f4\u65b0\u7b56\u7565: 0-\u8986\u76d6\u66f4\u65b0  1-\u589e\u91cf\u66f4\u65b0  2-\u8df3\u8fc7\u66f4\u65b0")
    private Integer renewType;
    @DDL(value="SHOW_NAME", ddl="`SHOW_NAME` varchar(255) DEFAULT NULL COMMENT '\u63a5\u53e3\u6807\u9898'")
    @ApidocComment(value="\u63a5\u53e3\u6807\u9898")
    @EasyapiOrigin
    private String showName;
    @DDL(value="PINYIN", ddl="`PINYIN` varchar(255) DEFAULT NULL COMMENT '\u63a5\u53e3\u6807\u9898\u62fc\u97f3'")
    @ApidocComment(value="\u63a5\u53e3\u6807\u9898\u62fc\u97f3")
    private String pinyin;
    @DDL(value="DESCRIPTION", ddl="`DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '\u63a5\u53e3\u8bf4\u660e'")
    @ApidocComment(value="\u63a5\u53e3\u8bf4\u660e")
    @EasyapiOrigin
    private String description;
    @DDL(value="REQUEST_URL", ddl="`REQUEST_URL` varchar(255) DEFAULT NULL COMMENT '\u8bf7\u6c42\u5730\u5740'")
    @ApidocComment(value="\u8bf7\u6c42\u5730\u5740")
    @EasyapiOrigin
    private String requestUrl;
    @DDL(value="REQUEST_METHOD", ddl="`REQUEST_METHOD` int(1) DEFAULT 0 COMMENT '\u8bf7\u6c42\u65b9\u5f0f 0-\u5168\u90e8  1-get  2-post'")
    @ApidocComment(value="\u8bf7\u6c42\u65b9\u5f0f 0-\u5168\u90e8  1-get  2-post ")
    @EasyapiOrigin
    private Integer requestMethod;
    @DDL(value="BODY_TYPE", ddl="`BODY_TYPE` int(1) DEFAULT 0 COMMENT '\u8bf7\u6c42\u4f53\u7c7b\u578b 0-form  1-json\u4f53  2-\u6587\u4ef6\u4e0a\u4f20 3-XML 4-RAW'")
    @ApidocComment(value="\u8bf7\u6c42\u4f53\u7c7b\u578b 0-form  1-json\u4f53  2-\u6587\u4ef6\u4e0a\u4f20 3-XML 4-RAW")
    @EasyapiOrigin
    private Integer bodyType;
    @DDL(value="SORT", ddl="`SORT` int(5) DEFAULT 0 COMMENT '\u6392\u5e8f\u503c'")
    @ApidocComment(value="\u6392\u5e8f\u503c")
    private Integer sort = 0;
    @TableField(exist=false)
    private String source;
    @DDL(value="SOURCE_BYTES", type=Blob.class, ddl="`SOURCE_BYTES` BLOB DEFAULT NULL COMMENT '\u6e90\u4ee3\u7801'")
    @ApidocComment(value="\u6e90\u4ee3\u7801")
    @TableField(jdbcType=JdbcType.BLOB)
    private byte[] sourceBytes;
    @DDL(value="SEARCH_TAGS", ddl="`SEARCH_TAGS` varchar(255) DEFAULT NULL COMMENT '\u641c\u7d22\u5b57\u6bb5'")
    @ApidocComment(value="\u641c\u7d22\u5b57\u6bb5")
    private String searchTags;
    @DDL(value="CUSTOM_TAGS", ddl="`CUSTOM_TAGS` varchar(255) DEFAULT NULL COMMENT '\u5feb\u641c\u6807\u7b7e'")
    @ApidocComment(value="\u5feb\u641c\u6807\u7b7e")
    @EasyapiOrigin
    private String customTags;
    @DDL(value="ENABLE_REQ_PACKAGE", ddl="`ENABLE_REQ_PACKAGE` int(1) DEFAULT 0 COMMENT '\u662f\u5426\u5f00\u542f\u8bf7\u6c42\u53c2\u6570\u5916\u5305\u88c5 0-\u4e0d\u662f  1-\u662f'")
    @ApidocComment(value="\u662f\u5426\u5f00\u542f\u8bf7\u6c42\u53c2\u6570\u5916\u5305\u88c5 0-\u4e0d\u662f  1-\u662f")
    @EasyapiOrigin
    private Integer enableReqPackage;
    @DDL(value="ENABLE_RES_PACKAGE", ddl="`ENABLE_RES_PACKAGE` int(1) DEFAULT 0 COMMENT '\u662f\u5426\u5f00\u542f\u8fd4\u56de\u53c2\u6570\u5916\u5305\u88c5 0-\u4e0d\u662f  1-\u662f'")
    @ApidocComment(value="\u662f\u5426\u5f00\u542f\u8fd4\u56de\u53c2\u6570\u5916\u5305\u88c5 0-\u4e0d\u662f  1-\u662f")
    @EasyapiOrigin
    private Integer enableResPackage;
    @TableField(exist=false)
    private String origin;
    @DDL(value="ORIGIN_BYTES", type=Blob.class, ddl="`ORIGIN_BYTES` BLOB DEFAULT NULL COMMENT '\u539f\u59cb\u6570\u636e\uff0c\u7528\u6765\u5224\u65ad\u662f\u5426\u88ab\u6539\u53d8\u7684'")
    @ApidocComment(value="\u539f\u59cb\u6570\u636e\uff0c\u7528\u6765\u5224\u65ad\u662f\u5426\u88ab\u6539\u53d8\u7684")
    @TableField(jdbcType=JdbcType.BLOB)
    private byte[] originBytes;

    public void createOrigin() {
        String origin = EasyapiOriginUtil.createOrigin(this);
        this.setOrigin(origin);
    }

    public void mergin(DBModuleInterfaceEntity entity) {
        String originStr = entity.getOrigin();
        if (StringUtil.isEmpty(originStr)) {
            return;
        }
        DBModuleInterfaceEntity origin = JsonUtil.jsonToBean(originStr, DBModuleInterfaceEntity.class);
        EasyapiOriginUtil.mergin(this, entity, origin);
        origin.createOrigin();
        entity.setOrigin(origin.getOrigin());
    }

    public static String buildSearchTag(DBModuleInterfaceEntity entity) {
        if (entity == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isEmpty(entity.getMethodName())) {
            sb.append(entity.getMethodName());
        }
        if (!StringUtil.isEmpty(entity.getShowName())) {
            sb.append(entity.getShowName());
        }
        if (!StringUtil.isEmpty(entity.getRequestUrl())) {
            sb.append(entity.getRequestUrl());
        }
        if (!StringUtil.isEmpty(entity.getPinyin())) {
            sb.append(entity.getPinyin());
        }
        if (sb.length() > 150) {
            return sb.substring(0, 150);
        }
        return sb.toString();
    }

    public String getRequestMethodString() {
        if (this.requestMethod == null) {
            return "GET";
        }
        switch (this.requestMethod) {
            case 1: {
                return "GET";
            }
            case 2: {
                return "POST";
            }
            case 3: {
                return "PUT";
            }
            case 4: {
                return "DELETE";
            }
            case 5: {
                return "HEAD";
            }
            case 6: {
                return "PATCH";
            }
            case 7: {
                return "TRACE";
            }
            case 8: {
                return "OPTIONS";
            }
        }
        return "GET";
    }

    public void setRequestMethod(RequestMethod requestMethod) {
        switch (requestMethod) {
            case GET: {
                this.requestMethod = 1;
                break;
            }
            case DELETE: {
                this.requestMethod = 4;
                break;
            }
            case PUT: {
                this.requestMethod = 3;
                break;
            }
            case POST: {
                this.requestMethod = 2;
                break;
            }
            case HEAD: {
                this.requestMethod = 5;
                break;
            }
            case PATCH: {
                this.requestMethod = 6;
                break;
            }
            case TRACE: {
                this.requestMethod = 7;
                break;
            }
            case OPTIONS: {
                this.requestMethod = 8;
            }
        }
    }

    public Long getModuleId() {
        return this.moduleId;
    }

    public void setModuleId(Long moduleId) {
        this.moduleId = moduleId;
    }

    public Long getControllerId() {
        return this.controllerId;
    }

    public void setControllerId(Long controllerId) {
        this.controllerId = controllerId;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public void setMethodName(String methodName) {
        this.methodName = methodName;
    }

    public String getShowName() {
        return this.showName;
    }

    public void setShowName(String showName) {
        if (!StringUtil.isEmpty(showName) && showName.length() > 150) {
            showName = showName.substring(0, 150);
        }
        this.showName = showName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        if (!StringUtil.isEmpty(description) && description.length() > 200) {
            description = description.substring(0, 200);
        }
        this.description = description;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public Integer getRequestMethod() {
        return this.requestMethod;
    }

    public void setRequestMethod(Integer requestMethod) {
        this.requestMethod = requestMethod;
    }

    public Integer getBodyType() {
        return this.bodyType;
    }

    public void setBodyType(Integer bodyType) {
        this.bodyType = bodyType;
    }

    public Integer getSort() {
        return this.sort;
    }

    public void setSort(Integer sort) {
        this.sort = sort;
    }

    public String getPinyin() {
        return this.pinyin;
    }

    public void setPinyin(String pinyin) {
        if (!StringUtil.isEmpty(pinyin) && pinyin.length() > 150) {
            pinyin = pinyin.substring(0, 150);
        }
        this.pinyin = pinyin;
    }

    public String getSearchTags() {
        return this.searchTags;
    }

    public void setSearchTags(String searchTags) {
        if (!StringUtil.isEmpty(searchTags) && searchTags.length() > 150) {
            searchTags = searchTags.substring(0, 150);
        }
        this.searchTags = searchTags;
    }

    public String getControllerClass() {
        return this.controllerClass;
    }

    public void setControllerClass(String controllerClass) {
        this.controllerClass = controllerClass;
    }

    public String getInterfaceUnique() {
        return this.interfaceUnique;
    }

    public void setInterfaceUnique(String interfaceUnique) {
        this.interfaceUnique = interfaceUnique;
    }

    public Integer getUpgradeStatus() {
        return this.upgradeStatus;
    }

    public void setUpgradeStatus(Integer upgradeStatus) {
        this.upgradeStatus = upgradeStatus;
    }

    public Integer getEnableReqPackage() {
        return this.enableReqPackage;
    }

    public void setEnableReqPackage(Integer enableReqPackage) {
        this.enableReqPackage = enableReqPackage;
    }

    public Integer getEnableResPackage() {
        return this.enableResPackage;
    }

    public void setEnableResPackage(Integer enableResPackage) {
        this.enableResPackage = enableResPackage;
    }

    public String getCustomTags() {
        return this.customTags;
    }

    public void setCustomTags(String customTags) {
        if (!StringUtil.isEmpty(customTags) && customTags.length() > 150) {
            customTags = customTags.substring(0, 150);
        }
        this.customTags = customTags;
    }

    public Integer getShowType() {
        return this.showType;
    }

    public void setShowType(Integer showType) {
        this.showType = showType;
    }

    public String getAuthor() {
        return this.author;
    }

    public void setAuthor(String author) {
        if (!StringUtil.isEmpty(author) && author.length() > 30) {
            author = author.substring(0, 30);
        }
        this.author = author;
    }

    public Integer getRenewType() {
        return this.renewType;
    }

    public void setRenewType(Integer renewType) {
        this.renewType = renewType;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
        this.sourceBytes = StringUtil.isEmpty(source) ? null : source.getBytes(Charsets.UTF_8);
    }

    public byte[] getSourceBytes() {
        return this.sourceBytes;
    }

    public void setSourceBytes(byte[] sourceBytes) {
        this.sourceBytes = sourceBytes;
        this.source = sourceBytes == null ? null : new String(sourceBytes, Charsets.UTF_8);
    }

    public String getOrigin() {
        return this.origin;
    }

    public void setOrigin(String origin) {
        this.origin = origin;
        this.originBytes = StringUtil.isEmpty(origin) ? null : origin.getBytes(Charsets.UTF_8);
    }

    public byte[] getOriginBytes() {
        return this.originBytes;
    }

    public void setOriginBytes(byte[] originBytes) {
        this.originBytes = originBytes;
        this.origin = originBytes == null ? null : new String(originBytes, Charsets.UTF_8);
    }
}

