/*
 * Decompiled with CFR 0.152.
 */
package cn.easyutil.easyapi.configuration;

import cn.easyutil.easyapi.util.StringUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="easyapi")
public class EasyApiBaseConfiguration {
    private boolean enable = false;
    private boolean rescan = true;
    private boolean showSql = false;
    private boolean showStartLog = false;
    private boolean showBanner = true;
    private boolean renewDoc = true;
    private boolean dropDoc = false;
    private boolean dropUsers = false;
    private boolean dropGlobalSetting = false;
    private boolean dropAll = false;
    private String syncSecret;
    private String unique;
    private String projectName;
    private Set<String> projectSourcePaths = new HashSet<String>();
    private Set<String> scanPackages = new HashSet<String>(Collections.singletonList("**/**"));
    private int mockArraySize = 12;

    public boolean isEnable() {
        return this.enable;
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public boolean isRescan() {
        return this.rescan;
    }

    public void setRescan(boolean rescan) {
        this.rescan = rescan;
    }

    public boolean isDropDoc() {
        return this.dropDoc;
    }

    public void setDropDoc(boolean dropDoc) {
        this.dropDoc = dropDoc;
    }

    public boolean isDropAll() {
        return this.dropAll;
    }

    public boolean isDropUsers() {
        return this.dropUsers;
    }

    public void setDropUsers(boolean dropUsers) {
        this.dropUsers = dropUsers;
    }

    public boolean isDropGlobalSetting() {
        return this.dropGlobalSetting;
    }

    public void setDropGlobalSetting(boolean dropGlobalSetting) {
        this.dropGlobalSetting = dropGlobalSetting;
    }

    public Set<String> getProjectSourcePaths() {
        return this.projectSourcePaths;
    }

    public void setProjectSourcePaths(Set<String> projectSourcePaths) {
        this.projectSourcePaths = projectSourcePaths;
    }

    public boolean isRenewDoc() {
        return this.renewDoc;
    }

    public void setRenewDoc(boolean renewDoc) {
        this.renewDoc = renewDoc;
    }

    public void setDropAll(boolean dropAll) {
        this.dropAll = dropAll;
    }

    public Set<String> getScanPackages() {
        return this.scanPackages;
    }

    public void setScanPackages(Set<String> scanPackages) {
        this.scanPackages = scanPackages;
    }

    public int getMockArraySize() {
        return this.mockArraySize;
    }

    public void setMockArraySize(int mockArraySize) {
        this.mockArraySize = mockArraySize;
    }

    public String getSyncSecret() {
        if (StringUtil.isEmpty(this.syncSecret)) {
            this.syncSecret = this.getUnique();
        }
        return this.syncSecret;
    }

    public void setSyncSecret(String syncSecret) {
        this.syncSecret = syncSecret;
    }

    public String getUnique() {
        StackTraceElement[] stackTrace;
        if (!StringUtil.isEmpty(this.unique)) {
            return this.unique;
        }
        this.setUnique(UUID.randomUUID().toString().replace("-", "").substring(0, 16));
        for (StackTraceElement stackTraceElement : stackTrace = new RuntimeException().getStackTrace()) {
            if (!"main".equals(stackTraceElement.getMethodName())) continue;
            this.setUnique(StringUtil.toMD5(stackTraceElement.getClassName()).substring(0, 16));
            break;
        }
        return this.unique;
    }

    public void setUnique(String unique) {
        this.unique = unique;
    }

    public String getProjectName() {
        if (!StringUtil.isEmpty(this.projectName)) {
            return this.projectName;
        }
        return System.getProperty("user.dir").substring(System.getProperty("user.dir").lastIndexOf(File.separator) + 1);
    }

    @Value(value="${spring.application.name:}")
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public boolean isShowSql() {
        return this.showSql;
    }

    public void setShowSql(boolean showSql) {
        this.showSql = showSql;
    }

    public boolean isShowBanner() {
        return this.showBanner;
    }

    public void setShowBanner(boolean showBanner) {
        this.showBanner = showBanner;
    }

    public boolean isShowStartLog() {
        return this.showStartLog;
    }

    public void setShowStartLog(boolean showStartLog) {
        this.showStartLog = showStartLog;
    }

    public void log(String log) {
        if (!this.showStartLog) {
            return;
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        System.out.println(sdf.format(new Date()) + "<<easyApi>>" + log);
    }
}

