package cn.easyutil.easyapi.parameterized;

import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.*;

/**
 * 泛型与真实类型绑定关系
 */
public class GenericTypeBind {

    private final List<Map<String,Type>> binds = new ArrayList<>();

    private final Set<String> keys = new HashSet<>();

    public void bind(String typeName,Type type){
        remove(typeName);
        Map<String,Type> map = new HashMap<>();
        map.put(typeName, type);
        this.binds.add(map);
        keys.add(typeName);
    }

    public void binds(GenericTypeBind binds){
        if(binds==null || binds.size()==0){
            return;
        }
        for (String key : binds.keys()) {
            if(!this.keys.contains(key)){
                bind(key,binds.get(key));
                continue;
            }
            Type valType = binds.get(key);
            Type val = this.get(key);
            if(val instanceof TypeVariable){
                bind(key,valType);
            }
        }
    }

    public Type get(int index){
        if(index >= binds.size()){
            return null;
        }
        return binds.get(index).values().iterator().next();
    }

    public Type get(String typeName){
        for (Map<String, Type> bind : binds) {
            if(bind.containsKey(typeName)){
                return bind.get(typeName);
            }
        }
        return null;
    }

    public void remove(String typeName){
        Iterator<Map<String, Type>> iterator = binds.iterator();
        while (iterator.hasNext()){
            Map<String, Type> next = iterator.next();
            if(next.containsKey(typeName)){
                iterator.remove();
                keys.remove(typeName);
                return;
            }
        }
    }

    /**
     * 匹配泛型
     */
    public Type matchVariable(String typeName){
        if(typeName == null){
            return null;
        }
        Type type = get(typeName);
        if(type == null){
            return null;
        }
        while (type instanceof TypeVariable){
            type = get(type.getTypeName());
            if(type == null){
                break;
            }
        }
        return type;
    }

    public void remove(int index){
        if(index > binds.size()){
            return ;
        }
        binds.remove(index);
    }

    public Set<String> keys(){
        return keys;
    }

    public int size(){
        return binds.size();
    }
}
