package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.configuration.EasyApiGlobalRequestConfiguration;
import cn.easyutil.easyapi.configuration.EasyApiGlobalResponseConfiguration;
import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.handler.extra.*;
import cn.easyutil.easyapi.handler.operator.MockReader;
import cn.easyutil.easyapi.handler.operator.RequestReader;
import cn.easyutil.easyapi.handler.operator.ResponseReader;
import cn.easyutil.easyapi.javadoc.reader.ClassComment;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.javadoc.util.UncertainParamParser;
import cn.easyutil.easyapi.logic.condition.MockProcess2;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import cn.easyutil.easyapi.util.*;
import org.springframework.beans.BeanUtils;
import org.springframework.core.DefaultParameterNameDiscoverer;
import org.springframework.util.CollectionUtils;

import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.Type;
import java.util.*;

public class MethodParamsCreator {

    private Class<?> clazz;

    private Method method;

    private RequestReader reqFilter;

    private ResponseReader resFilter;

    private MockReader mockFilter;

    private List<DocParamEntity> requestParameters = new ArrayList<>();

    private List<DocParamEntity> returnParameter = new ArrayList<>();

    private String responseMock = "";
    private String requestMock = "";

    private InterfaceExtra interfaceExtra;

    private MethodParamsCreator() {}

    public static MethodParamsCreator build(InterfaceExtra interfaceExtra){
        MethodParamsCreator creator = new MethodParamsCreator();
        creator.interfaceExtra = interfaceExtra;
        creator.clazz = interfaceExtra.getControllerExtra().getControllerClass();
        creator.method = interfaceExtra.getMethod();
        creator.reqFilter = ProjectContext.requestOperator;
        creator.resFilter = ProjectContext.responseOperator;
        creator.mockFilter = ProjectContext.mockTemplateOperator;
        return creator;
    }

    public MethodParamsCreator create(){
        try {
            createParameters();
            createReturnType();
            MockProcess2 mocker = MockProcess2.with(mockFilter);
            mocker.setMockArraySize(ProjectContext.allConfiguration.getConfiguration().getMockArraySize());
            Object req = mocker.mockByApiParams(requestParameters);
            Object res = mocker.mockByApiParams(returnParameter);
            requestMock = ObjectUtil.isBaseObject(req)?req.toString():JsonUtil.beanToJson(req);
            responseMock = ObjectUtil.isBaseObject(res)?res.toString():JsonUtil.beanToJson(res);
            return this;
        }catch (Exception e) {
            e.printStackTrace();
            throw new ApidocException("接口参数构建失败:"+clazz.getCanonicalName()+"."+method.getName());
        }
    }

    private DocParamEntity createResponseDoc(MethodParam param, ResponseExtra responseExtra){
        if(resFilter.ignore(responseExtra,null)){
            return null;
        }
        String description = resFilter.description(responseExtra,null);
        JavaType javaType = JavaType.getJavaTypeByType(param.getParamType());
        //补充基本信息
        DocParamEntity entity = new DocParamEntity();
        entity.setDescription(description);
        entity.setMockTemplate(resFilter.mockTemplate(responseExtra,null));
        entity.setClassName(param.getParamType().getTypeName());
        entity.setRequired(resFilter.required(responseExtra,null)?1:0);
        entity.setShow(resFilter.show(responseExtra,null)?1:0);
        entity.setJavaType(javaType.getType());
        GenericTypeBind bind = GenericTypeUtil.getGenericTypes(param.getParamType());
        bind.binds(param.getBind());
        createParam(param.getParamType(), entity,bind,responseExtra);
        return entity;
    }

    private DocParamEntity createRequestDoc(MethodParam param, RequestExtra requestExtra){
        String paramName = reqFilter.name(requestExtra,param.getParamName());
        Type paramType = reqFilter.type(requestExtra,param.getParamType());
        Class<?> ownerClass = GenericTypeUtil.getOwnerClass(paramType);
        if(reqFilter.ignore(requestExtra,null)){
            return null;
        }
        if(paramType==null || ownerClass==null){
            return null;
        }
        String description = reqFilter.description(requestExtra,null);
        if(StringUtil.isEmpty(description)){
            description = requestExtra.getInterfaceExtra().getMethodComment().getParameter(paramName).getComment();
        }
        JavaType javaType = JavaType.getJavaTypeByType(paramType);
        //补充基本信息
        DocParamEntity entity = new DocParamEntity();
        entity.setDescription(description);
        entity.setMockTemplate(reqFilter.mockTemplate(requestExtra,null));
        entity.setName(paramName);
        entity.setClassName(ownerClass.getCanonicalName());
        entity.setRequired(reqFilter.required(requestExtra,null)?1:0);
        entity.setShow(reqFilter.show(requestExtra,null)?1:0);
        entity.setJavaType(javaType.getType());
        GenericTypeBind bind = GenericTypeUtil.getGenericTypes(paramType);
        bind.binds(param.getBind());
        createParam(paramType, entity,bind,requestExtra);
        return entity;
    }


    private void deepCreateParameters(List<MethodParam> params,List<DocParamEntity> result,String originalParameterName,RequestExtra requestExtra,boolean enableGlobal){
        UncertainParamParser util = null;
        MethodComment methodComment = requestExtra.getInterfaceExtra().getMethodComment();
        ClassComment controllerComment = requestExtra.getInterfaceExtra().getControllerExtra().getControllerComment();
        if(methodComment != null){
            util = UncertainParamParser.builder(clazz,method,controllerComment,methodComment);
        }
        for (MethodParam param : params) {
            DocParamEntity createParams = createRequestDoc(param,requestExtra);
            if(createParams == null){
                continue;
            }
            if(CollectionUtils.isEmpty(createParams.getChildren())){
                //如果没有子属性，则把当前参数加入到参数集合中
                result.add(createParams);
                continue;
            }
            if(util!=null && originalParameterName!=null){
                for (DocParamEntity doc : createParams.getChildren()) {
                    MethodParam docParam = null;
                    if (doc.getJavaType().equals(JavaType.Map.getType()) && CollectionUtils.isEmpty(doc.getChildren())) {
                        docParam = util.parseRequestMapField(originalParameterName, doc.getName());
                    }
                    if (doc.getJavaType().equals(JavaType.Object.getType()) && CollectionUtils.isEmpty(doc.getChildren())) {
                        docParam = util.parseRequestObjField(originalParameterName, doc.getName());
                    }
                    if(docParam != null){
                        if(CollectionUtils.isEmpty(docParam.getChildren())){
                            //说明是类型转换
                            DocParamEntity doc1 = createRequestDoc(docParam,requestExtra);
                            if(doc1 != null){
                                String name = doc.getName();
                                BeanUtils.copyProperties(doc1,doc);
                                doc.setName(name);
                            }
                        }else{
                            List<MethodParam> children = Optional.ofNullable(param.getChildren()).orElse(new ArrayList<>());
                            children.addAll(docParam.getChildren());
                            param.setChildren(children);
                        }
                    }
                }
                if(GenericTypeUtil.isArray(requestExtra.getType())){
                    createParams.setName(ProjectContext.nullKey);
                    result.add(createParams);
                }else{
                    if(enableGlobal){
                        result.add(createParams);
                    }else{
                        result.addAll(createParams.getChildren());
                    }
                }
            }
            if(!CollectionUtils.isEmpty(param.getChildren())){
                //添加子类
                List<DocParamEntity> children = Optional.ofNullable(createParams.getChildren()).orElse(new ArrayList<>());
                deepCreateParameters(param.getChildren(),children,null,requestExtra,enableGlobal);
                createParams.setChildren(children);
                if(originalParameterName != null){
                    //首次解析，如果是对象应该直接使用对象字段，抛弃外层包装
                    result.addAll(children);
                }else{
                    result.add(createParams);
                }
            }
        }
    }

    private List<MethodParam> createParams(RequestExtra requestExtra){
        String parameterName = requestExtra.getParameterName();
        Type parameterType = requestExtra.getType();
        MethodParam param = new MethodParam();
        param.setParamType(parameterType);
        param.setParamName(parameterName);
        //获取真实类型
        Class<?> ownerClass = GenericTypeUtil.getOwnerClass(parameterType);
        if(ownerClass == null){
            return new ArrayList<>();
        }
        UncertainParamParser util = null;
        MethodComment methodComment = requestExtra.getInterfaceExtra().getMethodComment();
        ClassComment controllerComment = requestExtra.getInterfaceExtra().getControllerExtra().getControllerComment();
        if(methodComment != null){
            util = UncertainParamParser.builder(clazz,method,controllerComment,methodComment);
        }
        //如果是Map类型，则解析源码
        if(Map.class.isAssignableFrom(ownerClass)){
            if(util == null){
                return Collections.singletonList(param);
            }
            MethodParam mapParam = util.parseRequestMap(parameterName);
            if(mapParam == null){
                return Collections.singletonList(param);
            }
            return Optional.ofNullable(mapParam.getChildren()).orElse(Collections.emptyList());
        }
        //如果是Object类型
        if(Object.class.equals(ownerClass)){
            if(util == null){
                return Collections.singletonList(param);
            }
            MethodParam objParam = util.parseRequestObj(parameterName);
            if(objParam == null){
                return Collections.singletonList(param);
            }
            return Optional.ofNullable(objParam.getChildren()).orElse(Collections.emptyList());
        }
        //其他类型都是直接返回
        return Collections.singletonList(param);
    }

    private void createParameters(){
        Parameter[] parameters = method.getParameters();
        DefaultParameterNameDiscoverer discover = new DefaultParameterNameDiscoverer();
        // 实际方法参数形参名称
        String[] parameterNames = discover.getParameterNames(method);
        if(parameters==null || parameters.length==0){
            return ;
        }
        if(parameterNames==null || parameterNames.length==0){
            return ;
        }
        for (int i = 0; i < parameters.length; i++) {
            MethodParam param = new MethodParam();
            String parameterName = parameterNames[i];
            Type parameterType = parameters[i].getParameterizedType();
            param.setParameter(parameters[i]);

            //初始化传递数据
            RequestExtra requestExtra = new RequestExtra(interfaceExtra);
            requestExtra.setParameter(parameters[i]);
            requestExtra.setParameterName(parameterName);
            requestExtra.setType(parameterType);
            requestExtra.setTypeBind(GenericTypeUtil.getGenericTypes(requestExtra.getType()));
            parameterName = reqFilter.name(requestExtra,null);
            if(StringUtil.isEmpty(param.getParamName())){
                param.setParamName(parameterNames[i]);
            }
            requestExtra.setParameterName(parameterName);
            param.setParamName(parameterName);

            parameterType = reqFilter.type(requestExtra,null);
            param.setParamType(parameterType);
            requestExtra.setType(parameterType);
            requestExtra.setTypeBind(GenericTypeUtil.getGenericTypes(requestExtra.getType()));

            List<DocParamEntity> result = new ArrayList<>();
            List<MethodParam> params = createParams(requestExtra);
            reqFilter.params(requestExtra,null);
            boolean enableGlobal = false;
            //如果当前参数仅1条，则判断下是否使用全局统一请求类型
            if(parameters.length==1 && !CollectionUtils.isEmpty(ProjectContext.globalRequestParams)){
                //处理全局统一返回结构
                EasyApiGlobalRequestConfiguration reqConf = ProjectContext.allConfiguration.getGlobalRequestConfiguration();
                Class<?> globalType = reqConf.getRequestType();
                String globalFieldName = reqConf.getFieldName();
                List<MethodParam> process = globalParamProcess(param, globalType, globalFieldName,ProjectContext.globalRequestParams, reqConf.getExcludeMethods(), reqConf.getIncludeMethods());
                if(process != null){
                    params = process;
                    enableGlobal = true;
                }
            }
            deepCreateParameters(params,result,parameterNames[i],requestExtra,enableGlobal);
            this.requestParameters.addAll(result);
        }
    }

    private DocParamEntity deepCreateReturnType(MethodParam param){
        Type type = param.getParamType();
        if(type == Void.TYPE){
            return null;
        }
        Class<?> ownerClass = GenericTypeUtil.getOwnerClass(type);
        GenericTypeBind bind = GenericTypeUtil.getGenericTypes(type);
        bind.binds(param.getBind());

        //初始化传递数据
        ResponseExtra responseExtra = new ResponseExtra(interfaceExtra);
        responseExtra.setType(type);
        responseExtra.setTypeBind(bind);

        //获取自定义类型
        if(type==null || ownerClass==null){
            return null;
        }
        //判断是否需要忽略
        if(resFilter.ignore(responseExtra,null)){
            return null;
        }
        JavaType javaType = JavaType.getJavaTypeByType(type);
        DocParamEntity entity = new DocParamEntity();
        entity.setDescription(resFilter.description(responseExtra,null));
        entity.setMockTemplate(resFilter.mockTemplate(responseExtra,null));
        entity.setRequired(resFilter.required(responseExtra,null)?1:0);
        entity.setShow(resFilter.show(responseExtra,null)?1:0);
        entity.setName(ProjectContext.nullKey);
        if(!StringUtil.isEmpty(param.getParamName())){
            entity.setName(param.getParamName());
        }
        entity.setClassName(ownerClass.getCanonicalName());
        entity.setJavaType(javaType.getType());
        createParam(type, entity,bind,responseExtra);
        entity.setChildren(entity.getChildren()==null?new ArrayList<>():new ArrayList<>(entity.getChildren()));
        return entity;
    }

    private List<DocParamEntity> mapOrObject(DocParamEntity doc,UncertainParamParser util,boolean isField,ResponseExtra responseExtra){
        if(doc == null){
            return null;
        }
        if(util != null){
            List<MethodParam> uncertains = null;
            if (doc.getJavaType().equals(JavaType.Map.getType())) {
                MethodParam mapParam = util.parseResponseMapField(doc.getName());
                if(!isField){
                    mapParam = util.parseResponseMap();
                }
                if (mapParam!=null && mapParam.getChildren()!=null) {
                    uncertains = mapParam.getChildren();
                }
            }
            if(!StringUtil.isEmpty(doc.getClassName()) && doc.getClassName().contains("java.lang.Object")){
                MethodParam objParam = util.parseResponseObjField(doc.getName());
                if(!isField){
                    objParam = util.parseResponseObj();
                }
                if (objParam != null) {
                    uncertains = objParam.getChildren();
                }
            }
            if(uncertains != null){
                for (MethodParam uncertain : uncertains) {
                    DocParamEntity childrenDoc = createResponseDoc(uncertain,responseExtra);
                    if(childrenDoc != null){
                        List<DocParamEntity> children = Optional.ofNullable(doc.getChildren()).orElse(new ArrayList<>());
                        children = new ArrayList<>(children);
                        children.add(childrenDoc);
                        return children;
                    }
                }
            }
        }
        return null;
    }

    private void deepCreateReturnType(List<MethodParam> types,List<DocParamEntity> result,ResponseExtra modelExtra){
        UncertainParamParser util = null;
        MethodComment methodComment = modelExtra.getInterfaceExtra().getMethodComment();
        ClassComment controllerComment = modelExtra.getInterfaceExtra().getControllerExtra().getControllerComment();
        if(methodComment != null){
            util = UncertainParamParser.builder(clazz,method,controllerComment,methodComment);
        }
        for (MethodParam param : types) {
            DocParamEntity document = deepCreateReturnType(param);
            if(document == null){
                continue;
            }
            List<DocParamEntity> children = Optional.ofNullable(document.getChildren()).orElse(new ArrayList<>());
            List<DocParamEntity> mapChildren = mapOrObject(document, util,false,modelExtra);
            if(!CollectionUtils.isEmpty(mapChildren)){
                children.addAll(mapChildren);
            }
            document.setChildren(children);
            //再处理children
            for (DocParamEntity doc : children) {
                List<DocParamEntity> docMapChildren = mapOrObject(doc, util,true,modelExtra);
                if(!CollectionUtils.isEmpty(docMapChildren)){
                    List<DocParamEntity> docChildren = doc.getChildren()==null?new ArrayList<>():new ArrayList<>(doc.getChildren());
                    docChildren.addAll(docMapChildren);
                    doc.setChildren(docChildren);
                }
            }
            if(!CollectionUtils.isEmpty(param.getChildren())){
                List<DocParamEntity> cr = new ArrayList<>();
                deepCreateReturnType(param.getChildren(),cr,modelExtra);
                children.addAll(cr);
            }
            document.setChildren(children);
            result.add(document);
        }
    }

    private void createReturnType(){
        ResponseExtra responseExtra = new ResponseExtra(interfaceExtra);
        responseExtra.setType(method.getGenericReturnType());
        responseExtra.setTypeBind(GenericTypeUtil.getGenericTypes(responseExtra.getType()));
        List<MethodParam> types = resFilter.returnType(responseExtra,null);
        if(types == null){
            return ;
        }
        if(types.size()==1 && !CollectionUtils.isEmpty(ProjectContext.globalResponseParams)){
            //处理全局统一返回结构
            MethodParam param = types.get(0);
            EasyApiGlobalResponseConfiguration resConf = ProjectContext.allConfiguration.getGlobalResponseConfiguration();
            Class<?> globalType = resConf.getReturnType();
            String globalFieldName = resConf.getFieldName();
            List<MethodParam> process = globalParamProcess(param, globalType, globalFieldName,ProjectContext.globalResponseParams, resConf.getExcludeMethods(), resConf.getIncludeMethods());
            if(process != null){
                types = process;
            }
        }
        List<DocParamEntity> result = new ArrayList<>();
        deepCreateReturnType(types,result,responseExtra);
        if(result.isEmpty()){
            return ;
        }
        if(GenericTypeUtil.isArray(responseExtra.getType())){
            result.get(0).setName(ProjectContext.nullKey);
            this.returnParameter.addAll(result);
            return ;
        }
        Integer javaType = result.get(0).getJavaType();
        if(javaType.equals(JavaType.Object.getType())){
            this.returnParameter.addAll(result.get(0).getChildren());
        }else{
            this.returnParameter.addAll(result);
        }
    }

    /**
     * 处理全局统一参数
     * @param param 原本的参数
     * @param globalType    全局类型
     * @param globalFieldName   全局字段名称
     * @param excludeMethods    排除规则
     * @param includeMethods    匹配规则
     * @return  全局统一类型
     */
    private List<MethodParam> globalParamProcess(MethodParam param,Class<?> globalType,String globalFieldName,List<MethodParam> globalParams,Set<String> excludeMethods,Set<String> includeMethods) {
        //不在排除的范围内
        if(excludeMethods.stream().noneMatch(ex -> ApidocCommentUtil.isMatchPath(ex,method.toGenericString()))){
            //符合统一返回范围要求
            if(includeMethods.stream().anyMatch(in -> ApidocCommentUtil.isMatchPath(in,method.toGenericString()))){
                //本身是非统一类型返回
                Set<String> globalIgnoreFields = new HashSet<>();
                globalIgnoreFields.add(globalFieldName);
                globalIgnoreFields.add("serialVersionUID");
                if(param.getParamType()==null || !globalType.equals(GenericTypeUtil.getOwnerClass(param.getParamType()))){
                    param.setParamName(globalFieldName);
                    globalParams.removeIf(next -> globalIgnoreFields.contains(next.getParamName()));
                    globalParams.add(param);
                    return globalParams;
                }
            }
        }
        return null;
    }

    /**
     * 构建参数
     */
    private void createParam(Type type, DocParamEntity entity, GenericTypeBind bind, MethodExtra methodExtra){
        JavaType javaType = JavaType.getType(entity.getJavaType());
        Class<?> ownerClass = GenericTypeUtil.getOwnerClass(type);
        if(ownerClass == null){
            return ;
        }
        if(ownerClass.isEnum()){
            //枚举单独处理
            entity.setJavaType(JavaType.String.getType());
            Map<String, List<String>> enumFields = ObjectUtil.getEnumFields(ownerClass);
            entity.setJavaType(JavaType.String.getType());
            entity.setMockTemplate(enumFields.keySet().iterator().next());
            entity.setMockValue(enumFields.keySet().iterator().next());
            entity.setDescription(entity.getDescription()+"=>"+String.join(",",enumFields.keySet()));
            return ;
        }
        JavaBeanCreator javaBeanCreator = JavaBeanCreator.builder(methodExtra);
        //已经创建好的bean对象，避免无限递归循环
        Map<String, List<DocParamEntity>> exists = ParamDocClassLoadCache.getExists();
        if(javaType == JavaType.Object){
            entity.setChildren(javaBeanCreator.readBean(type,bind,exists));
            return ;
        }
        entity.setClassName(ownerClass.getCanonicalName());
        entity.setJavaType(javaType.getType());
        switch (javaType){
            case Array:{
                entity.setChildren(javaBeanCreator.readArray(type,bind));
                break;
            }
            case ArrayObject:{
                entity.setChildren(javaBeanCreator.readArrayObject(type,bind,exists));
                break;
            }
        }
        MockExtra mockExtra = new MockExtra();
        mockExtra.setJavaType(javaType);
        mockExtra.setTemplate(entity.getMockTemplate());
        Object mockValue = mockFilter.mock(mockExtra,null);
        entity.setMockValue(JsonUtil.beanToJson(mockValue));
        String uniqueStr = method.getDeclaringClass().getCanonicalName()+method.toGenericString()+entity.getClassName()+entity.getName();
        entity.setUnique(StringUtil.toMD5(uniqueStr));
        entity.setOrigin(EasyapiOriginUtil.createOrigin(entity));
        entity.setRenewType(RenewType.increment.getType());
    }


    public List<DocParamEntity> getRequestParameters() {
        return requestParameters;
    }

    public void setRequestParameters(List<DocParamEntity> requestParameters) {
        this.requestParameters = requestParameters;
    }

    public List<DocParamEntity> getReturnParameter() {
        return returnParameter;
    }

    public void setReturnParameter(List<DocParamEntity> returnParameter) {
        this.returnParameter = returnParameter;
    }

    public String getResponseMock() {
        return responseMock;
    }

    public String getRequestMock() {
        return requestMock;
    }
}
