package cn.easyutil.easyapi.logic.creator;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.common.JavaType;
import cn.easyutil.easyapi.entity.common.RenewType;
import cn.easyutil.easyapi.handler.extra.*;
import cn.easyutil.easyapi.handler.operator.BeanReader;
import cn.easyutil.easyapi.handler.operator.MockReader;
import cn.easyutil.easyapi.handler.operator.provide.MockReaderProvider;
import cn.easyutil.easyapi.javadoc.reader.CommentDetail;
import cn.easyutil.easyapi.javadoc.reader.FieldComment;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceComment;
import cn.easyutil.easyapi.javadoc.reader.JavaSourceReader;
import cn.easyutil.easyapi.parameterized.GenericTypeBind;
import cn.easyutil.easyapi.parameterized.GenericTypeUtil;
import cn.easyutil.easyapi.util.EasyapiOriginUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.ObjectUtil;
import cn.easyutil.easyapi.util.StringUtil;
import org.springframework.util.CollectionUtils;

import java.io.File;
import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.*;
import java.util.stream.Collectors;

public class JavaBeanCreator {

    private BeanReader filter;

    private MockReader mockFilter;
    //项目根目录
    private Set<String> projectBasePaths;

    private MethodExtra methodExtra;

    public JavaBeanCreator(MethodExtra methodExtra) {
        this.methodExtra = methodExtra;
        filter = ProjectContext.beanOperator;
        mockFilter = new MockReaderProvider();
        this.setMethodExtra(methodExtra);
        projectBasePaths = ProjectContext.projectBasePath;
    }

    public static JavaBeanCreator builder(MethodExtra methodExtra){
        return new JavaBeanCreator(methodExtra);
    }

    private String buildCreatersKey(Class aClass,GenericTypeBind bind){
        String bindKey = "";
        if(bind.keys().size() > 0){
            for (String key : bind.keys()) {
                bindKey += bind.get(key);
            }
        }
        return aClass.getCanonicalName()+bindKey;
    }

    public List<DocParamEntity> readBean(Type type, GenericTypeBind binds, Map<String,List<DocParamEntity>> exists){
        Class aClass;
        if(binds == null){
            binds = new GenericTypeBind();
        }
        aClass = GenericTypeUtil.getOwnerClass(type);
        GenericTypeBind currentBinds = GenericTypeUtil.getGenericTypes(type);
        binds.binds(currentBinds);
        if (aClass==Object.class || aClass == Class.class) {
            return Collections.emptyList();
        }
        String creatersKey = buildCreatersKey(aClass, currentBinds);
        if(exists.containsKey(creatersKey)){
            return JsonUtil.jsonToList(JsonUtil.beanToJson(exists.get(creatersKey)),DocParamEntity.class);
        }
        exists.put(creatersKey,Collections.emptyList());
        List<DocParamEntity> bean = new ArrayList<>();
        JavaType javaType = JavaType.getJavaTypeByType(type);
        switch (javaType){
            case Object:
                bean = getBean(aClass, binds,exists);
                break;
            case ArrayObject:
                bean = readArrayObject(type, binds,exists);
                break;
            case Array:
                bean = readArray(type, binds);
                break;
        }
        //先放一个占位
        exists.put(creatersKey,bean);
        return bean;
    }

    public List<DocParamEntity> readArray(Type type,GenericTypeBind binds){
        if(binds == null){
            binds = new GenericTypeBind();
        }
        //获取集合中的真实泛型类型
        Type arrayType = GenericTypeUtil.getOwnerClass(type);
        if(GenericTypeUtil.isGeneric(type)){
            GenericTypeBind genericTypeBind = GenericTypeUtil.getGenericTypes(type);
            Type bindType = binds.matchVariable(genericTypeBind.get(0).getTypeName());
            if(bindType != null){
                arrayType = bindType;
            }else{
                arrayType = genericTypeBind.get(0);
            }
        }
        //基本数据类型
        DocParamEntity childrean = new DocParamEntity();
        childrean.setRequired(0);
        childrean.setShow(0);
        ModelFieldExtra fieldExtra = new ModelFieldExtra(methodExtra);
        fieldExtra.setFieldType(type);
        fieldExtra.setFieldTypeBind(binds);
        RenewType renewType = filter.renewType(fieldExtra,null);
        childrean.setRenewType(renewType==null?RenewType.increment.getType():renewType.getType());
        childrean.setJavaType(JavaType.getJavaTypeByType(arrayType).getType());
        childrean.setClassName(type.getTypeName());
        childrean.setName(ProjectContext.nullKey);
        MockExtra mockExtra = new MockExtra();
        mockExtra.setTemplate(childrean.getMockTemplate());
        mockExtra.setJavaType(JavaType.getType(childrean.getJavaType()));
        Object mockValue = mockFilter.mock(mockExtra,null);
        childrean.setMockValue(ObjectUtil.isBaseObject(mockValue)?mockValue.toString():JsonUtil.beanToJson(mockValue));
        childrean.setOrigin(EasyapiOriginUtil.createOrigin(childrean));
        return Collections.singletonList(childrean);
    }

    public List<DocParamEntity> readArrayObject(Type type, GenericTypeBind binds, Map<String,List<DocParamEntity>> exists){
        if(binds == null){
            binds = new GenericTypeBind();
        }
        //获取集合中的真实泛型类型
        Type arrayType = GenericTypeUtil.getOwnerClass(type);
        if(GenericTypeUtil.isGeneric(type)){
            if(Collection.class.isAssignableFrom(GenericTypeUtil.getOwnerClass(arrayType))){
                arrayType = binds.get(0);
            }
        }
        if(arrayType instanceof Class && Collection.class.isAssignableFrom(GenericTypeUtil.getOwnerClass(arrayType))){
            arrayType = Map.class;
        }
        //非集合类型
        return readBean(arrayType, binds,exists);
    }

    private List<DocParamEntity> getBean(Class<?> beanClass,GenericTypeBind binds,Map<String,List<DocParamEntity>> exists){
        List<DocParamEntity> result = new ArrayList<>();
        //需要读取父类
        Class<?> clazz = beanClass;
        //存放所有子类及父类的字段
        Set<String> fieldNames = new HashSet<>();
        while (clazz!=null && !clazz.equals(Object.class) && clazz!=Class.class) {
            //先读取源码字段注释
            File beanFile = null;
            for (String projectBasePath : this.projectBasePaths) {
                beanFile = CreatorCommonMethod.getClassFile(clazz, projectBasePath);
                if(beanFile.exists()){
                    break;
                }
            }
            JavaSourceReader classFileReader = new JavaSourceReader();
            if(beanFile!=null && beanFile.exists()){
                classFileReader = JavaSourceReader.builder(beanFile);
            }
            List<FieldComment> fieldComments = classFileReader.getComment().getFields();
            Map<String, FieldComment> fieldComment = fieldComments.stream().collect(Collectors.toMap(JavaSourceComment::getName, item -> item));

            ModelFieldExtra fieldExtra = new ModelFieldExtra(methodExtra);
            fieldExtra.setModelType(clazz);
            fieldExtra.setModelTypeBind(binds);
            List<FieldParam> params = filter.params(fieldExtra,null);
            if(params == null){
                clazz = clazz.getSuperclass();
                continue;
            }
            for (FieldParam param : params) {
                Field field = param.getField();
                Type type = param.getParamType();
                String paramName = param.getParamName();
                GenericTypeBind currentBinds = GenericTypeUtil.getGenericTypes(type);

                //初始化field信息
                fieldExtra.setFieldName(paramName);
                fieldExtra.setField(field);
                fieldExtra.setFieldType(type);
                fieldExtra.setFieldTypeBind(currentBinds);
                if(field != null){
                    fieldExtra.setFieldComment(Optional.ofNullable(fieldComment.get(field.getName())).orElse(new FieldComment()));
                }

                paramName = filter.name(fieldExtra,null);
                if(StringUtil.isEmpty(paramName)){
                    continue;
                }
                Type newType = filter.type(fieldExtra,null);
                if(!newType.equals(type)){
                    currentBinds = GenericTypeUtil.getGenericTypes(type);
                    fieldExtra.setFieldTypeBind(currentBinds);
                    fieldExtra.setFieldType(newType);
                    type = newType;
                }
                //如果该字段标记忽略，则不解析
                if (filter.ignore(fieldExtra,null)) {
                    continue;
                }
                int size = fieldNames.size();
                fieldNames.add(paramName);
                if (size == fieldNames.size()) {
                    //父类不覆盖子类，子类最大
                    continue;
                }
                //字段类型
                Class<?> ownerClass = GenericTypeUtil.getOwnerClass(type);
                if(ownerClass == null){
                    continue;
                }
                if(GenericTypeUtil.isGeneric(type) && !GenericTypeUtil.isArray(type)){
                    Type bindType = binds.matchVariable(type.getTypeName());
                    if(bindType != null){
                        type = bindType;
                        ownerClass = GenericTypeUtil.getOwnerClass(type);
                    }
                }
                currentBinds = GenericTypeUtil.getGenericTypes(type);
                if(ownerClass==null){
                    continue;
                }
                for (String key : currentBinds.keys()) {
                    Type matchType = binds.matchVariable(currentBinds.get(key).getTypeName());
                    if(matchType != null){
                        currentBinds.bind(key,matchType);
                    }
                }
                if(currentBinds.size() == 0){
                    currentBinds.binds(binds);
                }
                fieldExtra.setFieldTypeBind(currentBinds);
                //读取字段说明
                String description = filter.description(fieldExtra,null);
                if (StringUtil.isEmpty(description)) {
                    //注释不存在则使用属性名
                    description = paramName;
                }
                if (!GenericTypeUtil.isArray(type) && ownerClass == Class.class) {
                    ownerClass = Map.class;
                    type = Map.class;
                }

                JavaType javaType = filter.javaType(fieldExtra,null);
                if(javaType == null){
                    continue;
                }
                //组装参数
                DocParamEntity entity = new DocParamEntity();
                entity.setName(paramName);
                entity.setClassName(ownerClass.getCanonicalName());
                entity.setDescription(description);
                entity.setJavaType(javaType.getType());
                entity.setMockTemplate(filter.mockTemplate(fieldExtra,null));
                entity.setShow(filter.show(fieldExtra,null)?1:0);
                entity.setRequired(filter.required(fieldExtra,null)?1:0);
                entity.setConditionTemplate(String.join(",", filter.conditions(fieldExtra,null)));
                FieldComment fComment = fieldComment.get(paramName);
                boolean isEnumDescription = false;
                if(fComment!=null && !CollectionUtils.isEmpty(fComment.getCommentDetails())){
                    //如果当前字段有@see标识，需要单独处理
                    List<CommentDetail> commentDetails = fComment.getCommentDetails();
                    CommentDetail detail = commentDetails.stream().filter(item -> "see".equals(item.getKey())).findFirst().orElse(null);
                    if(detail != null){
                        try {
                            Class<?> aClass = Class.forName(detail.getValue().trim());
                            Map<String, List<String>> enumFields = ObjectUtil.getEnumFields(aClass);
                            if(!CollectionUtils.isEmpty(enumFields)){
                                isEnumDescription = true;
                                StringBuilder sb = new StringBuilder();
                                enumFields.forEach((key, value) -> sb.append(key).append("<").append(String.join(":", value)).append(">").append(","));
                                entity.setDescription(entity.getDescription()+"=>"+sb.substring(0,sb.length()-1));
                            }
                        }catch (Exception ignore) {}
                    }
                }
                switch (javaType) {
                    case Object:
                        //枚举单独处理
                        if(ownerClass.isEnum()){
                            if(isEnumDescription){
                                break;
                            }
                            Map<String, List<String>> enumFields = ObjectUtil.getEnumFields(ownerClass);
                            entity.setJavaType(JavaType.String.getType());
                            entity.setDescription(entity.getDescription()+"=>"+String.join(",",enumFields.keySet()));
                            entity.setMockTemplate(enumFields.keySet().iterator().next());
                            entity.setMockValue(enumFields.keySet().iterator().next());
                            break;
                        }
                    case ArrayObject:
                    case Array:
                        entity.setChildren(readBean(type,currentBinds,exists));
                        break;
                    default:
                        MockExtra mockExtra = new MockExtra();
                        mockExtra.setJavaType(javaType);
                        mockExtra.setTemplate(entity.getMockTemplate());
                        Object mockValue = mockFilter.mock(mockExtra,null);
                        entity.setMockValue(ObjectUtil.isBaseObject(mockValue)?mockValue.toString():JsonUtil.beanToJson(mockValue));
                }
                entity.setUnique(field==null?UUID.randomUUID().toString():StringUtil.toMD5(field.toGenericString()));
                RenewType renewType = filter.renewType(fieldExtra,null);
                entity.setRenewType(renewType==null?RenewType.increment.getType():renewType.getType());
                entity.setOrigin(EasyapiOriginUtil.createOrigin(entity));
                result.add(entity);
            }
            clazz = clazz.getSuperclass();
        }
        return result;
    }

    public BeanReader getFilter() {
        return filter;
    }

    public void setFilter(BeanReader filter) {
        this.filter = filter;
    }

    public MockReader getMockFilter() {
        return mockFilter;
    }

    public void setMockFilter(MockReader mockFilter) {
        this.mockFilter = mockFilter;
    }

    public Set<String> getProjectBasePaths() {
        return projectBasePaths;
    }

    public void setProjectBasePaths(Set<String> projectBasePaths) {
        this.projectBasePaths = projectBasePaths;
    }

    public MethodExtra getMethodExtra() {
        return methodExtra;
    }

    public void setMethodExtra(MethodExtra methodExtra) {
        if(methodExtra == null){
            return ;
        }
        this.methodExtra = methodExtra;
    }
}
