package cn.easyutil.easyapi.interview.entity;

import cn.easyutil.easyapi.entity.common.Page;
import cn.easyutil.easyapi.util.ObjectUtil;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;

public class ResponseBody implements Serializable{

	private static final long serialVersionUID = 1L;
	//状态码
	private Integer code;
	//说明
	private String remark;
	//数据
	private Object data;
	//分页信息
	private Page page;
	//标注本对象出处
	private String userAgent = "easyapi";

	public Integer getCode() {
		return code;
	}

	public String getRemark() {
		return remark;
	}

	public void setCode(Integer code) {
		this.code = code;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public Page getPage() {
		return page;
	}

	public void setPage(Page page) {
		this.page = page;
	}

	public String getUserAgent() {
		return userAgent;
	}

	public void setUserAgent(String userAgent) {
		this.userAgent = userAgent;
	}

	public Object getData() {
		return data;
	}

	public void setData(Object data) {
		this.data = data;
	}

	public static ResponseBody error(String remark){
		return error(500, remark);
	}
	
	public static ResponseBody error(Integer code, String remark){
		ResponseBody body = new ResponseBody();
		body.setCode(code);
		body.setRemark(remark);
		return body;
	}
	
	public static ResponseBody error(){
		return error(500, "请求失败");
	}

	public static ResponseBody success(Object t){
		ResponseBody body = new ResponseBody();
		body.setCode(200);
		body.setRemark("请求成功");
		body.setData(t);
		body.setPage(null);
		return body;
	}

}
