package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.Page;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.exception.ApidocException;
import cn.easyutil.easyapi.interview.entity.ResponseBody;
import cn.easyutil.easyapi.interview.entity.UnifiedAccessDto;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.javadoc.html.StaticDocCreate;
import cn.easyutil.easyapi.mybatis.service.ProjectService;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.*;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.*;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URLEncoder;
import java.util.*;
import java.util.concurrent.ConcurrentHashMap;

/**
 * 统一接入接口，使用反射调用其他接口
 */
@RestController
@ConditionalOnMissingBean(name = "easyapiUnifiedAccessController")
@RequestMapping("/easyapi/doc/unified")
public class UnifiedAccessController {

    private static final Map<String,Object> emptyObject = new HashMap<>();
    private static final List<?> emptyList = Collections.emptyList();
    @Resource(name = "easyapiModuleController")
    private ModuleController moduleController;
    @Resource(name = "easyapiProjectController")
    private ProjectController projectController;
    @Resource(name = "easyapiSimpleApidocController")
    private SimpleApidocController simpleApidocController;
    @Resource(name = "easyapiUnitController")
    private UnitController unitController;
    @Resource(name = "easyapiUserController")
    private UserController userController;

    private final ProjectService projectService = new ProjectService();

    private final StaticDocCreate staticDocCreate = new StaticDocCreate();

    //缓存静态接口文档
    private static final Map<Long,byte[]> docs = new ConcurrentHashMap<>();

    @GetMapping("/export")
    public void export(HttpServletResponse response,Long projectId) throws IOException {
        DBProjectEntity project = projectService.getById(projectId);
        if(docs.get(projectId) == null){
            docs.put(projectId,staticDocCreate.export(project));
        }
        response.setContentType("application/octet-stream");
        response.setHeader("Content-disposition", "attachment;filename=" + URLEncoder.encode(project.getProjectName() + "-apidoc.zip", "utf-8"));
        response.getOutputStream().write(docs.get(projectId));
    }

    @RequestMapping("/mock")
    public Object mock(String path,String tag){
        return simpleApidocController.mock(path,tag);
    }

    @GetMapping("/get")
    public ResponseBody get(String text){
        UnifiedAccessDto dto;
        try {
            dto = JsonUtil.jsonToBean(StringUtil.UrlDecode(text), UnifiedAccessDto.class);
        }catch (Exception e) {
            return ResponseBody.error("请求参数格式错误");
        }
        return post(dto);
    }

    @PostMapping("/post")
    public ResponseBody post(@RequestBody UnifiedAccessDto dto){
        if(dto == null){
            return ResponseBody.error("参数缺失");
        }
        if(StringUtil.isEmpty(dto.getApi())){
            return ResponseBody.error("未提交控制器参数");
        }
        ChoosController cc = choosController(dto.getApi());
        if(cc == null){
            return ResponseBody.error("控制器不存在");
        }
        CurrentSession.getRequest().getSession().setAttribute(CurrentSession.projectId, dto.getProjectId());
        CurrentSession.getRequest().getSession().setAttribute(CurrentSession.moduleId, dto.getModuleId());
        //执行控制器方法
        Class<?> controllerClass = cc.getController().getClass();
        Method[] methods = controllerClass.getMethods();
        Method method = null;
        for (Method m : methods) {
            if(m.getName().equals(cc.getMethodName())){
                method = m;
                break;
            }
        }
        if(method == null){
            return ResponseBody.error("控制器方法不存在");
        }
//        checkAuth(dto.getApi(),method);
        try {
            //检查权限
            if(!"user::login".equals(dto.getApi()) && !dto.getApi().startsWith("project::")){
                CurrentSession.getCurrentUser();
            }
            Object result;
            if(!StringUtil.isEmpty(dto.getBody())){
                Class<?> parameterType = method.getParameterTypes()[0];
                result = method.invoke(cc.getController(), JsonUtil.jsonToBean(dto.getBody(), parameterType));
            }else{
                result = method.invoke(cc.getController());
            }
            return postRequest(result, method);
        }catch (Exception e) {
            Throwable ex = e;
            if(e instanceof InvocationTargetException){
                ex = ((InvocationTargetException) e).getTargetException();
            }
            if(ex instanceof ApidocException){
                ApidocException ae = (ApidocException) ex;
                return ResponseBody.error(ae.getCode(), ae.getMessage());
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            PrintStream print = new PrintStream(out);
            ex.printStackTrace(print);
            return ResponseBody.error(new String(out.toByteArray()));
        }
    }


    /**
     * 返回包装
     * @param result    接口返回结果
     * @param method    接口方法
     * @return  最终包装
     */
    private ResponseBody postRequest(Object result,Method method){
        if(result instanceof ResponseBody){
            return (ResponseBody) result;
        }
        if(Collection.class.isAssignableFrom(method.getReturnType())){
            //集合类型返回
            return ResponseBody.success(result==null?emptyList:result);
        }
        if (IPage.class.isAssignableFrom(method.getReturnType())){
            IPage<?> iPage = (IPage<?>) result;
            ResponseBody body = new ResponseBody();
            body.setData(iPage.getRecords());
            body.setCode(200);
            Page page = new Page();
            page.setShowCount(Long.valueOf(iPage.getSize()).intValue());
            page.setCurrentPage(Long.valueOf(iPage.getCurrent()).intValue());
            page.setTotalResult(Long.valueOf(iPage.getTotal()).intValue());
            page.setTotalPage(Long.valueOf(iPage.getPages()).intValue());
            body.setPage(page);
            return body;
        }
        return ResponseBody.success(result==null?emptyObject:result);
    }

    /**
     * 选择控制器
     * @param api   请求的控制器和接口缩写
     * @return  控制器
     */
    private ChoosController choosController(String api){
        if(StringUtil.isEmpty(api)){
            return null;
        }
        api = StringUtil.UrlDecode(api);
        String[] split = api.split("::");
        if(split.length != 2){
            return null;
        }
        ChoosController cc = new ChoosController();
        switch (split[0]){
            //complex、module、project、role、simple、unit、user
//            case "complex":{
//                cc.setController(complexApidocController);
//                break;
//            }
            case "module":{
                cc.setController(moduleController);
                break;
            }
            case "project":{
                cc.setController(projectController);
                break;
            }
            case "simple":{
                cc.setController(simpleApidocController);
                break;
            }
            case "unit":{
                cc.setController(unitController);
                break;
            }
            case "user":{
                cc.setController(userController);
                break;
            }
            default:{
                return null;
            }
        }
        cc.setMethodName(split[1]);
        return cc;
    }

    /**
     * 判断是否可以访问该接口
     * @param method    接口方法
     */
    private void checkAuth(String api,Method method){
        if("user::login".equals(api)){
            return ;
        }
        AccessAuth accessAuth = method.getDeclaredAnnotation(AccessAuth.class);
        AssertUtil.isNull(accessAuth, "该接口未开通访问权限");
        AssertUtil.isTrue(accessAuth.code()<=0, "该接口未开通访问权限");
        AssertUtil.isTrue(!CurrentSession.getCurrentUser().getProjectIds().containsKey(CurrentSession.getCurrentProjectId()), "您没有该项目访问权限");
        List<Integer> authCodes = CurrentSession.getCurrentUser().getProjectIds().get(CurrentSession.getCurrentProjectId());
        AssertUtil.isTrue(!authCodes.contains(accessAuth.code()), "您没有该接口访问权限");
    }

    static class ChoosController{
        private Object controller;
        private String methodName;

        public Object getController() {
            return controller;
        }

        public void setController(Object controller) {
            this.controller = controller;
        }

        public String getMethodName() {
            return methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }
    }
}
