package cn.easyutil.easyapi.interview.controller;

import cn.easyutil.easyapi.content.ProjectContext;
import cn.easyutil.easyapi.entity.common.AccessAuth;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.common.DocParamEntity;
import cn.easyutil.easyapi.entity.db.auth.DBProjectEntity;
import cn.easyutil.easyapi.entity.db.auth.DBUserEntity;
import cn.easyutil.easyapi.entity.db.doc.*;
import cn.easyutil.easyapi.handler.operator.provide.MockReaderProvider;
import cn.easyutil.easyapi.interview.dto.*;
import cn.easyutil.easyapi.interview.session.CurrentSession;
import cn.easyutil.easyapi.interview.vo.FindControllerAndInterfaceVo;
import cn.easyutil.easyapi.interview.vo.InterfaceInfoVo;
import cn.easyutil.easyapi.logic.condition.MockProcess2;
import cn.easyutil.easyapi.mybatis.service.*;
import cn.easyutil.easyapi.util.AssertUtil;
import cn.easyutil.easyapi.util.JsonUtil;
import cn.easyutil.easyapi.util.StringUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.*;
import java.util.stream.Collectors;

/**
 * 接口文档接口(简单接口，不需要鉴权)
 *
 * @author spc
 *
 */
@RestController
@ConditionalOnMissingBean(name = "easyapiSimpleApidocController")
@RequestMapping("/easyapi/doc/simple")
public class SimpleApidocController {

    private final ControllerService controllerService = new ControllerService();

    private final InterfaceService interfaceService = new InterfaceService();

    private final InterfaceParamService interfaceParamService = new InterfaceParamService();

    private final HostService hostService = new HostService();

    private final EnvService envService = new EnvService();

    private final HeaderService headerService = new HeaderService();

    private final ScriptService scriptService = new ScriptService();

    private final ArticleService articleService = new ArticleService();

    private final OutPackageService outPackageService = new OutPackageService();

    private final ProjectService projectService = new ProjectService();

    private final UserService userService = new UserService();

    @ApidocComment("获取接口控制器列表")
    @PostMapping("/getControllers")
    @AccessAuth(code = 1000)
    public List<FindControllerAndInterfaceVo> getControllers(@RequestBody(required = false) SearchDto dto){
        if(dto == null){
            dto = new SearchDto();
        }
        //key为controllerId，val为interfaceId集合
        Map<Long,List<Long>> controllerAndInterfaceMap = new HashMap<>();
        List<DBModuleControllerEntity> list = controllerService.list(
                Wrappers.lambdaQuery(DBModuleControllerEntity.class)
                        .select(DBModuleControllerEntity::getId)
                        .eq(DBModuleControllerEntity::getShow,1)
                        .eq(DBModuleControllerEntity::getProjectId,dto.getId())
                        .like(!StringUtil.isEmpty(dto.getSearch()),DBModuleControllerEntity::getSearchTags, dto.getSearch())
        );
        if(list != null){
            controllerAndInterfaceMap = list.stream().collect(Collectors.toMap(DBModuleControllerEntity::getId, c -> new ArrayList<>()));
        }
        List<DBModuleInterfaceEntity> inList = interfaceService.list(
                Wrappers.lambdaQuery(DBModuleInterfaceEntity.class)
                        .select(DBModuleInterfaceEntity::getId,DBModuleInterfaceEntity::getControllerId)
                        .eq(DBModuleInterfaceEntity::getShowType,1)
                        .eq(DBModuleInterfaceEntity::getProjectId,dto.getId())
                        .like(!StringUtil.isEmpty(dto.getSearch()), DBModuleInterfaceEntity::getSearchTags, dto.getSearch())
        );
        List<DBModuleInterfaceEntity> customList = interfaceService.list(
                Wrappers.lambdaQuery(DBModuleInterfaceEntity.class)
                        .select(DBModuleInterfaceEntity::getId, DBModuleInterfaceEntity::getControllerId)
                        .eq(DBModuleInterfaceEntity::getShowType,1)
                        .eq(DBModuleInterfaceEntity::getProjectId,dto.getId())
                        .like(!StringUtil.isEmpty(dto.getSearch()), DBModuleInterfaceEntity::getCustomTags, dto.getSearch())
        );
        final Map<Long,DBModuleInterfaceEntity> inMap = new HashMap<>();
        if(inList == null){
            inList = new ArrayList<>();
        }
        if(customList == null){
            customList = new ArrayList<>();
        }
        inList.addAll(customList);
        inList.forEach(item -> inMap.put(item.getId(),item));
        inList = new ArrayList<>(inMap.values());
        for (DBModuleInterfaceEntity inEntity : inList) {
            Long inId = inEntity.getId();
            Long controllerId = inEntity.getControllerId();
            controllerAndInterfaceMap.computeIfAbsent(controllerId, k -> new ArrayList<>());
            controllerAndInterfaceMap.get(controllerId).add(inId);
        }
        if(controllerAndInterfaceMap.isEmpty()){
            return null;
        }
        List<FindControllerAndInterfaceVo> vos = new ArrayList<>();
        List<DBModuleControllerEntity> controllers = controllerService.list(
                Wrappers.lambdaQuery(DBModuleControllerEntity.class)
                        .in(DBModuleControllerEntity::getId, controllerAndInterfaceMap.keySet())
                        .orderByAsc(DBModuleControllerEntity::getSort)
                        .orderByAsc(DBModuleControllerEntity::getPinyin)
        );
        for (DBModuleControllerEntity controller : controllers) {
            FindControllerAndInterfaceVo vo = new FindControllerAndInterfaceVo();
            BeanUtils.copyProperties(controller,vo);
            List<Long> inIds = controllerAndInterfaceMap.get(controller.getId());
            if(inIds.isEmpty()){
                vos.add(vo);
                continue;
            }
            List<DBModuleInterfaceEntity> children = interfaceService.list(
                    Wrappers.lambdaQuery(DBModuleInterfaceEntity.class)
                            .in(DBModuleInterfaceEntity::getId, inIds)
                            .orderByAsc(DBModuleInterfaceEntity::getSort)
                            .orderByAsc(DBModuleInterfaceEntity::getPinyin)
            );
            vo.setChildren(Optional.ofNullable(children).orElse(Collections.emptyList()));
            vos.add(vo);
        }
        return vos;
    }

    @ApidocComment("修改控制器信息")
    @PostMapping("/updateControllerInfo")
    @AccessAuth(code = 1000)
    public void updateControllerInfo(@RequestBody DBModuleControllerEntity entity){
        AssertUtil.isNull(entity.getId(), "控制器id不能为空");
        controllerService.updateById(entity);
        DBModuleControllerEntity query = controllerService.getById(entity.getId());
        query.setSearchTags(DBModuleControllerEntity.buildSearchTag(query));
        controllerService.updateById(query);
    }

    @ApidocComment("删除控制器信息")
    @PostMapping("/delController")
    @AccessAuth(code = 1000)
    public void delController(@RequestBody IdDto dto){
        controllerService.removeById(dto.getId());
    }

    @ApidocComment("查询接口列表")
    @PostMapping("/selectInterfaces")
    @AccessAuth(code = 1000)
    public List<DBModuleInterfaceEntity> selectInterfaces(@RequestBody(required = false) SelectInterfacesDto dto){
        DBModuleInterfaceEntity entity = new DBModuleInterfaceEntity();
        entity.setModuleId(CurrentSession.getCurrentModuleId());
        return interfaceService.list(
                Wrappers.lambdaQuery(entity)
                        .like(!StringUtil.isEmpty(dto.getSearch()), DBModuleInterfaceEntity::getSearchTags, dto.getSearch())
                        .eq(dto.getControllerId() != null, DBModuleInterfaceEntity::getControllerId, dto.getControllerId())
                        .orderByAsc(DBModuleInterfaceEntity::getSort)
                        .orderByAsc(DBModuleInterfaceEntity::getPinyin)

        );
    }

    @ApidocComment("修改接口信息")
    @PostMapping("/updateInterfaces")
    @AccessAuth(code = 1000)
    public void updateInterfaces(@RequestBody InterfaceInfoVo vo){
        if(vo.getInfo() != null){
            AssertUtil.isNull(vo.getInfo().getId(), "接口id不能为空");
            interfaceService.updateById(vo.getInfo());
            DBModuleInterfaceEntity query = interfaceService.getById(vo.getInfo().getId());
            query.setSearchTags(DBModuleInterfaceEntity.buildSearchTag(query));
            interfaceService.updateById(query);
        }
        if(vo.getParams() != null){
            AssertUtil.isNull(vo.getParams().getId(), "接口详情id不能为空");
            DBInterfaceParamEntity entity = vo.getParams();
            entity.setInterfaceId(null);
            interfaceParamService.updateById(entity);
        }

    }

    @ApidocComment("根据接口id获取接口详情信息")
    @PostMapping("/interfaceInfo")
    @AccessAuth(code = 1000)
    public InterfaceInfoVo interfaceInfo(@RequestBody IdDto dto){
        DBModuleInterfaceEntity info = interfaceService.getById(dto.getId());
        AssertUtil.isNull(info, "接口不存在");
        DBInterfaceParamEntity query = new DBInterfaceParamEntity();
        query.setInterfaceId(info.getId());
        DBInterfaceParamEntity params = interfaceParamService.getOne(Wrappers.lambdaQuery(query),false);
        String requestParamJson = params.getRequestParamJson();
        String responseParamJson = params.getResponseParamJson();
        MockReaderProvider operator = ProjectContext.mockTemplateOperator;
        MockProcess2 mocker = MockProcess2.with(operator);
        mocker.setMockArraySize(ProjectContext.allConfiguration.getConfiguration().getMockArraySize());
        if(!StringUtil.isEmpty(requestParamJson)){
            List<DocParamEntity> mockParams = JsonUtil.jsonToList(requestParamJson, DocParamEntity.class);
            Object mock = mocker.mockByApiParams(mockParams);
            params.setRequestMock(JsonUtil.beanToJson(mock));
            params.setRequestParamJson(JsonUtil.beanToJson(mockParams));
        }
        if(!StringUtil.isEmpty(responseParamJson)){
            List<DocParamEntity> mockParams = JsonUtil.jsonToList(responseParamJson, DocParamEntity.class);
            Object mock = mocker.mockByApiParams(mockParams);
            params.setResponseMock(JsonUtil.beanToJson(mock));
            params.setResponseParamJson(JsonUtil.beanToJson(mockParams));
        }
        InterfaceInfoVo vo = new InterfaceInfoVo();
        vo.setInfo(info);
        vo.setParams(params);
        return vo;
    }

    @ApidocComment("删除接口信息")
    @PostMapping("/delInterfaces")
    @AccessAuth(code = 1000)
    public void delInterfaces(@RequestBody IdDto dto){
        interfaceService.removeById(dto.getId());
    }

    @ApidocComment("获取脚本列表")
    @PostMapping("/getScripts")
    @AccessAuth(code = 1000)
    public List<DBModuleScriptEntity> getScripts(@RequestBody DBModuleScriptEntity query){
        Long userId = CurrentSession.getCurrentUser().getId();
        List<DBModuleScriptEntity> self = scriptService.list(
                Wrappers.lambdaQuery(DBModuleScriptEntity.class)
//                        .eq(DBModuleScriptEntity::getProjectId, query.getProjectId())
                        .eq(DBModuleScriptEntity::getUserId, userId)
                        .eq(query.getLocation() != null, DBModuleScriptEntity::getLocation, query.getLocation())
                        .orderByAsc(DBModuleScriptEntity::getSort)
        );
        DBModuleScriptEntity queryGlobal = new DBModuleScriptEntity();
        queryGlobal.setLocation(query.getLocation());
        queryGlobal.setType(1);
        List<DBModuleScriptEntity> global = scriptService.list(Wrappers.lambdaQuery(queryGlobal));
        return mergin(global,self);
    }

    @ApidocComment("添加全局脚本")
    @PostMapping("/addScript")
    @AccessAuth(code = 1000)
    public void addScript(@RequestBody DBModuleScriptEntity entity){
        Long currentModuleId = CurrentSession.getCurrentModuleId();
        Long userId = CurrentSession.getCurrentUser().getId();
        entity.setModuleId(currentModuleId);
        entity.setUserId(userId);
        scriptService.save(entity);
    }

    @ApidocComment("修改全局脚本")
    @PostMapping("/updateScript")
    @AccessAuth(code = 1000)
    public void updateScript(@RequestBody DBModuleScriptEntity entity){
        scriptService.updateById(entity);
    }

    @ApidocComment("删除全局脚本")
    @PostMapping("/delScript")
    @AccessAuth(code = 1000)
    public void delScript(@RequestBody IdDto dto){
        scriptService.removeById(dto.getId());
    }

    @ApidocComment("获取文章列表")
    @PostMapping("/getArticles")
    @AccessAuth(code = 1000)
    public List<DBArticleEntity> getArticles(){
        return articleService.list();
    }

    @ApidocComment("获取上次打开的接口集合")
    @PostMapping("/getLastOpendInterfaces")
    @AccessAuth(code = 1000)
    public List<DBModuleInterfaceEntity> getLastOpendInterfaces(@RequestBody IdDto dto){
        String lastOpendInterfaceIds = CurrentSession.getCurrentUser().getLastOpendInterfaceIds();
        if(StringUtil.isEmpty(lastOpendInterfaceIds)){
            return null;
        }
        JSONObject map = JSONObject.parseObject(lastOpendInterfaceIds);
        if(!map.containsKey(dto.getId().toString())){
            return null;
        }
        JSONArray ids = map.getJSONArray(dto.getId().toString());
        if(ids==null || ids.isEmpty()){
            return null;
        }
        List<DBModuleInterfaceEntity> interfaces = interfaceService.list(
                Wrappers.lambdaQuery(DBModuleInterfaceEntity.class)
                        .in(DBModuleInterfaceEntity::getId, ids)
        );
        List<DBModuleInterfaceEntity> result = new ArrayList<>();
        for (Object id : ids) {
            for (DBModuleInterfaceEntity entity : interfaces) {
                if(entity.getId().toString().equals(id.toString())){
                    result.add(entity);
                }
            }
        }
        return result;
    }

    @ApidocComment("保存已打开的接口集合")
    @PostMapping("/setOpendInterfaceIds")
    @AccessAuth(code = 1000)
    public void setOpendInterfaceIds(@RequestBody IdListDto dto){
        List<Long> ids = dto.getIds();
        DBUserEntity user = userService.getById(CurrentSession.getCurrentUser().getId());
        String lastOpendInterfaceIds = user.getLastOpendInterfaceIds();
        if(StringUtil.isEmpty(lastOpendInterfaceIds)){
            lastOpendInterfaceIds = "{}";
        }
        Map<String, Object> map = JsonUtil.jsonToMap(lastOpendInterfaceIds);
        map.put(dto.getProjectId().toString(),ids);
        user.setLastOpendInterfaceIds(JsonUtil.beanToJson(map));
        userService.updateById(user);
        CurrentSession.getCurrentUser().setLastOpendInterfaceIds(JsonUtil.beanToJson(map));
    }

    @ApidocComment("获取请求环境列表")
    @PostMapping("/getHosts")
    @AccessAuth(code = 1000)
    public List<DBModuleHostEntity> getHosts(){
        DBModuleHostEntity entity = new DBModuleHostEntity();
//        Long currentModuleId = CurrentSession.getCurrentModuleId();
//        entity.setModuleId(currentModuleId);
        List<DBModuleHostEntity> list = hostService.list(Wrappers.lambdaQuery(entity));
        list.sort(Comparator.comparing(DBModuleHostEntity::getCanDelete));
        return list;
    }

    @ApidocComment("添加请求环境")
    @PostMapping("/addHost")
    @AccessAuth(code = 1000)
    public void addHost(@RequestBody DBModuleHostEntity hostEntity){
        hostService.save(hostEntity);
    }

    @ApidocComment("修改请求环境")
    @PostMapping("/updateHost")
    @AccessAuth(code = 1000)
    public void updateHost(@RequestBody DBModuleHostEntity hostEntity){
        AssertUtil.isNull(hostEntity.getId(), "环境id不能为空");
        hostService.updateById(hostEntity);
    }

    @ApidocComment("删除请求环境")
    @PostMapping("/delHost")
    @AccessAuth(code = 1000)
    public void delHost(@RequestBody IdDto dto){
        hostService.removeById(dto.getId());
    }

    @ApidocComment("获取全部环境变量")
    @PostMapping("/getEnvsgs")
    @AccessAuth(code = 1000)
    public List<DBMouduleEnvEntity> getEnvsgs(@RequestBody BaseDbEntity dto){
        DBMouduleEnvEntity entity = new DBMouduleEnvEntity();
        entity.setUserId(CurrentSession.getCurrentUser().getId());
//        entity.setProjectId(dto.getProjectId());
        //自身定义的环境变量
        List<DBMouduleEnvEntity> self = envService.list(Wrappers.lambdaQuery(entity));
        entity.setUserId(null);
        entity.setType(1);
        List<DBMouduleEnvEntity> global = envService.list(Wrappers.lambdaQuery(entity));
        return mergin(global,self);
    }

    @ApidocComment("添加环境变量")
    @PostMapping("/addEnv")
    @AccessAuth(code = 1000)
    public void addEnv(@RequestBody DBMouduleEnvEntity env){
        env.setUserId(CurrentSession.getCurrentUser().getId());
        DBMouduleEnvEntity query = new DBMouduleEnvEntity();
        query.setUserId(CurrentSession.getCurrentUser().getId());
        query.setModuleId(CurrentSession.getCurrentModuleId());
        query.setKey(env.getKey());
        query = envService.getOne(Wrappers.lambdaQuery(query),false);
        if(query != null){
            envService.removeById(query.getId());
        }
        envService.save(env);
    }

    @ApidocComment("修改环境变量")
    @PostMapping("/updateEnv")
    @AccessAuth(code = 1000)
    public void updateEnv(@RequestBody DBMouduleEnvEntity env){
        AssertUtil.isNull(env.getId(), "环境变量id不能为空");
        DBMouduleEnvEntity query = new DBMouduleEnvEntity();
        query.setUserId(CurrentSession.getCurrentUser().getId());
        query.setModuleId(CurrentSession.getCurrentModuleId());
        query.setKey(env.getKey());
        query = envService.getOne(Wrappers.lambdaQuery(query),false);
        if(query != null){
            envService.removeById(query.getId());
        }
        envService.save(env);
    }

    @ApidocComment("删除环境变量")
    @PostMapping("/delEnv")
    @AccessAuth(code = 1000)
    public void delEnv(@RequestBody IdDto dto){
        envService.removeById(dto.getId());
    }

    @ApidocComment("获取参数的外包装列表")
    @PostMapping("/getOutPackages")
    @AccessAuth(code = 1000)
    public List<DBModuleOutPackageEntity> getOutPackages(@RequestBody GetOutPackagesDto dto){
        DBModuleOutPackageEntity entity = new DBModuleOutPackageEntity();
        entity.setType(dto.getType());
//        entity.setProjectId(dto.getProjectId());
        return outPackageService.list(Wrappers.lambdaQuery(entity));
    }

    @ApidocComment("新增参数的外包装")
    @PostMapping("/addOutPackages")
    @AccessAuth(code = 1000)
    public void addOutPackages(@RequestBody DBModuleOutPackageEntity entity){
//        Long currentModuleId = CurrentSession.getCurrentModuleId();
//        entity.setModuleId(currentModuleId);
        if(entity.getDefaultStatus() == 1){
            DBModuleOutPackageEntity query = new DBModuleOutPackageEntity();
//            query.setModuleId(currentModuleId);
            query.setDefaultStatus(entity.getDefaultStatus());
            query.setType(entity.getType());
            query = outPackageService.getOne(Wrappers.lambdaQuery(query),false);
            AssertUtil.isTrue(query!=null, "外包装只允许有一个包装值");
        }
        String key = entity.getKey();
        DBModuleOutPackageEntity find = new DBModuleOutPackageEntity();
        find.setKey(key);
        find.setType(entity.getType());
        find = outPackageService.getOne(Wrappers.lambdaQuery(find),false);
        if(find != null){
            outPackageService.removeById(find.getId());
        }
        outPackageService.save(entity);
    }

    @ApidocComment("修改参数的外包装")
    @PostMapping("/updateOutPackages")
    @AccessAuth(code = 1000)
    public void updateOutPackages(@RequestBody DBModuleOutPackageEntity entity){
        AssertUtil.isNull(entity.getId(), "外包装id不能为空");
        DBModuleOutPackageEntity query = outPackageService.getById(entity.getId());
        if(entity.getDefaultStatus()!=null && entity.getDefaultStatus()==1 && !entity.getDefaultStatus().equals(query.getDefaultStatus())){
//            Long currentModuleId = CurrentSession.getCurrentModuleId();
            DBModuleOutPackageEntity find = new DBModuleOutPackageEntity();
//            find.setModuleId(currentModuleId);
            find.setDefaultStatus(entity.getDefaultStatus());
            find.setType(entity.getType());
            find = outPackageService.getOne(Wrappers.lambdaQuery(query),false);
            AssertUtil.isTrue(find!=null, "外包装只允许有一个包装值");
        }
        String key = entity.getKey();
        DBModuleOutPackageEntity find = new DBModuleOutPackageEntity();
        find.setKey(key);
        find.setType(entity.getType());
        find = outPackageService.getOne(Wrappers.lambdaQuery(query),false);
        if(find!=null && !find.getId().equals(entity.getId())){
            outPackageService.removeById(find.getId());
        }
        outPackageService.updateById(entity);
    }

    @ApidocComment("删除参数的外包装")
    @PostMapping("/delOutPackages")
    @AccessAuth(code = 1000)
    public void delOutPackages(@RequestBody IdDto dto){
        outPackageService.removeById(dto.getId());
    }

    @ApidocComment("模拟请求")
    @PostMapping("/mock")
    @AccessAuth(code = 1000)
    public Object mock(String path,String tag){
        DBModuleInterfaceEntity interfaceEntity = new DBModuleInterfaceEntity();
        if(!StringUtil.isEmpty(path)){
            interfaceEntity.setRequestUrl(path);
        }else{
            interfaceEntity.setInterfaceUnique(tag);
        }
        interfaceEntity = interfaceService.getOne(Wrappers.lambdaQuery(interfaceEntity),false);
        AssertUtil.isNull(interfaceEntity,"未知接口");
        DBInterfaceParamEntity entity = new DBInterfaceParamEntity();
        entity.setInterfaceId(interfaceEntity.getId());
        entity = interfaceParamService.getOne(Wrappers.lambdaQuery(entity),false);
        AssertUtil.isNull(entity,"未知接口");
        MockReaderProvider operator = ProjectContext.mockTemplateOperator;
        MockProcess2 mocker = MockProcess2.with(operator);
        mocker.setMockArraySize(ProjectContext.allConfiguration.getConfiguration().getMockArraySize());
        Object contentMock = mocker.mockByApiParams(entity.getResponseParamJson());

        DBProjectEntity project = new DBProjectEntity();
        project.setId(CurrentSession.getCurrentProjectId());
        project = projectService.getOne(Wrappers.lambdaQuery(project),false);
        if(project==null || project.getEnableResPackage()==0){
            return contentMock;
        }
        if(interfaceEntity.getEnableResPackage() == 0){
            return contentMock;
        }

        DBModuleOutPackageEntity packages = new DBModuleOutPackageEntity();
        packages.setType(1);
        List<DBModuleOutPackageEntity> resPackages = outPackageService.list(Wrappers.lambdaQuery(packages));
        if(resPackages==null || resPackages.isEmpty()){
            return contentMock;
        }

        Map<String,Object> result = new HashMap<>();
        for (DBModuleOutPackageEntity resPackage : resPackages) {
            if(resPackage.getDefaultStatus() == 1){
                result.put(resPackage.getKey(),contentMock);
            }else{
                result.put(resPackage.getKey(),resPackage.getVal());
            }
        }
        return result;
    }

    @ApidocComment("获取全局header")
    @PostMapping("/getHeaders")
    @AccessAuth(code = 1000)
    public List<DBModuleHeaderEntity> getHeaders(@RequestBody BaseDbEntity dto){
        DBModuleHeaderEntity entity = new DBModuleHeaderEntity();
        entity.setUserId(CurrentSession.getCurrentUser().getId());
//        entity.setProjectId(dto.getProjectId());
        //自身定义的header
        List<DBModuleHeaderEntity> self = headerService.list(Wrappers.lambdaQuery(entity));
        entity.setUserId(null);
        entity.setType(1);
        //获取全局的header
        List<DBModuleHeaderEntity> gloabel = headerService.list(Wrappers.lambdaQuery(entity));
        return mergin(self,gloabel);
    }

    @ApidocComment("添加header")
    @PostMapping("/addHeader")
    @AccessAuth(code = 1000)
    public void addHeader(@RequestBody DBModuleHeaderEntity entity){
        entity.setUserId(CurrentSession.getCurrentUser().getId());
        entity.setModuleId(CurrentSession.getCurrentModuleId());
        AssertUtil.isEmpty(entity.getKey(),"key不能为空");
        AssertUtil.isEmpty(entity.getVal(),"val不能为空");
        DBModuleHeaderEntity query = new DBModuleHeaderEntity();
        query.setUserId(CurrentSession.getCurrentUser().getId());
        query.setModuleId(CurrentSession.getCurrentModuleId());
        query.setKey(entity.getKey());
        query = headerService.getOne(Wrappers.lambdaQuery(query));
        if(query != null){
            headerService.removeById(query.getId());
        }
        headerService.save(entity);
    }

    @ApidocComment("删除header")
    @PostMapping("/delHeader")
    @AccessAuth(code = 1000)
    public void delHeader(@RequestBody IdDto dto){
        headerService.removeById(dto.getId());
    }

    @ApidocComment("修改header")
    @PostMapping("/updateHeader")
    @AccessAuth(code = 1000)
    public void updateHeader(@RequestBody DBModuleHeaderEntity entity){
        AssertUtil.isNull(entity.getId(),"id不能为空");
        DBModuleHeaderEntity query = new DBModuleHeaderEntity();
        query.setUserId(CurrentSession.getCurrentUser().getId());
        query.setModuleId(CurrentSession.getCurrentModuleId());
        query.setKey(entity.getKey());
        query = headerService.getOne(Wrappers.lambdaQuery(query),false);
        if(query!=null && !query.getId().equals(entity.getId())){
            headerService.removeById(query.getId());
        }
        headerService.updateById(entity);
    }

    /**
     * 合并
     */
    private <T extends BaseDbEntity> List<T> mergin(List<T> li1,List<T> li2){
        if(li1 == null){
            li1 = new ArrayList<>();
        }
        if(li2 == null){
            li2 = new ArrayList<>();
        }
        //利用set去重
        Set<Long> ids = new HashSet<>();
        List<T> result = new ArrayList<>();
        li1.addAll(li2);
        for (T t : li1) {
            boolean add = ids.add(t.getId());
            if(add){
                result.add(t);
            }
        }
        return result;
    }
}
