package cn.easyutil.easyapi.handler.reader.responses;

import cn.easyutil.easyapi.handler.BaseHandlerChain;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ResponseExtra;
import cn.easyutil.easyapi.logic.creator.MethodParam;

import java.util.ArrayList;
import java.util.List;

public class ResponseReaderHandler extends BaseHandlerChain {

    //字段说明
    private final static List<HandlerChain<ResponseExtra,String>> descriptionHandlers = new ArrayList<>();
    //忽略
    private final static List<HandlerChain<ResponseExtra,Boolean>> ignoreHandlers = new ArrayList<>();
    //mock模板
    private final static List<HandlerChain<ResponseExtra,String>> mockTemplateHandlers = new ArrayList<>();
    //是否必填
    private final static List<HandlerChain<ResponseExtra,Boolean>> requiredHandlers = new ArrayList<>();
    //是否显示
    private final static List<HandlerChain<ResponseExtra,Boolean>> showHandlers = new ArrayList<>();
    //字段对应的type
    private final static List<HandlerChain<ResponseExtra,List<MethodParam>>> returnTypeHandlers = new ArrayList<>();

    static {
        new DefaultResponseReaderHandler().addDefault();
    }

    public static void addDescriptionHandlers(HandlerChain<ResponseExtra,String> handler) {
        addChain(descriptionHandlers,handler);
    }

    public static void addIgnoreHandlers(HandlerChain<ResponseExtra,Boolean> handler) {
        addChain(ignoreHandlers,handler);
    }

    public static void addMockTemplateHandlers(HandlerChain<ResponseExtra,String> handler) {
        addChain(mockTemplateHandlers,handler);
    }

    public static void addRequiredHandlers(HandlerChain<ResponseExtra,Boolean> handler) {
        addChain(requiredHandlers,handler);
    }

    public static void addShowHandlers(HandlerChain<ResponseExtra,Boolean> handler) {
        addChain(showHandlers,handler);
    }

    public static void addTypeHandlers(HandlerChain<ResponseExtra,List<MethodParam>> handler) {
        addChain(returnTypeHandlers,handler);
    }

    public static List<HandlerChain<ResponseExtra,String>> getDescriptionHandlers() {
        return descriptionHandlers;
    }

    public static List<HandlerChain<ResponseExtra,Boolean>> getIgnoreHandlers() {
        return ignoreHandlers;
    }

    public static List<HandlerChain<ResponseExtra,String>> getMockTemplateHandlers() {
        return mockTemplateHandlers;
    }

    public static List<HandlerChain<ResponseExtra,Boolean>> getRequiredHandlers() {
        return requiredHandlers;
    }

    public static List<HandlerChain<ResponseExtra,Boolean>> getShowHandlers() {
        return showHandlers;
    }

    public static List<HandlerChain<ResponseExtra,List<MethodParam>>> getTypeHandlers() {
        return returnTypeHandlers;
    }
}
