package cn.easyutil.easyapi.handler.reader.requests.model;

import cn.easyutil.easyapi.util.ApidocCommentUtil;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.RequestExtra;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import cn.easyutil.easyapi.util.StringUtil;

public class RequestDescriptionCommentReader extends HandlerChain<RequestExtra,String> {

    @Override
    public String resolve(RequestExtra extra, String transfer) {
        if(transfer != null){
            return nextHandler().resolve(extra, transfer);
        }
        MethodComment methodComment = extra.getInterfaceExtra().getMethodComment();
        if(methodComment==null || !StringUtil.isEmpty(transfer)){
            return nextHandler().resolve(extra, transfer);
        }
        String parameterName = extra.getParameterName();
        if(methodComment.getParameter(parameterName) == null){
            return nextHandler().resolve(extra, transfer);
        }
        String comment = methodComment.getParameter(parameterName).getComment();
        String commentValue = ApidocCommentUtil.getCommentValue(comment, null);
        if(!StringUtil.isEmpty(commentValue)){
            return nextHandler().resolve(extra, commentValue);
        }
        return nextHandler().resolve(extra, ApidocCommentUtil.clearComment(methodComment.getParameter(parameterName).getComment()));
    }
}
