package cn.easyutil.easyapi.handler.reader.requests;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.BaseHandlerChain;
import cn.easyutil.easyapi.handler.extra.RequestExtra;
import cn.easyutil.easyapi.logic.creator.MethodParam;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;

public class RequestReaderHandler  extends BaseHandlerChain {

    //参数校验
    private final static List<HandlerChain<RequestExtra,List<String>>> conditionHandlers = new ArrayList<>();
    //字段说明
    private final static List<HandlerChain<RequestExtra,String>> descriptionHandlers = new ArrayList<>();
    //忽略
    private final static List<HandlerChain<RequestExtra,Boolean>> ignoreHandlers = new ArrayList<>();
    //mock模板
    private final static List<HandlerChain<RequestExtra,String>> mockTemplateHandlers = new ArrayList<>();
    //字段名称
    private final static List<HandlerChain<RequestExtra,String>> nameHandlers = new ArrayList<>();
    //字段实际java类型，如果是对象，此处为对象的多个属性
    private final static List<HandlerChain<RequestExtra,List<MethodParam>>> paramHandlers = new ArrayList<>();
    //是否必填
    private final static List<HandlerChain<RequestExtra,Boolean>> requiredHandlers = new ArrayList<>();
    //是否显示
    private final static List<HandlerChain<RequestExtra,Boolean>> showHandlers = new ArrayList<>();
    //字段对应的type
    private final static List<HandlerChain<RequestExtra,Type>> typeHandlers = new ArrayList<>();

    static {
        new DefaultRequestReaderHandler().addDefault();
    }

    public static void addConditionHandlers(HandlerChain<RequestExtra,List<String>> handler) {
        addChain(conditionHandlers,handler);
    }

    public static void addDescriptionHandlers(HandlerChain<RequestExtra,String> handler) {
        addChain(descriptionHandlers,handler);
    }

    public static void addIgnoreHandlers(HandlerChain<RequestExtra,Boolean> handler) {
        addChain(ignoreHandlers,handler);
    }

    public static void addMockTemplateHandlers(HandlerChain<RequestExtra,String> handler) {
        addChain(mockTemplateHandlers,handler);
    }

    public static void addNameHandlers(HandlerChain<RequestExtra,String> handler) {
        addChain(nameHandlers,handler);
    }

    public static void addParamHandlers(HandlerChain<RequestExtra,List<MethodParam>> handler) {
        addChain(paramHandlers,handler);
    }

    public static void addRequiredHandlers(HandlerChain<RequestExtra,Boolean> handler) {
        addChain(requiredHandlers,handler);
    }

    public static void addShowHandlers(HandlerChain<RequestExtra,Boolean> handler) {
        addChain(showHandlers,handler);
    }

    public static void addTypeHandlers(HandlerChain<RequestExtra,Type> handler) {
        addChain(typeHandlers,handler);
    }

    public static List<HandlerChain<RequestExtra,List<String>>> getConditionHandlers() {
        return conditionHandlers;
    }

    public static List<HandlerChain<RequestExtra,String>> getDescriptionHandlers() {
        return descriptionHandlers;
    }

    public static List<HandlerChain<RequestExtra,Boolean>> getIgnoreHandlers() {
        return ignoreHandlers;
    }

    public static List<HandlerChain<RequestExtra,String>> getMockTemplateHandlers() {
        return mockTemplateHandlers;
    }

    public static List<HandlerChain<RequestExtra,String>> getNameHandlers() {
        return nameHandlers;
    }

    public static List<HandlerChain<RequestExtra,List<MethodParam>>> getParamHandlers() {
        return paramHandlers;
    }

    public static List<HandlerChain<RequestExtra,Boolean>> getRequiredHandlers() {
        return requiredHandlers;
    }

    public static List<HandlerChain<RequestExtra,Boolean>> getShowHandlers() {
        return showHandlers;
    }

    public static List<HandlerChain<RequestExtra,Type>> getTypeHandlers() {
        return typeHandlers;
    }
}
