package cn.easyutil.easyapi.handler.reader.interfaces.model;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ControllerExtra;
import org.springframework.web.bind.annotation.*;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class InterfacesCommentReader extends HandlerChain<ControllerExtra,List<Method>> {

    @Override
    public List<Method> resolve(ControllerExtra extra, List<Method> transfer) {
        List<Method> result = new ArrayList<>();
        Method[] methods = extra.getControllerClass().getDeclaredMethods();
        for (Method method : methods) {
            Annotation[] ans = method.getDeclaredAnnotations();
            for (Annotation an : ans) {
                if (an instanceof RequestMapping) {
                    result.add(method);
                } else if (an instanceof GetMapping) {
                    result.add(method);
                } else if (an instanceof PostMapping) {
                    result.add(method);
                } else if (an instanceof PutMapping) {
                    result.add(method);
                } else if (an instanceof DeleteMapping) {
                    result.add(method);
                }
            }
        }
        return nextHandler().resolve(extra,result);
    }
}
