package cn.easyutil.easyapi.handler.reader.interfaces.model;

import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.InterfaceExtra;
import cn.easyutil.easyapi.javadoc.reader.CommentDetail;
import cn.easyutil.easyapi.javadoc.reader.MethodComment;
import org.springframework.util.CollectionUtils;

import java.util.Optional;

public class InterfaceIgnoreCommentReader extends HandlerChain<InterfaceExtra,Boolean> {

    @Override
    public Boolean resolve(InterfaceExtra extra, Boolean transfer) {
        if(transfer != null){
            return nextHandler().resolve(extra, transfer);
        }
        MethodComment methodComment = extra.getMethodComment();
        if(methodComment==null || CollectionUtils.isEmpty(methodComment.getCommentDetails())){
            return nextHandler().resolve(extra, transfer);
        }
        Optional<CommentDetail> deprecated = methodComment.getCommentDetails().stream().filter(item -> item.getKey().equals("deprecated")).findFirst();
        if(deprecated.isPresent()){
            return nextHandler().resolve(extra, true);
        }
        return nextHandler().resolve(extra, transfer);
    }
}
