package cn.easyutil.easyapi.handler.reader.interfaces.model;

import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.InterfaceExtra;

import java.lang.reflect.Method;

public class InterfaceIgnoreApiReader extends HandlerChain<InterfaceExtra,Boolean> {

    @Override
    public Boolean resolve(InterfaceExtra extra, Boolean transfer) {
        Method method = extra.getMethod();
        ApidocComment apidocComment = method.getDeclaredAnnotation(ApidocComment.class);
        if(apidocComment != null){
            boolean hidden = apidocComment.hidden();
            if(hidden){
                return nextHandler().resolve(extra, true);
            }
            nextHandler().resolve(extra, apidocComment.ignore());
        }
        return nextHandler().resolve(extra, transfer);
    }
}
