package cn.easyutil.easyapi.handler.reader.controllers.model;

import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ControllerExtra;
import cn.easyutil.easyapi.util.ObjectUtil;

import java.util.Map;

public class ControllerAuthorApiReader extends HandlerChain<ControllerExtra,String> {

    @Override
    public String resolve(ControllerExtra extra, String transfer) {
        Map<String, ApidocComment> classAnnotation = ObjectUtil.getClassAnnotation(extra.getControllerClass(), ApidocComment.class);
        if(classAnnotation.isEmpty()){
            return nextHandler().resolve(extra, transfer);
        }
        ApidocComment next = classAnnotation.entrySet().iterator().next().getValue();
        return nextHandler().resolve(extra, next.author());
    }
}
