package cn.easyutil.easyapi.handler.reader.beans.model;

import cn.easyutil.easyapi.logic.creator.ApiEmptyObj;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ModelFieldExtra;

import java.lang.reflect.Field;
import java.lang.reflect.Type;

public class BeanTypeCommentReader extends HandlerChain<ModelFieldExtra,Type> {

    @Override
    public Type resolve(ModelFieldExtra extra, Type transfer) {
        Field field = extra.getField();
        if(field == null){
            return nextHandler().resolve(extra, transfer);
        }
        Type genericType = field.getGenericType();
        if(genericType.equals(Object.class)){
            return nextHandler().resolve(extra, ApiEmptyObj.class);
        }
        return nextHandler().resolve(extra, genericType);
    }
}
