package cn.easyutil.easyapi.handler.reader.beans.model;

import cn.easyutil.easyapi.util.ApidocCommentUtil;
import cn.easyutil.easyapi.handler.HandlerChain;
import cn.easyutil.easyapi.handler.extra.ModelFieldExtra;
import cn.easyutil.easyapi.util.StringUtil;


public class BeanDescriptionCommentReader extends HandlerChain<ModelFieldExtra,String> {

    @Override
    public String resolve(ModelFieldExtra extra, String transfer) {
        if(extra.getField()!=null && extra.getFieldComment()!=null){
            String comment = extra.getFieldComment().getComment();
            String commentValue = ApidocCommentUtil.getCommentValue(comment, null);
            if(!StringUtil.isEmpty(commentValue)){
                return nextHandler().resolve(extra, commentValue);
            }
            return nextHandler().resolve(extra, ApidocCommentUtil.clearComment(comment));
        }
        return nextHandler().resolve(extra, transfer);
    }
}
