package cn.easyutil.easyapi.entity.db.doc;

import cn.easyutil.easyapi.entity.annotation.DDL;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.common.EasyapiOrigin;
import cn.easyutil.easyapi.util.StringUtil;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import org.apache.commons.codec.Charsets;
import org.apache.ibatis.type.JdbcType;

import java.sql.Blob;

/**
 * 参数类
 */
@TableName("EASYAPI_PARAM")
public class DBParamEntity extends BaseDbEntity {

	@DDL(value = "MODULE_ID",ddl = "`MODULE_ID` bigint(20) DEFAULT NULL COMMENT '模块id'")
	@ApidocComment("模块id")
	private Long moduleId;

	@DDL(value = "UNIQUE",ddl = "`UNIQUE` varchar(255) DEFAULT NULL COMMENT '参数唯一标识'")
	@ApidocComment("参数唯一标识")
	private String unique;

	@DDL(value = "CLASS_NAME",ddl = "`CLASS_NAME` varchar(255) DEFAULT NULL COMMENT '包名+类名'")
 	@ApidocComment("包名+类名")
 	private String className;

	@DDL(value = "NAME",ddl = "`NAME` varchar(255) DEFAULT NULL COMMENT '字段名称'")
 	@ApidocComment("字段名称")
	@EasyapiOrigin
	@TableField("`name`")
 	private String name;

	@DDL(value = "DESCRIPTION",ddl = "`DESCRIPTION` varchar(255) DEFAULT NULL COMMENT '参数说明'")
 	@ApidocComment("字段说明")
	@EasyapiOrigin
 	private String description;

	/**
	 * @see cn.easyutil.easyapi.entity.common.JavaType
	 */
	@DDL(value = "JAVA_TYPE",ddl = "`JAVA_TYPE` int(2) DEFAULT 0 COMMENT '参照javaType'")
 	@ApidocComment("参照javaType")
	@EasyapiOrigin
 	private Integer javaType;

	@DDL(value = "RENEW_TYPE",ddl = "`RENEW_TYPE` int(1) DEFAULT 0 COMMENT '更新策略: 0-覆盖更新  1-增量更新  2-跳过更新'")
	@ApidocComment("更新策略: 0-覆盖更新  1-增量更新  2-跳过更新")
	private Integer renewType;

	@DDL(value = "MOCK_VALUE",ddl = "`MOCK_VALUE` varchar(255) DEFAULT NULL COMMENT '根据template生成的值'")
 	@ApidocComment("根据template生成的值")
	@EasyapiOrigin
 	private String mockValue;

	@DDL(value = "MOCK_TEMPLATE",ddl = "`MOCK_TEMPLATE` varchar(255) DEFAULT NULL COMMENT '原始未被替换的mockvalue的值'")
 	@ApidocComment("原始未被替换的mockvalue的值")
	@EasyapiOrigin
 	private String mockTemplate;

	@DDL(value = "CONDITION_TEMPLATE",ddl = "`CONDITION_TEMPLATE` varchar(255) DEFAULT NULL COMMENT '参数的校验值，多条逗号分隔'")
	@ApidocComment("参数的校验值，多条逗号分隔")
	private String conditionTemplate;

	@DDL(value = "REQUIRED",ddl = "`REQUIRED` int(1) DEFAULT 0 COMMENT '是否必填 0-不必填  1-必填'")
 	@ApidocComment("是否必填 0-不必填  1-必填")
	@EasyapiOrigin
 	private Integer required;

	@DDL(value = "SHOW",ddl = "`SHOW` int(1) DEFAULT 0 COMMENT '是否显示  0-不显示  1-显示'")
 	@ApidocComment("是否显示  0-不显示  1-显示")
	@EasyapiOrigin
	@TableField("`show`")
 	private Integer show;

	@DDL(value = "PARENT_ID",ddl = "`PARENT_ID` bigint(20) DEFAULT NULL COMMENT '父参数id'")
	@ApidocComment("父参数id")
	private Long parentId;

	@DDL(value = "PARENT_CLASS",ddl = "`PARENT_CLASS` varchar(255) DEFAULT NULL COMMENT '父参数类型'")
	@ApidocComment("父参数类型")
	private String parentClass;

	@TableField(exist = false)
	private String source;

	@DDL(value = "SOURCE_BYTES",type = Blob.class,ddl = "`SOURCE_BYTES` BLOB DEFAULT NULL COMMENT '源代码'")
	@ApidocComment("源代码")
	@TableField(jdbcType = JdbcType.BLOB)
	private byte[] sourceBytes;

	@TableField(exist = false)
	private String origin;

	@DDL(value = "ORIGIN_BYTES",type = Blob.class,ddl = "`ORIGIN_BYTES` BLOB DEFAULT NULL COMMENT '原始数据，用来判断是否被改变的'")
	@ApidocComment("原始数据，用来判断是否被改变的")
	@TableField(jdbcType = JdbcType.BLOB)
	private byte[] originBytes;

	public Long getModuleId() {
		return moduleId;
	}

	public void setModuleId(Long moduleId) {
		this.moduleId = moduleId;
	}

	public String getClassName() {
		return className;
	}

	public void setClassName(String className) {
		this.className = className;
	}

	public String getName() {
		return name;
	}

	public void setName(String name) {
		this.name = name;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public Integer getJavaType() {
		return javaType;
	}

	public void setJavaType(Integer javaType) {
		this.javaType = javaType;
	}

	public String getMockValue() {
		return mockValue;
	}

	public void setMockValue(String mockValue) {
		this.mockValue = mockValue;
	}

	public String getMockTemplate() {
		return mockTemplate;
	}

	public void setMockTemplate(String mockTemplate) {
		this.mockTemplate = mockTemplate;
	}

	public Integer getRequired() {
		return required;
	}

	public void setRequired(Integer required) {
		this.required = required;
	}

	public Integer getShow() {
		return show;
	}

	public void setShow(Integer show) {
		this.show = show;
	}

	public Long getParentId() {
		return parentId;
	}

	public void setParentId(Long parentId) {
		this.parentId = parentId;
	}

	public String getParentClass() {
		return parentClass;
	}

	public void setParentClass(String parentClass) {
		this.parentClass = parentClass;
	}

	public String getConditionTemplate() {
		return conditionTemplate;
	}

	public void setConditionTemplate(String conditionTemplate) {
		this.conditionTemplate = conditionTemplate;
	}

	public Integer getRenewType() {
		return renewType;
	}

	public void setRenewType(Integer renewType) {
		this.renewType = renewType;
	}

	public String getUnique() {
		return unique;
	}

	public void setUnique(String unique) {
		this.unique = unique;
	}

	public String getSource() {
		return source;
	}

	public void setSource(String source) {
		this.source = source;
		this.sourceBytes = StringUtil.isEmpty(source)?null:source.getBytes(Charsets.UTF_8);
	}

	public byte[] getSourceBytes() {
		return sourceBytes;
	}

	public void setSourceBytes(byte[] sourceBytes) {
		this.sourceBytes = sourceBytes;
		this.source = sourceBytes==null?null:new String(sourceBytes,Charsets.UTF_8);
	}

	public String getOrigin() {
		return origin;
	}

	public void setOrigin(String origin) {
		this.origin = origin;
		this.originBytes = StringUtil.isEmpty(origin)?null:origin.getBytes(Charsets.UTF_8);
	}

	public byte[] getOriginBytes() {
		return originBytes;
	}

	public void setOriginBytes(byte[] originBytes) {
		this.originBytes = originBytes;
		this.origin = originBytes==null?null:new String(originBytes,Charsets.UTF_8);
	}
}