package cn.easyutil.easyapi.entity.db.auth;

import cn.easyutil.easyapi.entity.annotation.DDL;
import cn.easyutil.easyapi.entity.common.ApidocComment;
import cn.easyutil.easyapi.entity.db.doc.BaseDbEntity;
import com.baomidou.mybatisplus.annotation.TableName;

/**
 * 角色对应的权限
 */
@TableName("EASYAPI_USER_TEMPORARY_AUTH")
public class DBUserTemporaryAuthEntity extends BaseDbEntity {

    @DDL(value = "MODULE_ID",ddl = "`MODULE_ID` bigint(20) DEFAULT NULL COMMENT '模块id'")
    @ApidocComment("模块id")
    private Long moduleId;

    @DDL(value = "USER_ID",ddl = "`USER_ID` bigint(20) DEFAULT NULL COMMENT '用户id'")
    @ApidocComment("用户id")
    private Long userId;

    @DDL(value = "AUTH_CODE",ddl = "`AUTH_CODE` varchar(255) DEFAULT NULL COMMENT '可访问的接口编码'")
    @ApidocComment("可访问的接口编码")
    private String authCode;

    public Long getModuleId() {
        return moduleId;
    }

    public void setModuleId(Long moduleId) {
        this.moduleId = moduleId;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getAuthCode() {
        return authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }
}
